/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.core.TypeConverter;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModelInjector {
    ModelInjector() {
    }

    public static <T> T inject(Class<?> modelClass, HttpServletRequest request, boolean skipConvertError) {
        String modelName = modelClass.getSimpleName();
        return ModelInjector.inject(modelClass, StrKit.firstCharToLowerCase(modelName), request, skipConvertError);
    }

    public static final <T> T inject(Class<?> modelClass, String modelName, HttpServletRequest request, boolean skipConvertError) {
        T model = null;
        try {
            model = (T)modelClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (model instanceof Model) {
            ModelInjector.injectActiveRecordModel((Model)model, modelName, request, skipConvertError);
        } else {
            ModelInjector.injectCommonModel(model, modelName, request, modelClass, skipConvertError);
        }
        return model;
    }

    private static final void injectCommonModel(Object model, String modelName, HttpServletRequest request, Class<?> modelClass, boolean skipConvertError) {
        Method[] methods;
        Method[] methodArray = methods = modelClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Class<?>[] types;
                Method method = methodArray[n2];
                String methodName = method.getName();
                if (methodName.startsWith("set") && (types = method.getParameterTypes()).length == 1) {
                    String attrName = methodName.substring(3);
                    String value = request.getParameter(String.valueOf(modelName) + "." + StrKit.firstCharToLowerCase(attrName));
                    if (value != null) {
                        try {
                            method.invoke(model, TypeConverter.convert(types[0], value));
                        }
                        catch (Exception e) {
                            if (skipConvertError) break block5;
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static final void injectActiveRecordModel(Model<?> model, String modelName, HttpServletRequest request, boolean skipConvertError) {
        Table table = TableMapping.me().getTable(model.getClass());
        String modelNameAndDot = String.valueOf(modelName) + ".";
        Map parasMap = request.getParameterMap();
        for (Map.Entry e : parasMap.entrySet()) {
            String paraKey = (String)e.getKey();
            if (!paraKey.startsWith(modelNameAndDot)) continue;
            String paraName = paraKey.substring(modelNameAndDot.length());
            Class<?> colType = table.getColumnType(paraName);
            if (colType == null) {
                throw new ActiveRecordException("The model attribute " + paraKey + " is not exists.");
            }
            String[] paraValue = (String[])e.getValue();
            try {
                Object value = paraValue[0] != null ? TypeConverter.convert(colType, paraValue[0]) : null;
                model.set(paraName, value);
            }
            catch (Exception ex) {
                if (skipConvertError) continue;
                throw new RuntimeException("Can not convert parameter: " + modelNameAndDot + paraName, ex);
            }
        }
    }
}

