/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.core.Config;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeConverter {
    private static final int timeStampLen = "2011-01-18 16:18:18".length();
    private static final String timeStampPattern = "yyyy-MM-dd HH:mm:ss";
    private static final String datePattern = "yyyy-MM-dd";

    TypeConverter() {
    }

    public static final Object convert(Class<?> clazz, String s) throws ParseException {
        if (clazz == String.class) {
            return "".equals(s) ? null : s;
        }
        if ("".equals(s = s.trim())) {
            return null;
        }
        Object result = null;
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            result = Integer.parseInt(s);
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            result = Long.parseLong(s);
        } else if (clazz == Date.class) {
            result = s.length() >= timeStampLen ? new SimpleDateFormat(timeStampPattern).parse(s) : new SimpleDateFormat(datePattern).parse(s);
        } else if (clazz == java.sql.Date.class) {
            result = s.length() >= timeStampLen ? new java.sql.Date(new SimpleDateFormat(timeStampPattern).parse(s).getTime()) : new java.sql.Date(new SimpleDateFormat(datePattern).parse(s).getTime());
        } else if (clazz == Time.class) {
            result = Time.valueOf(s);
        } else if (clazz == Timestamp.class) {
            result = Timestamp.valueOf(s);
        } else if (clazz == Double.class) {
            result = Double.parseDouble(s);
        } else if (clazz == Float.class) {
            result = Float.valueOf(Float.parseFloat(s));
        } else if (clazz == Boolean.class) {
            result = Boolean.parseBoolean(s) || "1".equals(s);
        } else if (clazz == BigDecimal.class) {
            result = new BigDecimal(s);
        } else if (clazz == BigInteger.class) {
            result = new BigInteger(s);
        } else if (clazz == byte[].class) {
            result = s.getBytes();
        } else {
            if (Config.getConstants().getDevMode()) {
                throw new RuntimeException("Please add code in " + TypeConverter.class + ". The type can't be converted: " + clazz.getName());
            }
            throw new RuntimeException(String.valueOf(clazz.getName()) + " can not be converted, please use other type of attributes in your model!");
        }
        return result;
    }
}

