/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.core.Controller;
import java.util.HashSet;
import java.util.Set;

public class Restful
implements Interceptor {
    private static final String isRestfulForwardKey = "_isRestfulForward_";
    private Set<String> set = new HashSet<String>(){
        private static final long serialVersionUID = 2717581127375143508L;
        {
            this.add("show");
            this.add("save");
            this.add("update");
            this.add("delete");
        }
    };

    public void intercept(ActionInvocation ai) {
        Controller controller = ai.getController();
        Boolean isRestfulForward = (Boolean)controller.getAttr(isRestfulForwardKey);
        String methodName = ai.getMethodName();
        if (this.set.contains(methodName) && isRestfulForward == null) {
            ai.getController().renderError(404);
            return;
        }
        if (isRestfulForward != null && isRestfulForward.booleanValue()) {
            ai.invoke();
            return;
        }
        String controllerKey = ai.getControllerKey();
        String method = controller.getRequest().getMethod().toUpperCase();
        String urlPara = controller.getPara();
        if ("GET".equals(method)) {
            if (urlPara != null && !"edit".equals(methodName)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(String.valueOf(controllerKey) + "/show/" + urlPara);
                return;
            }
        } else {
            if ("POST".equals(method)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(String.valueOf(controllerKey) + "/save");
                return;
            }
            if ("PUT".equals(method)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(String.valueOf(controllerKey) + "/update/" + urlPara);
                return;
            }
            if ("DELETE".equals(method)) {
                controller.setAttr(isRestfulForwardKey, Boolean.TRUE);
                controller.forwardAction(String.valueOf(controllerKey) + "/delete/" + urlPara);
                return;
            }
        }
        ai.invoke();
    }
}

