/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.ModelBuilder;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import com.jfinal.plugin.activerecord.cache.ICache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model<M extends Model>
implements Serializable {
    private static final long serialVersionUID = -990334519496260591L;
    private Map<String, Object> attrs = this.getAttrsMap();
    private Set<String> modifyFlag;

    private Map<String, Object> getAttrsMap() {
        Config config = this.getConfig();
        if (config == null) {
            return DbKit.brokenConfig.containerFactory.getAttrsMap();
        }
        return config.containerFactory.getAttrsMap();
    }

    private Set<String> getModifyFlag() {
        if (this.modifyFlag == null) {
            Config config = this.getConfig();
            this.modifyFlag = config == null ? DbKit.brokenConfig.containerFactory.getModifyFlagSet() : config.containerFactory.getModifyFlagSet();
        }
        return this.modifyFlag;
    }

    private Config getConfig() {
        return DbKit.getConfig(this.getClass());
    }

    public Table getTable() {
        return TableMapping.me().getTable(this.getClass());
    }

    public boolean hasColumnLabel(String col) {
        return this.getTable().hasColumnLabel(col);
    }

    public M set(String attr, Object value) {
        if (this.getTable().hasColumnLabel(attr)) {
            this.attrs.put(attr, value);
            this.getModifyFlag().add(attr);
        }
        return (M)this;
    }

    public M put(String key, Object value) {
        this.attrs.put(key, value);
        return (M)this;
    }

    public <T> T get(String attr) {
        return (T)this.attrs.get(attr);
    }

    public <T> T get(String attr, Object defaultValue) {
        Object result = this.attrs.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public String getStr(String attr) {
        return (String)this.attrs.get(attr);
    }

    public Integer getInt(String attr) {
        return (Integer)this.attrs.get(attr);
    }

    public Long getLong(String attr) {
        return (Long)this.attrs.get(attr);
    }

    public BigInteger getBigInteger(String attr) {
        return (BigInteger)this.attrs.get(attr);
    }

    public Date getDate(String attr) {
        return (Date)this.attrs.get(attr);
    }

    public Time getTime(String attr) {
        return (Time)this.attrs.get(attr);
    }

    public Timestamp getTimestamp(String attr) {
        return (Timestamp)this.attrs.get(attr);
    }

    public Double getDouble(String attr) {
        return (Double)this.attrs.get(attr);
    }

    public Float getFloat(String attr) {
        return (Float)this.attrs.get(attr);
    }

    public Boolean getBoolean(String attr) {
        return (Boolean)this.attrs.get(attr);
    }

    public BigDecimal getBigDecimal(String attr) {
        return (BigDecimal)this.attrs.get(attr);
    }

    public byte[] getBytes(String attr) {
        return (byte[])this.attrs.get(attr);
    }

    public Number getNumber(String attr) {
        return (Number)this.attrs.get(attr);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        Config config = this.getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            Page<M> page = this.paginate(config, conn, pageNumber, pageSize, select, sqlExceptSelect, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private Page<M> paginate(Config config, Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws Exception {
        if (pageNumber < 1 || pageSize < 1) {
            throw new ActiveRecordException("pageNumber and pageSize must be more than 0");
        }
        if (config.dialect.isTakeOverModelPaginate()) {
            return config.dialect.takeOverModelPaginate(conn, this.getClass(), pageNumber, pageSize, select, sqlExceptSelect, paras);
        }
        long totalRow = 0L;
        int totalPage = 0;
        List result = Db.query(config, conn, "select count(*) " + DbKit.replaceFormatSqlOrderBy(sqlExceptSelect), paras);
        int size = result.size();
        if (size == 1) {
            totalRow = ((Number)result.get(0)).longValue();
        } else if (size > 1) {
            totalRow = result.size();
        } else {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        StringBuilder sql = new StringBuilder();
        config.dialect.forPaginate(sql, pageNumber, pageSize, select, sqlExceptSelect);
        List<M> list = this.find(conn, sql.toString(), paras);
        return new Page<M>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.paginate(pageNumber, pageSize, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    protected Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public Set<Map.Entry<String, Object>> getAttrsEntrySet() {
        return this.attrs.entrySet();
    }

    public boolean save() {
        Config config = this.getConfig();
        Table table = this.getTable();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forModelSave(table, this.attrs, sql, paras);
        Connection conn = null;
        PreparedStatement pst = null;
        int result = 0;
        try {
            conn = config.getConnection();
            pst = config.dialect.isOracle() ? conn.prepareStatement(sql.toString(), new String[]{table.getPrimaryKey()}) : conn.prepareStatement(sql.toString(), 1);
            config.dialect.fillStatement(pst, paras);
            result = pst.executeUpdate();
            this.getGeneratedKey(pst, table);
            this.getModifyFlag().clear();
            boolean bl = result >= 1;
            config.close(pst, conn);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new ActiveRecordException(e);
            }
            catch (Throwable throwable) {
                config.close(pst, conn);
                throw throwable;
            }
        }
    }

    private void getGeneratedKey(PreparedStatement pst, Table table) throws SQLException {
        ResultSet rs;
        String pKey = table.getPrimaryKey();
        if ((this.get(pKey) == null || this.getConfig().dialect.isOracle()) && (rs = pst.getGeneratedKeys()).next()) {
            Class<?> colType = table.getColumnType(pKey);
            if (colType == Integer.class || colType == Integer.TYPE) {
                this.set(pKey, rs.getInt(1));
            } else if (colType == Long.class || colType == Long.TYPE) {
                this.set(pKey, rs.getLong(1));
            } else {
                this.set(pKey, rs.getObject(1));
            }
            rs.close();
        }
    }

    public boolean delete() {
        Table table = this.getTable();
        Object id = this.attrs.get(table.getPrimaryKey());
        if (id == null) {
            throw new ActiveRecordException("You can't delete model without id.");
        }
        return this.deleteById(table, id);
    }

    public boolean deleteById(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        return this.deleteById(this.getTable(), id);
    }

    private boolean deleteById(Table table, Object id) {
        Config config = this.getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            String sql = config.dialect.forModelDeleteById(table);
            boolean bl = Db.update(config, conn, sql, id) >= 1;
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public boolean update() {
        if (this.getModifyFlag().isEmpty()) {
            return false;
        }
        Table table = this.getTable();
        String pKey = table.getPrimaryKey();
        Object id = this.attrs.get(pKey);
        if (id == null) {
            throw new ActiveRecordException("You can't update model without Primary Key.");
        }
        Config config = this.getConfig();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forModelUpdate(table, this.attrs, this.getModifyFlag(), pKey, id, sql, paras);
        if (paras.size() <= 1) {
            return false;
        }
        Connection conn = null;
        try {
            conn = config.getConnection();
            int result = Db.update(config, conn, sql.toString(), paras.toArray());
            if (result >= 1) {
                this.getModifyFlag().clear();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private List<M> find(Connection conn, String sql, Object ... paras) throws Exception {
        Config config = this.getConfig();
        Class<?> modelClass = this.getClass();
        if (config.devMode) {
            this.checkTableName(modelClass, sql);
        }
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        ResultSet rs = pst.executeQuery();
        List result = ModelBuilder.build(rs, modelClass);
        DbKit.closeQuietly(rs, pst);
        return result;
    }

    public List<M> find(String sql, Object ... paras) {
        Config config = this.getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            List<M> list = this.find(conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private void checkTableName(Class<? extends Model> modelClass, String sql) {
        Table table = TableMapping.me().getTable(modelClass);
        if (!sql.toLowerCase().contains(table.getName().toLowerCase())) {
            throw new ActiveRecordException("The table name: " + table.getName() + " not in your sql.");
        }
    }

    public List<M> find(String sql) {
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public M findFirst(String sql, Object ... paras) {
        List<M> result = this.find(sql, paras);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M findFirst(String sql) {
        List<M> result = this.find(sql, DbKit.NULL_PARA_ARRAY);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M findById(Object id) {
        return this.findById(id, "*");
    }

    public M findById(Object id, String columns) {
        Table table = this.getTable();
        String sql = this.getConfig().dialect.forModelFindById(table, columns);
        List<M> result = this.find(sql, id);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M setAttrs(M model) {
        return this.setAttrs(((Model)model).getAttrs());
    }

    public M setAttrs(Map<String, Object> attrs) {
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
        return (M)this;
    }

    public M remove(String attr) {
        this.attrs.remove(attr);
        this.getModifyFlag().remove(attr);
        return (M)this;
    }

    public M remove(String ... attrs) {
        if (attrs != null) {
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                this.attrs.remove(a);
                this.getModifyFlag().remove(a);
                ++n2;
            }
        }
        return (M)this;
    }

    public M removeNullValueAttrs() {
        Iterator<Map.Entry<String, Object>> it = this.attrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
            this.getModifyFlag().remove(e.getKey());
        }
        return (M)this;
    }

    public M keep(String ... attrs) {
        if (attrs != null && attrs.length > 0) {
            Config config = this.getConfig();
            Map newAttrs = config.containerFactory.getAttrsMap();
            Set newModifyFlag = config.containerFactory.getModifyFlagSet();
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                if (this.attrs.containsKey(a)) {
                    newAttrs.put(a, this.attrs.get(a));
                }
                if (this.getModifyFlag().contains(a)) {
                    newModifyFlag.add(a);
                }
                ++n2;
            }
            this.attrs = newAttrs;
            this.modifyFlag = newModifyFlag;
        } else {
            this.attrs.clear();
            this.getModifyFlag().clear();
        }
        return (M)this;
    }

    public M keep(String attr) {
        if (this.attrs.containsKey(attr)) {
            Object keepIt = this.attrs.get(attr);
            boolean keepFlag = this.getModifyFlag().contains(attr);
            this.attrs.clear();
            this.getModifyFlag().clear();
            this.attrs.put(attr, keepIt);
            if (keepFlag) {
                this.getModifyFlag().add(attr);
            }
        } else {
            this.attrs.clear();
            this.getModifyFlag().clear();
        }
        return (M)this;
    }

    public M clear() {
        this.attrs.clear();
        this.getModifyFlag().clear();
        return (M)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" {");
        boolean first = true;
        for (Map.Entry<String, Object> e : this.attrs.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(":").append(value);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Model)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.attrs.equals(((Model)o).attrs);
    }

    public int hashCode() {
        return (this.attrs == null ? 0 : this.attrs.hashCode()) ^ (this.getModifyFlag() == null ? 0 : this.getModifyFlag().hashCode());
    }

    public List<M> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this.getConfig().getCache();
        List<M> result = (List<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public List<M> findByCache(String cacheName, Object key, String sql) {
        return this.findByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        ICache cache = this.getConfig().getCache();
        Page<M> result = (Page<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.paginate(pageNumber, pageSize, select, sqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public String[] getAttrNames() {
        Set<String> attrNameSet = this.attrs.keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] getAttrValues() {
        Collection<Object> attrValueCollection = this.attrs.values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public String toJson() {
        return JsonKit.toJson(this.attrs, 4);
    }
}

