/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Model;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private String name;
    private String primaryKey;
    private String secondaryKey = null;
    private Map<String, Class<?>> columnTypeMap;
    private Class<? extends Model<?>> modelClass;

    public Table(String name, Class<? extends Model<?>> modelClass) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Table name can not be blank.");
        }
        if (modelClass == null) {
            throw new IllegalArgumentException("Model class can not be null.");
        }
        this.name = name.trim();
        this.modelClass = modelClass;
    }

    public Table(String name, String primaryKey, Class<? extends Model<?>> modelClass) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Table name can not be blank.");
        }
        if (StrKit.isBlank(primaryKey)) {
            throw new IllegalArgumentException("Primary key can not be blank.");
        }
        if (modelClass == null) {
            throw new IllegalArgumentException("Model class can not be null.");
        }
        this.name = name.trim();
        this.setPrimaryKey(primaryKey.trim());
        this.modelClass = modelClass;
    }

    void setPrimaryKey(String primaryKey) {
        String[] keyArr = primaryKey.split(",");
        if (keyArr.length > 1) {
            if (StrKit.isBlank(keyArr[0]) || StrKit.isBlank(keyArr[1])) {
                throw new IllegalArgumentException("The composite primary key can not be blank.");
            }
            this.primaryKey = keyArr[0].trim();
            this.secondaryKey = keyArr[1].trim();
        } else {
            this.primaryKey = primaryKey;
        }
    }

    void setColumnTypeMap(Map<String, Class<?>> columnTypeMap) {
        if (columnTypeMap == null) {
            throw new IllegalArgumentException("columnTypeMap can not be null");
        }
        this.columnTypeMap = columnTypeMap;
    }

    public String getName() {
        return this.name;
    }

    public void setColumnType(String columnLabel, Class<?> columnType) {
        this.columnTypeMap.put(columnLabel, columnType);
    }

    public Class<?> getColumnType(String columnLabel) {
        return this.columnTypeMap.get(columnLabel);
    }

    public boolean hasColumnLabel(String columnLabel) {
        return this.columnTypeMap.containsKey(columnLabel);
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    public Class<? extends Model<?>> getModelClass() {
        return this.modelClass;
    }
}

