/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableBuilder {
    TableBuilder() {
    }

    static boolean build(List<Table> tableList, Config config) {
        Table temp = null;
        Connection conn = null;
        try {
            conn = config.dataSource.getConnection();
            TableMapping tableMapping = TableMapping.me();
            Iterator<Table> iterator = tableList.iterator();
            while (iterator.hasNext()) {
                Table table;
                temp = table = iterator.next();
                TableBuilder.doBuild(table, conn, config);
                tableMapping.putTable(table);
                DbKit.addModelToConfigMapping(table.getModelClass(), config);
            }
            return true;
        }
        catch (Exception e) {
            if (temp != null) {
                System.err.println("Can not create Table object, maybe the table " + temp.getName() + " is not exists.");
            }
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private static void doBuild(Table table, Connection conn, Config config) throws SQLException {
        table.setColumnTypeMap(config.containerFactory.getAttrsMap());
        if (table.getPrimaryKey() == null) {
            table.setPrimaryKey(config.dialect.getDefaultPrimaryKey());
        }
        String sql = config.dialect.forTableBuilderDoBuild(table.getName());
        Statement stm = conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            String colName = rsmd.getColumnName(i);
            String colClassName = rsmd.getColumnClassName(i);
            if ("java.lang.String".equals(colClassName)) {
                table.setColumnType(colName, String.class);
            } else if ("java.lang.Integer".equals(colClassName)) {
                table.setColumnType(colName, Integer.class);
            } else if ("java.lang.Long".equals(colClassName)) {
                table.setColumnType(colName, Long.class);
            } else if ("java.sql.Date".equals(colClassName)) {
                table.setColumnType(colName, Date.class);
            } else if ("java.lang.Double".equals(colClassName)) {
                table.setColumnType(colName, Double.class);
            } else if ("java.lang.Float".equals(colClassName)) {
                table.setColumnType(colName, Float.class);
            } else if ("java.lang.Boolean".equals(colClassName)) {
                table.setColumnType(colName, Boolean.class);
            } else if ("java.sql.Time".equals(colClassName)) {
                table.setColumnType(colName, Time.class);
            } else if ("java.sql.Timestamp".equals(colClassName)) {
                table.setColumnType(colName, Timestamp.class);
            } else if ("java.math.BigDecimal".equals(colClassName)) {
                table.setColumnType(colName, BigDecimal.class);
            } else if ("[B".equals(colClassName)) {
                table.setColumnType(colName, byte[].class);
            } else {
                int type = rsmd.getColumnType(i);
                if (type == 2004) {
                    table.setColumnType(colName, byte[].class);
                } else if (type == 2005 || type == 2011) {
                    table.setColumnType(colName, String.class);
                } else {
                    table.setColumnType(colName, String.class);
                }
            }
            ++i;
        }
        rs.close();
        stm.close();
    }
}

