/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.dialect;

import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.ModelBuilder;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnsiSqlDialect
extends Dialect {
    @Override
    public String forTableBuilderDoBuild(String tableName) {
        return "select * from " + tableName + " where 1 = 2";
    }

    @Override
    public void forModelSave(Table table, Map<String, Object> attrs, StringBuilder sql, List<Object> paras) {
        sql.append("insert into ").append(table.getName()).append("(");
        StringBuilder temp = new StringBuilder(") values(");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(colName);
            temp.append("?");
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public String forModelDeleteById(Table table) {
        String pKey = table.getPrimaryKey();
        StringBuilder sql = new StringBuilder(45);
        sql.append("delete from ");
        sql.append(table.getName());
        sql.append(" where ").append(pKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public void forModelUpdate(Table table, Map<String, Object> attrs, Set<String> modifyFlag, String pKey, Object id, StringBuilder sql, List<Object> paras) {
        sql.append("update ").append(table.getName()).append(" set ");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (pKey.equalsIgnoreCase(colName) || !modifyFlag.contains(colName) || !table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ").append(pKey).append(" = ?");
        paras.add(id);
    }

    @Override
    public String forModelFindById(Table table, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            int i = 0;
            while (i < columnsArray.length) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(columnsArray[i].trim());
                ++i;
            }
        }
        sql.append(" from ");
        sql.append(table.getName());
        sql.append(" where ").append(table.getPrimaryKey()).append(" = ?");
        return sql.toString();
    }

    @Override
    public String forDbFindById(String tableName, String primaryKey, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            int i = 0;
            while (i < columnsArray.length) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(columnsArray[i].trim());
                ++i;
            }
        }
        sql.append(" from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String primaryKey) {
        StringBuilder sql = new StringBuilder("delete from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public void forDbSave(StringBuilder sql, List<Object> paras, String tableName, Record record) {
        sql.append("insert into ");
        sql.append(tableName.trim()).append("(");
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(e.getKey());
            temp.append("?");
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public void forDbUpdate(String tableName, String primaryKey, Object id, Record record, StringBuilder sql, List<Object> paras) {
        sql.append("update ").append(tableName.trim()).append(" set ");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (primaryKey.equalsIgnoreCase(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ").append(primaryKey).append(" = ?");
        paras.add(id);
    }

    @Override
    public void forPaginate(StringBuilder sql, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        throw new ActiveRecordException("Your should not invoke this method because takeOverDbPaginate(...) will take over it.");
    }

    @Override
    public boolean isTakeOverDbPaginate() {
        return true;
    }

    @Override
    public Page<Record> takeOverDbPaginate(Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws SQLException {
        long totalRow = 0L;
        int totalPage = 0;
        List result = CPI.query(conn, "select count(*) " + DbKit.replaceFormatSqlOrderBy(sqlExceptSelect), paras);
        int size = result.size();
        if (size == 1) {
            totalRow = ((Number)result.get(0)).longValue();
        } else if (size > 1) {
            totalRow = result.size();
        } else {
            return new Page<Record>(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(select).append(" ").append(sqlExceptSelect);
        PreparedStatement pst = conn.prepareStatement(sql.toString(), 1003, 1007);
        int i = 0;
        while (i < paras.length) {
            pst.setObject(i + 1, paras[i]);
            ++i;
        }
        ResultSet rs = pst.executeQuery();
        int offset = pageSize * (pageNumber - 1);
        int i2 = 0;
        while (i2 < offset) {
            if (!rs.next()) break;
            ++i2;
        }
        List<Record> list = this.buildRecord(rs, pageSize);
        if (rs != null) {
            rs.close();
        }
        if (pst != null) {
            pst.close();
        }
        return new Page<Record>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    private List<Record> buildRecord(ResultSet rs, int pageSize) throws SQLException {
        ArrayList<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        int k = 0;
        while (k < pageSize && rs.next()) {
            Record record = new Record();
            Map<String, Object> columns = record.getColumns();
            int i = 1;
            while (i <= columnCount) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? ModelBuilder.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                columns.put(labelNames[i], value);
                ++i;
            }
            result.add(record);
            ++k;
        }
        return result;
    }

    private void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        int i = 1;
        while (i < labelNames.length) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
            ++i;
        }
    }

    @Override
    public boolean isTakeOverModelPaginate() {
        return true;
    }

    @Override
    public Page<? extends Model> takeOverModelPaginate(Connection conn, Class<? extends Model> modelClass, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws Exception {
        long totalRow = 0L;
        int totalPage = 0;
        List result = CPI.query(conn, "select count(*) " + DbKit.replaceFormatSqlOrderBy(sqlExceptSelect), paras);
        int size = result.size();
        if (size == 1) {
            totalRow = ((Number)result.get(0)).longValue();
        } else if (size > 1) {
            totalRow = result.size();
        } else {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(select).append(" ").append(sqlExceptSelect);
        PreparedStatement pst = conn.prepareStatement(sql.toString(), 1003, 1007);
        int i = 0;
        while (i < paras.length) {
            pst.setObject(i + 1, paras[i]);
            ++i;
        }
        ResultSet rs = pst.executeQuery();
        int offset = pageSize * (pageNumber - 1);
        int i2 = 0;
        while (i2 < offset) {
            if (!rs.next()) break;
            ++i2;
        }
        List list = this.buildModel(rs, modelClass, pageSize);
        if (rs != null) {
            rs.close();
        }
        if (pst != null) {
            pst.close();
        }
        return new Page(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    public final <T> List<T> buildModel(ResultSet rs, Class<? extends Model> modelClass, int pageSize) throws SQLException, InstantiationException, IllegalAccessException {
        ArrayList<Model> result = new ArrayList<Model>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        int k = 0;
        while (k < pageSize && rs.next()) {
            Model ar = modelClass.newInstance();
            Map<String, Object> attrs = CPI.getAttrs(ar);
            int i = 1;
            while (i <= columnCount) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? ModelBuilder.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                attrs.put(labelNames[i], value);
                ++i;
            }
            result.add(ar);
            ++k;
        }
        return result;
    }
}

