/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.tx;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.jfinal.plugin.activerecord.tx.TxConfig;
import java.sql.Connection;
import java.sql.SQLException;

public class Tx
implements Interceptor {
    static Config getConfigWithTxConfig(ActionInvocation ai) {
        TxConfig txConfig = ai.getMethod().getAnnotation(TxConfig.class);
        if (txConfig == null) {
            txConfig = ai.getController().getClass().getAnnotation(TxConfig.class);
        }
        if (txConfig != null) {
            Config config = DbKit.getConfig(txConfig.value());
            if (config == null) {
                throw new RuntimeException("Config not found with TxConfig");
            }
            return config;
        }
        return null;
    }

    protected int getTransactionLevel(Config config) {
        return config.getTransactionLevel();
    }

    public void intercept(ActionInvocation ai) {
        Connection conn;
        Config config = Tx.getConfigWithTxConfig(ai);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if ((conn = config.getThreadLocalConnection()) != null) {
            try {
                if (conn.getTransactionIsolation() < this.getTransactionLevel(config)) {
                    conn.setTransactionIsolation(this.getTransactionLevel(config));
                }
                ai.invoke();
                return;
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            try {
                conn = config.getConnection();
                autoCommit = conn.getAutoCommit();
                config.setThreadLocalConnection(conn);
                conn.setTransactionIsolation(this.getTransactionLevel(config));
                conn.setAutoCommit(false);
                ai.invoke();
                conn.commit();
            }
            catch (NestedTransactionHelpException e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    try {
                        if (conn != null) {
                            if (autoCommit != null) {
                                conn.setAutoCommit(autoCommit);
                            }
                            conn.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        config.removeThreadLocalConnection();
                    }
                }
                finally {
                    config.removeThreadLocalConnection();
                }
            }
            catch (Exception e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                throw new ActiveRecordException(e);
            }
        }
        finally {
            block37: {
                try {
                    try {
                        if (conn != null) {
                            if (autoCommit != null) {
                                conn.setAutoCommit(autoCommit);
                            }
                            conn.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        config.removeThreadLocalConnection();
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    config.removeThreadLocalConnection();
                    throw throwable;
                }
                config.removeThreadLocalConnection();
            }
        }
    }
}

