/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.tx;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.DbPro;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.tx.Tx;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class TxByRegex
implements Interceptor {
    private Pattern pattern;

    public TxByRegex(String regex) {
        this(regex, true);
    }

    public TxByRegex(String regex, boolean caseSensitive) {
        if (StrKit.isBlank(regex)) {
            throw new IllegalArgumentException("regex can not be blank.");
        }
        this.pattern = caseSensitive ? Pattern.compile(regex) : Pattern.compile(regex, 2);
    }

    public void intercept(final ActionInvocation ai) {
        Config config = Tx.getConfigWithTxConfig(ai);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if (this.pattern.matcher(ai.getActionKey()).matches()) {
            DbPro.use(config.getName()).tx(new IAtom(){

                public boolean run() throws SQLException {
                    ai.invoke();
                    return true;
                }
            });
        } else {
            ai.invoke();
        }
    }
}

