/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.ehcache;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.plugin.ehcache.CacheKit;
import com.jfinal.plugin.ehcache.CacheName;

public class EvictInterceptor
implements Interceptor {
    public final void intercept(ActionInvocation ai) {
        ai.invoke();
        CacheKit.removeAll(this.buildCacheName(ai));
    }

    private String buildCacheName(ActionInvocation ai) {
        CacheName cacheName = ai.getMethod().getAnnotation(CacheName.class);
        if (cacheName != null) {
            return cacheName.value();
        }
        cacheName = ai.getController().getClass().getAnnotation(CacheName.class);
        if (cacheName == null) {
            throw new RuntimeException("EvictInterceptor need CacheName annotation in controller.");
        }
        return cacheName.value();
    }
}

