/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.kit.PathKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletContext;

public class FileRender
extends Render {
    private static final long serialVersionUID = 4293616220202691369L;
    private File file;
    private String fileName;
    private static String fileDownloadPath;
    private static ServletContext servletContext;
    private static String webRootPath;

    public FileRender(File file) {
        this.file = file;
    }

    public FileRender(String fileName) {
        this.fileName = fileName;
    }

    static void init(String fileDownloadPath, ServletContext servletContext) {
        FileRender.fileDownloadPath = fileDownloadPath;
        FileRender.servletContext = servletContext;
        webRootPath = PathKit.getWebRootPath();
    }

    public void render() {
        if (this.fileName != null) {
            this.file = this.fileName.startsWith("/") ? new File(String.valueOf(webRootPath) + this.fileName) : new File(String.valueOf(fileDownloadPath) + this.fileName);
        }
        if (this.file == null || !this.file.isFile() || this.file.length() > Integer.MAX_VALUE) {
            RenderFactory.me().getErrorRender(404).setContext(this.request, this.response).render();
            return;
        }
        try {
            this.response.addHeader("Content-disposition", "attachment; filename=" + new String(this.file.getName().getBytes("GBK"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            this.response.addHeader("Content-disposition", "attachment; filename=" + this.file.getName());
        }
        String contentType = servletContext.getMimeType(this.file.getName());
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        this.response.setContentType(contentType);
        this.response.setContentLength((int)this.file.length());
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(this.file));
                outputStream = this.response.getOutputStream();
                byte[] buffer = new byte[1024];
                int n = -1;
                while ((n = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, n);
                }
                outputStream.flush();
            }
            catch (Exception e) {
                throw new RenderException(e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

