/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;

public class HtmlRender
extends Render {
    private static final long serialVersionUID = 8145891655998147406L;
    private static final String contentType = "text/html;charset=" + HtmlRender.getEncoding();
    private String text;

    public HtmlRender(String text) {
        this.text = text;
    }

    public void render() {
        PrintWriter writer = null;
        try {
            try {
                this.response.setHeader("Pragma", "no-cache");
                this.response.setHeader("Cache-Control", "no-cache");
                this.response.setDateHeader("Expires", 0L);
                this.response.setContentType(contentType);
                writer = this.response.getWriter();
                writer.write(this.text);
                writer.flush();
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

