/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.kit.JsonKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;

public class JsonRender
extends Render {
    private static final long serialVersionUID = 3606364198859021837L;
    private static final String contentType = "application/json;charset=" + JsonRender.getEncoding();
    private static final String contentTypeForIE = "text/html;charset=" + JsonRender.getEncoding();
    private boolean forIE = false;
    private static int convertDepth = 8;
    private String jsonText;
    private String[] attrs;

    public JsonRender forIE() {
        this.forIE = true;
        return this;
    }

    public JsonRender() {
    }

    public JsonRender(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter key can not be null.");
        }
        this.jsonText = JsonKit.mapToJson(new HashMap<String, Object>(key, value){
            {
                this.put(string, object);
            }
        }, convertDepth);
    }

    public JsonRender(String[] attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException("The parameter attrs can not be null.");
        }
        this.attrs = attrs;
    }

    public JsonRender(String jsonText) {
        if (jsonText == null) {
            throw new IllegalArgumentException("The parameter jsonString can not be null.");
        }
        this.jsonText = jsonText;
    }

    public JsonRender(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The parameter object can not be null.");
        }
        this.jsonText = JsonKit.toJson(object, convertDepth);
    }

    public static void setConvertDepth(int convertDepth) {
        if (convertDepth < 2) {
            throw new IllegalArgumentException("convert depth can not less than 2.");
        }
        JsonRender.convertDepth = convertDepth;
    }

    public void render() {
        if (this.jsonText == null) {
            this.buildJsonText();
        }
        PrintWriter writer = null;
        try {
            try {
                this.response.setHeader("Pragma", "no-cache");
                this.response.setHeader("Cache-Control", "no-cache");
                this.response.setDateHeader("Expires", 0L);
                this.response.setContentType(this.forIE ? contentTypeForIE : contentType);
                writer = this.response.getWriter();
                writer.write(this.jsonText);
                writer.flush();
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void buildJsonText() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.attrs != null) {
            String[] stringArray = this.attrs;
            int n = this.attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                map.put(key, this.request.getAttribute(key));
                ++n2;
            }
        } else {
            Enumeration attrs = this.request.getAttributeNames();
            while (attrs.hasMoreElements()) {
                String key = (String)attrs.nextElement();
                Object value = this.request.getAttribute(key);
                map.put(key, value);
            }
        }
        this.jsonText = JsonKit.mapToJson(map, convertDepth);
    }
}

