/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.core.JFinal;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;

public class RedirectRender
extends Render {
    private static final long serialVersionUID = 1812102713097864255L;
    private String url;
    private boolean withQueryString;
    private static final String contextPath = RedirectRender.getContxtPath();

    static String getContxtPath() {
        String cp = JFinal.me().getContextPath();
        return "".equals(cp) || "/".equals(cp) ? null : cp;
    }

    public RedirectRender(String url) {
        this.url = url;
        this.withQueryString = false;
    }

    public RedirectRender(String url, boolean withQueryString) {
        this.url = url;
        this.withQueryString = withQueryString;
    }

    public void render() {
        String queryString;
        if (contextPath != null && this.url.indexOf("://") == -1) {
            this.url = String.valueOf(contextPath) + this.url;
        }
        if (this.withQueryString && (queryString = this.request.getQueryString()) != null) {
            this.url = this.url.indexOf("?") == -1 ? String.valueOf(this.url) + "?" + queryString : String.valueOf(this.url) + "&" + queryString;
        }
        try {
            this.response.sendRedirect(this.url);
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }
}

