/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server;

import com.jfinal.kit.FileKit;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.server.IServer;
import com.jfinal.server.JFinalClassLoader;
import com.jfinal.server.Scanner;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.webapp.WebAppContext;

class JettyServer
implements IServer {
    private String webAppDir;
    private int port;
    private String context;
    private int scanIntervalSeconds;
    private boolean running = false;
    private Server server;
    private WebAppContext webApp;

    JettyServer(String webAppDir, int port, String context, int scanIntervalSeconds) {
        if (webAppDir == null) {
            throw new IllegalStateException("Invalid webAppDir of web server: " + webAppDir);
        }
        if (port < 0 || port > 65536) {
            throw new IllegalArgumentException("Invalid port of web server: " + port);
        }
        if (StrKit.isBlank(context)) {
            throw new IllegalStateException("Invalid context of web server: " + context);
        }
        this.webAppDir = webAppDir;
        this.port = port;
        this.context = context;
        this.scanIntervalSeconds = scanIntervalSeconds;
    }

    public void start() {
        if (!this.running) {
            try {
                this.doStart();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.running = false;
        }
    }

    private void doStart() {
        if (!JettyServer.available(this.port)) {
            throw new IllegalStateException("port: " + this.port + " already in use!");
        }
        this.deleteSessionData();
        System.out.println("Starting JFinal 1.8");
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        this.webApp = new WebAppContext();
        this.webApp.setContextPath(this.context);
        this.webApp.setResourceBase(this.webAppDir);
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.persistSession(this.webApp);
        this.server.setHandler((Handler)this.webApp);
        this.changeClassLoader(this.webApp);
        if (this.scanIntervalSeconds > 0) {
            Scanner scanner = new Scanner(PathKit.getRootClassPath(), this.scanIntervalSeconds){

                public void onChange() {
                    try {
                        System.err.println("\nLoading changes ......");
                        JettyServer.this.webApp.stop();
                        JFinalClassLoader loader = new JFinalClassLoader(JettyServer.this.webApp, JettyServer.this.getClassPath());
                        JettyServer.this.webApp.setClassLoader((ClassLoader)((Object)loader));
                        JettyServer.this.webApp.start();
                        System.err.println("Loading complete.");
                    }
                    catch (Exception e) {
                        System.err.println("Error reconfiguring/restarting webapp after change in watched files");
                        e.printStackTrace();
                    }
                }
            };
            System.out.println("Starting scanner at interval of " + this.scanIntervalSeconds + " seconds.");
            scanner.start();
        }
        try {
            System.out.println("Starting web server on port: " + this.port);
            this.server.start();
            System.out.println("Starting Complete. Welcome To The JFinal World :)");
            this.server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    private void changeClassLoader(WebAppContext webApp) {
        try {
            String classPath = this.getClassPath();
            JFinalClassLoader wacl = new JFinalClassLoader(webApp, classPath);
            wacl.addClassPath(classPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getClassPath() {
        return System.getProperty("java.class.path");
    }

    private void deleteSessionData() {
        try {
            FileKit.delete(new File(this.getStoreDir()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getStoreDir() {
        String storeDir = String.valueOf(PathKit.getWebRootPath()) + "/../../session_data" + this.context;
        if ("\\".equals(File.separator)) {
            storeDir = storeDir.replaceAll("/", "\\\\");
        }
        return storeDir;
    }

    private void persistSession(WebAppContext webApp) {
        String storeDir = this.getStoreDir();
        SessionManager sm = webApp.getSessionHandler().getSessionManager();
        if (sm instanceof HashSessionManager) {
            ((HashSessionManager)sm).setStoreDirectory(new File(storeDir));
            return;
        }
        HashSessionManager hsm = new HashSessionManager();
        hsm.setStoreDirectory(new File(storeDir));
        SessionHandler sh = new SessionHandler();
        sh.setSessionManager((SessionManager)hsm);
        webApp.setSessionHandler(sh);
    }

    private static boolean available(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            return true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

