/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.validate;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.core.Controller;
import com.jfinal.validate.ValidateException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Validator
implements Interceptor {
    private Controller controller;
    private ActionInvocation invocation;
    private boolean shortCircuit = false;
    private boolean invalid = false;
    private static final String emailAddressPattern = "\\b(^['_A-Za-z0-9-]+(\\.['_A-Za-z0-9-]+)*@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))$)\\b";
    private static final String datePattern = "yyyy-MM-dd";

    protected void setShortCircuit(boolean shortCircuit) {
        this.shortCircuit = shortCircuit;
    }

    public final void intercept(ActionInvocation invocation) {
        Validator validator = null;
        try {
            validator = (Validator)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        validator.controller = invocation.getController();
        validator.invocation = invocation;
        try {
            validator.validate(validator.controller);
        }
        catch (ValidateException validateException) {
            // empty catch block
        }
        if (validator.invalid) {
            validator.handleError(validator.controller);
        } else {
            invocation.invoke();
        }
    }

    protected abstract void validate(Controller var1);

    protected abstract void handleError(Controller var1);

    protected void addError(String errorKey, String errorMessage) {
        this.invalid = true;
        this.controller.setAttr(errorKey, errorMessage);
        if (this.shortCircuit) {
            throw new ValidateException();
        }
    }

    protected String getActionKey() {
        return this.invocation.getActionKey();
    }

    protected String getControllerKey() {
        return this.invocation.getControllerKey();
    }

    protected Method getActionMethod() {
        return this.invocation.getMethod();
    }

    protected String getViewPath() {
        return this.invocation.getViewPath();
    }

    protected void validateRequired(String field, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (value == null || "".equals(value)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRequiredString(String field, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (value == null || "".equals(value.trim())) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateInteger(String field, int min, int max, String errorKey, String errorMessage) {
        try {
            String value = this.controller.getPara(field);
            int temp = Integer.parseInt(value);
            if (temp < min || temp > max) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateLong(String field, long min, long max, String errorKey, String errorMessage) {
        try {
            String value = this.controller.getPara(field);
            long temp = Long.parseLong(value);
            if (temp < min || temp > max) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateLong(String field, String errorKey, String errorMessage) {
        try {
            String value = this.controller.getPara(field);
            Long.parseLong(value);
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDouble(String field, double min, double max, String errorKey, String errorMessage) {
        try {
            String value = this.controller.getPara(field);
            double temp = Double.parseDouble(value);
            if (temp < min || temp > max) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDouble(String field, String errorKey, String errorMessage) {
        try {
            String value = this.controller.getPara(field);
            Double.parseDouble(value);
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDate(String field, Date min, Date max, String errorKey, String errorMessage) {
        try {
            String value = this.controller.getPara(field);
            Date temp = new SimpleDateFormat(datePattern).parse(value);
            if (temp.before(min) || temp.after(max)) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDate(String field, String min, String max, String errorKey, String errorMessage) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
            this.validateDate(field, sdf.parse(min), sdf.parse(max), errorKey, errorMessage);
        }
        catch (ParseException e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEqualField(String field_1, String field_2, String errorKey, String errorMessage) {
        String value_1 = this.controller.getPara(field_1);
        String value_2 = this.controller.getPara(field_2);
        if (value_1 == null || value_2 == null || !value_1.equals(value_2)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEqualString(String s1, String s2, String errorKey, String errorMessage) {
        if (s1 == null || s2 == null || !s1.equals(s2)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEqualInteger(Integer i1, Integer i2, String errorKey, String errorMessage) {
        if (i1 == null || i2 == null || i1.intValue() != i2.intValue()) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEmail(String field, String errorKey, String errorMessage) {
        this.validateRegex(field, emailAddressPattern, false, errorKey, errorMessage);
    }

    protected void validateUrl(String field, String errorKey, String errorMessage) {
        try {
            String value = this.controller.getPara(field);
            if (value.startsWith("https://")) {
                value = "http://" + value.substring(8);
            }
            new URL(value);
        }
        catch (MalformedURLException e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRegex(String field, String regExpression, boolean isCaseSensitive, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (value == null) {
            this.addError(errorKey, errorMessage);
            return;
        }
        Pattern pattern = isCaseSensitive ? Pattern.compile(regExpression) : Pattern.compile(regExpression, 2);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRegex(String field, String regExpression, String errorKey, String errorMessage) {
        this.validateRegex(field, regExpression, true, errorKey, errorMessage);
    }

    protected void validateString(String field, boolean notBlank, int minLen, int maxLen, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (value == null || value.length() < minLen || value.length() > maxLen) {
            this.addError(errorKey, errorMessage);
        } else if (notBlank && "".equals(value.trim())) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateString(String field, int minLen, int maxLen, String errorKey, String errorMessage) {
        this.validateString(field, true, minLen, maxLen, errorKey, errorMessage);
    }

    protected void validateToken(String tokenName, String errorKey, String errorMessage) {
        if (!this.controller.validateToken(tokenName)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateToken(String errorKey, String errorMessage) {
        if (!this.controller.validateToken()) {
            this.addError(errorKey, errorMessage);
        }
    }
}

