/*
 * CommanTools.java
 * @version 1.0 2012-4-13 YangMo
 * Copyright 2011 FreshView Tech Co. Ltd.
 * All right reserved.
 */

package net.loyin.ctrl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 文件上传工具类
 * @version 1.0 2012-4-13
 * @author YangMO
 */
public class UploadTools {
	
	private static String hexStr =  "0123456789ABCDEF";   

	public static String uploadFile(File file, String fileName,String dir) {

		String returnName = "";
		try {
			InputStream in = new FileInputStream(file);
			File fileDir = new File(dir);
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
			fileDir.setReadable(true, false);
			fileDir.setExecutable(true, false);
			File uploadFile = new File(dir, fileName);
			OutputStream out = new FileOutputStream(uploadFile);
			uploadFile.setReadable(true, false);

			byte[] buffer = new byte[1024 * 1024];
			int length;
			while ((length = in.read(buffer)) > 0) {
				out.write(buffer, 0, length);
			}
			in.close();
			out.close();
		} catch (Exception ex) {
			ex.printStackTrace();
			return "";
		}
		return returnName;
	}
	
	/**  
     * @param hexString  
     * @return 将十六进制转换为字节数组  
     */  
    public static byte[] HexStringToBinary(String hexString){   
        //hexString的长度对2取整，作为bytes的长度   
        int len = hexString.length()/2;   
        byte[] bytes = new byte[len];   
        byte high = 0;//字节高四位   
        byte low = 0;//字节低四位   
  
        for(int i=0;i<len;i++){   
             //右移四位得到高位   
             high = (byte)((hexStr.indexOf(hexString.charAt(2*i)))<<4);   
             low = (byte)hexStr.indexOf(hexString.charAt(2*i+1));   
             bytes[i] = (byte) (high|low);//高地位做或运算   
        }   
        return bytes;   
    }   

    public static void saveAvatar(String dir,String userId,int type,String fileStr)
    {
    	try {			
    		byte[] bytes =HexStringToBinary(fileStr);
			File uploadFile = new File(dir,userId+"_"+type+".jpg");
			OutputStream out = new FileOutputStream(uploadFile);
			out.write(bytes);
			out.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
    }
    
	public static void main(String []args)
	{
		String tt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
		byte[] bytes =HexStringToBinary(tt);
		try {
			File uploadFile = new File("d:\\temp\\1.jpg");
			OutputStream out = new FileOutputStream(uploadFile);
			out.write(bytes);
			out.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
