/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;

public class B2CAgentPaymentRequest
extends TrxRequest {
    private String iRequestDate = "";
    private String iRequestTime = "";
    private String iOrderNo = "";
    private int iExpiredDate = 30;
    private String iCertificateNo = "";
    private String iCurrency = "";
    private String iAmount = "";
    private String iProductId = "";
    private String iProductName = "";
    private String iQuantity = "";
    private String iAgentSignNo = "";

    public String getIProductName() {
        return this.iProductName;
    }

    public void setIProductName(String productName) {
        this.iProductName = productName;
    }

    public String getIQuantity() {
        return this.iQuantity;
    }

    public void setIQuantity(String quantity) {
        this.iQuantity = quantity;
    }

    public String getICurrency() {
        return this.iCurrency;
    }

    public void setICurrency(String currency) {
        this.iCurrency = currency;
    }

    public String getIAmount() {
        return this.iAmount;
    }

    public void setIAmount(String amount) {
        this.iAmount = amount;
    }

    public String getIProductId() {
        return this.iProductId;
    }

    public void setIProductId(String productId) {
        this.iProductId = productId;
    }

    public B2CAgentPaymentRequest() {
        super("B2C");
    }

    public B2CAgentPaymentRequest(XMLDocument aXMLDocument) {
        super("B2C");
        this.setIRequestDate(aXMLDocument.getValueNoNull("OrderDate"));
        this.setIRequestTime(aXMLDocument.getValueNoNull("OrderTime"));
        this.setIOrderNo(aXMLDocument.getValueNoNull("OrderNo"));
        this.setIExpiredDate(Integer.parseInt(aXMLDocument.getValueNoNull("ExpiredDate")));
        this.setICertificateNo(aXMLDocument.getValueNoNull("CertificateNo"));
        this.setICurrency(aXMLDocument.getValueNoNull("Currency"));
        this.setIAmount(aXMLDocument.getValueNoNull("Amount"));
        this.setIProductId(aXMLDocument.getValueNoNull("ProductId"));
        this.setIProductName(aXMLDocument.getValueNoNull("ProductName"));
        this.setIQuantity(aXMLDocument.getValueNoNull("Quantity"));
        this.setIAgentSignNo(aXMLDocument.getValueNoNull("AgentSignNo"));
    }

    public String getIRequestDate() {
        return this.iRequestDate;
    }

    public void setIRequestDate(String requestDate) {
        this.iRequestDate = requestDate;
    }

    public String getIRequestTime() {
        return this.iRequestTime;
    }

    public void setIRequestTime(String requestTime) {
        this.iRequestTime = requestTime;
    }

    public String getIOrderNo() {
        return this.iOrderNo;
    }

    public void setIOrderNo(String orderNo) {
        this.iOrderNo = orderNo;
    }

    public int getIExpiredDate() {
        return this.iExpiredDate;
    }

    public void setIExpiredDate(int expiredDate) {
        this.iExpiredDate = expiredDate;
    }

    public String getICertificateNo() {
        return this.iCertificateNo;
    }

    public void setICertificateNo(String certificateNo) {
        this.iCertificateNo = certificateNo;
    }

    public String getIAgentSignNo() {
        return this.iAgentSignNo;
    }

    public void setIAgentSignNo(String agentSignNo) {
        this.iAgentSignNo = agentSignNo;
    }

    protected void checkRequest() throws TrxException {
        if (!DataVerifier.isValidString(this.iOrderNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iRequestDate)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iRequestTime)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iCertificateNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5ba2\u6237\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iAgentSignNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u7b7e\u7ea6\u534f\u8bae\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iCurrency)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8d26\u5355\u5e01\u79cd\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iAmount)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8d26\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iProductId)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u54c1\u7f16\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iProductName)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u54c1\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iQuantity)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u54c1\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidDate(this.iRequestDate)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidTime(this.iRequestTime)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    protected TrxResponse constructResponse(XMLDocument aResponseMessage) throws TrxException {
        return new TrxResponse(aResponseMessage);
    }

    protected XMLDocument getRequestMessage() throws TrxException {
        StringBuffer tMessage = new StringBuffer("").append("<TrxRequest>").append("<TrxType>").append("AgentPay").append("</TrxType>").append("<OrderNo>").append(this.iOrderNo).append("</OrderNo>").append("<ExpiredDate>").append(this.iExpiredDate).append("</ExpiredDate>").append("<CertificateNo>").append(this.iCertificateNo).append("</CertificateNo>").append("<OrderDate>").append(this.iRequestDate).append("</OrderDate>").append("<OrderTime>").append(this.iRequestTime).append("</OrderTime>").append("<Currency>").append(this.iCurrency).append("</Currency>").append("<Amount>").append(this.iAmount).append("</Amount>").append("<ProductId>").append(this.iProductId).append("</ProductId>").append("<ProductName>").append(this.iProductName).append("</ProductName>").append("<Quantity>").append(this.iQuantity).append("</Quantity>").append("<AgentSignNo>").append(this.iAgentSignNo).append("</AgentSignNo>").append("</TrxRequest>");
        return new XMLDocument(tMessage.toString());
    }
}

