/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.XMLDocument;
import com.hitrust.trustpay.client.b2c.QueryResultItem;
import java.util.ArrayList;

public class QueryResult {
    private ArrayList iQueryResultItems = null;
    private String iSerialNumber = "";
    private String iTrnxTime = "";
    private String iNo = "";
    private String iPayAccountNo = "";
    private String iPayAccountName = "";
    private String iReceiveAccountNo = "";
    private String iReceiveAccountName = "";
    private String iPurpose = "";
    private double iPayAmount = 0.0;
    private String iStatus = "";
    private String iFailReason = "";

    public void setQueryResultItems(ArrayList iQueryResultItems) {
        this.iQueryResultItems = iQueryResultItems;
    }

    public ArrayList getQueryResultItems() {
        return this.iQueryResultItems;
    }

    public QueryResult() {
        this.iQueryResultItems = new ArrayList();
    }

    public QueryResult(XMLDocument aXMLDocument) {
        this.initByXMLDocument(aXMLDocument);
    }

    public QueryResult initByString(String aOrderString) {
        this.initByXMLDocument(new XMLDocument(aOrderString));
        return this;
    }

    private QueryResult initByXMLDocument(XMLDocument aXMLDocument) {
        this.iQueryResultItems = new ArrayList();
        this.iNo = aXMLDocument.getValueNoNull("No");
        this.iSerialNumber = aXMLDocument.getValueNoNull("SerialNumber");
        this.iTrnxTime = aXMLDocument.getValueNoNull("TrnxTime");
        this.iPayAccountNo = aXMLDocument.getValueNoNull("PayAccount");
        this.iPayAccountName = aXMLDocument.getValueNoNull("PayAccountName");
        this.iReceiveAccountNo = aXMLDocument.getValueNoNull("ReceiveAccount");
        this.iReceiveAccountName = aXMLDocument.getValueNoNull("ReceiveAccountName");
        this.iPurpose = aXMLDocument.getValueNoNull("Purpose");
        this.iStatus = aXMLDocument.getValueNoNull("Status");
        this.iFailReason = aXMLDocument.getValueNoNull("FailReason");
        try {
            this.iPayAmount = Double.parseDouble(aXMLDocument.getValueNoNull("PayAmount"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList tQueryResultItems = aXMLDocument.getDocuments("BatchItem");
        int i = 0;
        while (i < tQueryResultItems.size()) {
            this.addQueryResultItem(new QueryResultItem((XMLDocument)tQueryResultItems.get(i)));
            ++i;
        }
        return this;
    }

    public QueryResult addQueryResultItem(QueryResultItem aQueryResultItem) {
        this.iQueryResultItems.add(aQueryResultItem);
        return this;
    }

    public void setSerialNumber(String iSerialNumber) {
        this.iSerialNumber = iSerialNumber;
    }

    public String getSerialNumber() {
        return this.iSerialNumber;
    }

    public void setTrnxTime(String iTrnxTime) {
        this.iTrnxTime = iTrnxTime;
    }

    public String getTrnxTime() {
        return this.iTrnxTime;
    }

    public void setNo(String iNo) {
        this.iNo = iNo;
    }

    public String getNo() {
        return this.iNo;
    }

    public void setPayAccountNo(String iPayAccountNo) {
        this.iPayAccountNo = iPayAccountNo;
    }

    public String getPayAccountNo() {
        return this.iPayAccountNo;
    }

    public void setPayAccountName(String iPayAccountName) {
        this.iPayAccountName = iPayAccountName;
    }

    public String getPayAccountName() {
        return this.iPayAccountName;
    }

    public void setReceiveAccountNo(String iReceiveAccountNo) {
        this.iReceiveAccountNo = iReceiveAccountNo;
    }

    public String getReceiveAccountNo() {
        return this.iReceiveAccountNo;
    }

    public void setReceiveAccountName(String iReceiveAccountName) {
        this.iReceiveAccountName = iReceiveAccountName;
    }

    public String getReceiveAccountName() {
        return this.iReceiveAccountName;
    }

    public void setPurpose(String iPurpose) {
        this.iPurpose = iPurpose;
    }

    public String getPurpose() {
        return this.iPurpose;
    }

    public void setPayAmount(double iPayAmount) {
        this.iPayAmount = iPayAmount;
    }

    public double getPayAmount() {
        return this.iPayAmount;
    }

    public void setStatus(String iStatus) {
        this.iStatus = iStatus;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setFailReason(String iFailReason) {
        this.iFailReason = iFailReason;
    }

    public String getFailReason() {
        return this.iFailReason;
    }
}

