/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.XMLDocument;
import com.hitrust.trustpay.client.b2c.AgentBatchDetail;
import java.util.ArrayList;

public class RefundBatch {
    public static final String STATUS_UNCHECK = "0";
    public static final String STATUS_CHECKSUCCESS = "1";
    public static final String STATUS_REJECT = "2";
    public static final String STATUS_SEND = "3";
    public static final String STATUS_SUCCESS = "4";
    public static final String STATUS_FAIL = "5";
    public static final String STATUS_ALL_SUCCESS = "6";
    public static final String STATUS_ALL_FAIL = "7";
    public static final String STATUS_PART_SUCCESS = "8";
    private String iMerchantNo = "";
    private String iBatchNo = "";
    private String iBatchDate = "";
    private long iBatchTime = 0L;
    private double iRefundAmount = 0.0;
    private int iRefundCount = 0;
    private String iTrnxTypeNo = "";
    private String iBatchStatus = "";
    private ArrayList iAgentBatchDetail = new ArrayList();

    public RefundBatch setMerchantNo(String aMerchantNo) {
        this.iMerchantNo = aMerchantNo;
        return this;
    }

    public String getMerchantNo() {
        return this.iMerchantNo;
    }

    public RefundBatch setBatchNo(String aBatchNo) {
        this.iBatchNo = aBatchNo;
        return this;
    }

    public String getBatchNo() {
        return this.iBatchNo;
    }

    public RefundBatch setBatchDate(String aBatchDate) {
        this.iBatchDate = aBatchDate;
        return this;
    }

    public String getBatchDate() {
        return this.iBatchDate;
    }

    public RefundBatch setBatchTime(long aBatchTime) {
        this.iBatchTime = aBatchTime;
        return this;
    }

    public long getBatchTime() {
        return this.iBatchTime;
    }

    public RefundBatch setBatchStatus(String aBatchStatus) {
        this.iBatchStatus = aBatchStatus;
        return this;
    }

    public String getBatchStatus() {
        return this.iBatchStatus;
    }

    public RefundBatch setRefundAmount(double aAgentAmount) {
        this.iRefundAmount = aAgentAmount;
        return this;
    }

    public double getRefundAmount() {
        return this.iRefundAmount;
    }

    public RefundBatch setRefundCount(int aAgentCount) {
        this.iRefundCount = aAgentCount;
        return this;
    }

    public int getRefundCount() {
        return this.iRefundCount;
    }

    public RefundBatch setTrnxTypeNo(String aTrnxTypeNo) {
        this.iTrnxTypeNo = aTrnxTypeNo;
        return this;
    }

    public String getTrnxTypeNo() {
        return this.iTrnxTypeNo;
    }

    public RefundBatch() {
    }

    public RefundBatch(XMLDocument aXMLDocument) {
        this.setMerchantNo(aXMLDocument.getValueNoNull("MerchantNo"));
        this.setBatchNo(aXMLDocument.getValueNoNull("BatchNo"));
        this.setBatchDate(aXMLDocument.getValueNoNull("BatchDate"));
        try {
            this.setBatchTime(Long.parseLong(aXMLDocument.getValueNoNull("BatchTime")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBatchStatus(aXMLDocument.getValueNoNull("BatchStatus"));
        try {
            this.setRefundAmount(Double.parseDouble(aXMLDocument.getValueNoNull("AgentAmount")));
            this.setRefundCount(Integer.parseInt(aXMLDocument.getValueNoNull("AgentCount")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList tAgentBatchDetail = aXMLDocument.getDocuments("AgentBatchDetail");
        int i = 0;
        while (i < tAgentBatchDetail.size()) {
            this.addAgentBatchDetail(new AgentBatchDetail((XMLDocument)tAgentBatchDetail.get(i)));
            ++i;
        }
    }

    public RefundBatch addAgentBatchDetail(AgentBatchDetail aAgentBatchDetail) {
        this.iAgentBatchDetail.add(aAgentBatchDetail);
        return this;
    }

    public ArrayList getAgentBatchDetail() {
        return this.iAgentBatchDetail;
    }

    public static void main(String[] args) {
    }

    public void checkRequest() throws TrxException {
        if (!DataVerifier.isValidString(this.iBatchNo, 30)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u53f7\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\u6216\u4e3a\u7a7a");
        }
        if (!DataVerifier.isValidDate8(this.iBatchDate)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidAmount(this.iRefundAmount, 2)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u91cf\u9000\u6b3e\u603b\u91d1\u989d\u4e0d\u6b63\u786e");
        }
    }

    public String getBatchSatusChinese(String aStatus) {
        String tStatusChinese = "";
        tStatusChinese = aStatus.equals(STATUS_UNCHECK) ? "\u6279\u91cf\u5f85\u590d\u6838" : (aStatus.equals(STATUS_CHECKSUCCESS) ? "\u6279\u91cf\u590d\u6838\u901a\u8fc7\u5f85\u53d1\u9001" : (aStatus.equals(STATUS_REJECT) ? "\u6279\u91cf\u590d\u6838\u88ab\u9a73\u56de" : (aStatus.equals(STATUS_SEND) ? "\u6279\u91cf\u7b49\u5f85\u5904\u7406" : (aStatus.equals(STATUS_SUCCESS) ? "\u6279\u91cf\u63d0\u4ea4\u6210\u529f" : (aStatus.equals(STATUS_FAIL) ? "\u6279\u91cf\u63d0\u4ea4\u5931\u8d25" : "\u672a\u77e5\u72b6\u6001")))));
        return tStatusChinese;
    }
}

