/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.Base64;
import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;

public class SettleRequest
extends TrxRequest {
    private String iSettleDate = "";
    private String iSettleType = "";
    private String iSettleStartHour = "";
    private String iSettleEndHour = "";

    public SettleRequest() {
        super("B2C");
    }

    protected XMLDocument getRequestMessage() throws TrxException {
        StringBuffer tMessage = new StringBuffer("").append("<TrxRequest>").append("<TrxType>").append("Settle").append("</TrxType>").append("<SettleDate>").append(this.iSettleDate).append("</SettleDate>").append("<SettleStartHour>").append(this.iSettleStartHour).append("</SettleStartHour>").append("<SettleEndHour>").append(this.iSettleEndHour).append("</SettleEndHour>").append("<SettleType>").append(this.iSettleType).append("</SettleType>").append("<ZIP>YES</ZIP>").append("</TrxRequest>");
        return new XMLDocument(tMessage.toString());
    }

    protected void checkRequest() throws TrxException {
        if (!DataVerifier.isValidDate(this.iSettleDate)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5bf9\u8d26\u65e5\u671f\u4e0d\u5408\u6cd5\uff01");
        }
        if (!(this.iSettleType.equals("TRX") || this.iSettleType.equals("SETTLE") || this.iSettleType.equals("TRXBYHOUR") || this.iSettleType.equals("CREDIT_TRX"))) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5bf9\u8d26\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.iSettleType.equals("TRXBYHOUR")) {
            if (this.iSettleStartHour.trim().equals("") || this.iSettleEndHour.trim().equals("")) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5bf9\u8d26\u8d77\u6b62\u65f6\u95f4\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u8f93\u51650-23\u4e4b\u95f4\u7684\u6709\u6548\u65f6\u95f4\u6bb5\uff01");
            }
            this.iSettleStartHour = this.iSettleStartHour.length() < 2 ? "0" + this.iSettleStartHour : this.iSettleStartHour;
            String string = this.iSettleEndHour = this.iSettleEndHour.length() < 2 ? "0" + this.iSettleEndHour : this.iSettleEndHour;
            if (this.iSettleStartHour.compareTo("0") < 0 || this.iSettleStartHour.compareTo("23") > 0 || this.iSettleEndHour.compareTo("0") < 0 || this.iSettleEndHour.compareTo("23") > 0 || this.iSettleStartHour.compareTo(this.iSettleEndHour) > 0) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5bf9\u8d26\u8d77\u6b62\u65f6\u95f4\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u8f93\u51650-23\u4e4b\u95f4\u7684\u6709\u6548\u65f6\u95f4\u6bb5\uff0c\u4e14\u622a\u6b62\u65f6\u95f4\u4e0d\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4\uff01");
            }
        }
    }

    protected TrxResponse constructResponse(XMLDocument aResponseMessage) throws TrxException {
        StringBuffer tResponseMessage = new StringBuffer(aResponseMessage.toString());
        String tDownloadedTrxnLogs = "";
        ByteArrayOutputStream tBAOSUnZip = null;
        PrintWriter tBWUnZip = null;
        BufferedReader tBR = null;
        GZIPInputStream tUnZip = null;
        ByteArrayInputStream tBAIS = null;
        try {
            String tTrnxLogs = aResponseMessage.getValueNoNull("ZIPDetailRecords");
            if (tTrnxLogs == null || tTrnxLogs.equals("")) {
                TrxResponse trxResponse = new TrxResponse(new XMLDocument(tResponseMessage.toString()));
                return trxResponse;
            }
            try {
                Base64 tBase64 = new Base64();
                tBAIS = new ByteArrayInputStream(tBase64.decode(tTrnxLogs));
                tUnZip = new GZIPInputStream(tBAIS);
                tBR = new BufferedReader(new InputStreamReader(tUnZip));
                String tLineUnZip = null;
                tBAOSUnZip = new ByteArrayOutputStream();
                tBWUnZip = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tBAOSUnZip)));
                while ((tLineUnZip = tBR.readLine()) != null) {
                    tBWUnZip.println(tLineUnZip);
                }
                tBWUnZip.flush();
                tDownloadedTrxnLogs = tBAOSUnZip.toString();
                tResponseMessage.append("<DetailRecords>").append(tDownloadedTrxnLogs).append("</DetailRecords>");
            }
            catch (Exception e) {
                throw new TrxException("1304", "\u89e3\u538b\u7f29\u4ea4\u6613\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef", e.getMessage());
            }
        }
        finally {
            if (tBWUnZip != null) {
                try {
                    tBWUnZip.close();
                }
                catch (Exception exception) {}
            }
            if (tBAOSUnZip != null) {
                try {
                    tBAOSUnZip.close();
                }
                catch (Exception exception) {}
            }
            if (tBR != null) {
                try {
                    tBR.close();
                }
                catch (Exception exception) {}
            }
            if (tUnZip != null) {
                try {
                    tUnZip.close();
                }
                catch (Exception exception) {}
            }
            if (tBAIS != null) {
                try {
                    tBAIS.close();
                }
                catch (Exception exception) {}
            }
        }
        return new TrxResponse(new XMLDocument(tResponseMessage.toString()));
    }

    public SettleRequest setSettleDate(String aSettleDate) {
        this.iSettleDate = aSettleDate.trim();
        return this;
    }

    public String getSettleDate() {
        return this.iSettleDate;
    }

    public SettleRequest setSettleStartHour(String aSettleStartHour) {
        this.iSettleStartHour = aSettleStartHour.trim();
        return this;
    }

    public String getSettleStartHour() {
        return this.iSettleStartHour;
    }

    public SettleRequest setSettleEndHour(String aSettleEndHour) {
        this.iSettleEndHour = aSettleEndHour.trim();
        return this;
    }

    public String getSettleEndHour() {
        return this.iSettleEndHour;
    }

    public SettleRequest setSettleType(String aSettleType) {
        this.iSettleType = aSettleType.trim();
        return this;
    }

    public String getSettleType() {
        return this.iSettleType;
    }
}

