/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.gwj.service;

import com.unionpay.acp.gwj.conf.GwjConfig;
import com.unionpay.acp.gwj.domain.Area;
import com.unionpay.acp.gwj.domain.Biz;
import com.unionpay.acp.gwj.domain.Category;
import com.unionpay.acp.gwj.util.HttpUtil;
import com.unionpay.acp.gwj.util.JsonUtil;
import com.unionpay.acp.gwj.vo.BaseVo;
import com.unionpay.acp.gwj.vo.ResponseBaseVo;

public class GwjService {
    public static Area[] getAreas() {
        String areas = HttpUtil.getAsString(GwjConfig.GWJ_URL + "/s" + "/areas");
        return JsonUtil.fromJson(areas, Area[].class);
    }

    public static Category[] getCategories(String areaCode) {
        String categories = HttpUtil.getAsString(GwjConfig.GWJ_URL + "/s" + "/categories" + "/" + areaCode);
        return JsonUtil.fromJson(categories, Category[].class);
    }

    public static Biz getBiz(String bussCode) {
        String biz = HttpUtil.getAsString(GwjConfig.GWJ_URL + "/s" + "/biz" + "/" + bussCode);
        return JsonUtil.fromJson(biz, Biz.class);
    }

    public static byte[] getVerifyCodeImg(String vid) {
        return HttpUtil.get(GwjConfig.GWJ_URL + "/entry" + "?getcaptcha" + "&vid=" + vid);
    }

    public static byte[] getVerifyCodeImg(String vid, String color) {
        return HttpUtil.get(GwjConfig.GWJ_URL + "/entry" + "?getcaptcha" + "&vid=" + vid + "&color=" + color);
    }

    public static String getVid() {
        return new String(HttpUtil.get(GwjConfig.GWJ_URL + "/entry" + "?getvid"));
    }

    public static ResponseBaseVo transaction(BaseVo request) {
        String resp = HttpUtil.post(GwjConfig.GWJ_URL + "/entry", JsonUtil.toJson(request));
        return JsonUtil.fromJson(resp, ResponseBaseVo.class);
    }

    public static void main(String[] args) {
        System.out.println(JsonUtil.toJson(GwjService.getBiz("D1_3600_0201")));
    }
}

