/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.sdk;

import com.unionpay.acp.sdk.LogUtil;
import com.unionpay.acp.sdk.SDKUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class SDKConfig {
    public static final String FILE_NAME = "acp_sdk.properties";
    private String frontRequestUrl;
    private String backRequestUrl;
    private String singleQueryUrl;
    private String batchQueryUrl;
    private String batchTransUrl;
    private String fileTransUrl;
    private String signCertPath;
    private String signCertPwd;
    private String signCertType;
    private String encryptCertPath;
    private String validateCertDir;
    private String signCertDir;
    private String encryptTrackCertPath;
    private String cardRequestUrl;
    private String appRequestUrl;
    private String singleMode;
    public static final String SDK_FRONT_URL = "acpsdk.frontTransUrl";
    public static final String SDK_BACK_URL = "acpsdk.backTransUrl";
    public static final String SDK_SIGNQ_URL = "acpsdk.singleQueryUrl";
    public static final String SDK_BATQ_URL = "acpsdk.batchQueryUrl";
    public static final String SDK_BATTRANS_URL = "acpsdk.batchTransUrl";
    public static final String SDK_FILETRANS_URL = "acpsdk.fileTransUrl";
    public static final String SDK_CARD_URL = "acpsdk.cardTransUrl";
    public static final String SDK_APP_URL = "acpsdk.appTransUrl";
    public static final String SDK_SIGNCERT_PATH = "acpsdk.signCert.path";
    public static final String SDK_SIGNCERT_PWD = "acpsdk.signCert.pwd";
    public static final String SDK_SIGNCERT_TYPE = "acpsdk.signCert.type";
    public static final String SDK_ENCRYPTCERT_PATH = "acpsdk.encryptCert.path";
    public static final String SDK_ENCRYPTTRACKCERT_PATH = "acpsdk.encryptTrackCert.path";
    public static final String SDK_VALIDATECERT_DIR = "acpsdk.validateCert.dir";
    public static final String SDK_CVN_ENC = "acpsdk.cvn2.enc";
    public static final String SDK_DATE_ENC = "acpsdk.date.enc";
    public static final String SDK_PAN_ENC = "acpsdk.pan.enc";
    public static final String SDK_SINGLEMODE = "acpsdk.singleMode";
    private static SDKConfig config;
    private Properties properties;

    public static SDKConfig getConfig() {
        if (null == config) {
            config = new SDKConfig();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropertiesFromPath(String rootPath) {
        if (StringUtils.isNotBlank((String)rootPath)) {
            File file = new File(rootPath + File.separator + FILE_NAME);
            FileInputStream in = null;
            if (file.exists()) {
                try {
                    in = new FileInputStream(file);
                    BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)in, "utf-8"));
                    this.properties = new Properties();
                    this.properties.load(bf);
                    this.loadProperties(this.properties);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (null != in) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                System.out.println(rootPath + FILE_NAME + "\u4e0d\u5b58\u5728,\u52a0\u8f7d\u53c2\u6570\u5931\u8d25");
            }
        } else {
            this.loadPropertiesFromSrc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropertiesFromSrc() {
        InputStream in = null;
        try {
            in = SDKConfig.class.getClassLoader().getResourceAsStream(FILE_NAME);
            if (null != in) {
                BufferedReader bf = new BufferedReader(new InputStreamReader(in, "utf-8"));
                this.properties = new Properties();
                this.properties.load(bf);
            } else {
                LogUtil.writeErrorLog("acp_sdk.properties\u6587\u4ef6\u4e0d\u5b58\u5728!");
                return;
            }
            this.loadProperties(this.properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void loadProperties(Properties pro) {
        String value = null;
        value = pro.getProperty(SDK_SINGLEMODE);
        if (SDKUtil.isEmpty(value) || "true".equals(value)) {
            this.singleMode = "true";
            LogUtil.writeLog("SingleCertMode:[" + this.singleMode + "]");
            value = pro.getProperty(SDK_SIGNCERT_PATH);
            if (!SDKUtil.isEmpty(value)) {
                this.signCertPath = value.trim();
            }
            if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_SIGNCERT_PWD))) {
                this.signCertPwd = value.trim();
            }
            if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_SIGNCERT_TYPE))) {
                this.signCertType = value.trim();
            }
        } else {
            this.singleMode = "false";
            LogUtil.writeLog("SingleMode:[" + this.singleMode + "]");
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_ENCRYPTCERT_PATH))) {
            this.encryptCertPath = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_VALIDATECERT_DIR))) {
            this.validateCertDir = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_FRONT_URL))) {
            this.frontRequestUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_BACK_URL))) {
            this.backRequestUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_BATQ_URL))) {
            this.batchQueryUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_BATTRANS_URL))) {
            this.batchTransUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_FILETRANS_URL))) {
            this.fileTransUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_SIGNQ_URL))) {
            this.singleQueryUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_CARD_URL))) {
            this.cardRequestUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_APP_URL))) {
            this.appRequestUrl = value.trim();
        }
        if (!SDKUtil.isEmpty(value = pro.getProperty(SDK_ENCRYPTTRACKCERT_PATH))) {
            this.encryptTrackCertPath = value.trim();
        }
    }

    public String getFrontRequestUrl() {
        return this.frontRequestUrl;
    }

    public void setFrontRequestUrl(String frontRequestUrl) {
        this.frontRequestUrl = frontRequestUrl;
    }

    public String getBackRequestUrl() {
        return this.backRequestUrl;
    }

    public void setBackRequestUrl(String backRequestUrl) {
        this.backRequestUrl = backRequestUrl;
    }

    public String getSignCertPath() {
        return this.signCertPath;
    }

    public void setSignCertPath(String signCertPath) {
        this.signCertPath = signCertPath;
    }

    public String getSignCertPwd() {
        return this.signCertPwd;
    }

    public void setSignCertPwd(String signCertPwd) {
        this.signCertPwd = signCertPwd;
    }

    public String getSignCertType() {
        return this.signCertType;
    }

    public void setSignCertType(String signCertType) {
        this.signCertType = signCertType;
    }

    public String getEncryptCertPath() {
        return this.encryptCertPath;
    }

    public void setEncryptCertPath(String encryptCertPath) {
        this.encryptCertPath = encryptCertPath;
    }

    public String getValidateCertDir() {
        return this.validateCertDir;
    }

    public void setValidateCertDir(String validateCertDir) {
        this.validateCertDir = validateCertDir;
    }

    public String getSingleQueryUrl() {
        return this.singleQueryUrl;
    }

    public void setSingleQueryUrl(String singleQueryUrl) {
        this.singleQueryUrl = singleQueryUrl;
    }

    public String getBatchQueryUrl() {
        return this.batchQueryUrl;
    }

    public void setBatchQueryUrl(String batchQueryUrl) {
        this.batchQueryUrl = batchQueryUrl;
    }

    public String getBatchTransUrl() {
        return this.batchTransUrl;
    }

    public void setBatchTransUrl(String batchTransUrl) {
        this.batchTransUrl = batchTransUrl;
    }

    public String getFileTransUrl() {
        return this.fileTransUrl;
    }

    public void setFileTransUrl(String fileTransUrl) {
        this.fileTransUrl = fileTransUrl;
    }

    public String getSignCertDir() {
        return this.signCertDir;
    }

    public void setSignCertDir(String signCertDir) {
        this.signCertDir = signCertDir;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getCardRequestUrl() {
        return this.cardRequestUrl;
    }

    public void setCardRequestUrl(String cardRequestUrl) {
        this.cardRequestUrl = cardRequestUrl;
    }

    public String getAppRequestUrl() {
        return this.appRequestUrl;
    }

    public void setAppRequestUrl(String appRequestUrl) {
        this.appRequestUrl = appRequestUrl;
    }

    public String getEncryptTrackCertPath() {
        return this.encryptTrackCertPath;
    }

    public void setEncryptTrackCertPath(String encryptTrackCertPath) {
        this.encryptTrackCertPath = encryptTrackCertPath;
    }

    public String getSingleMode() {
        return this.singleMode;
    }

    public void setSingleMode(String singleMode) {
        this.singleMode = singleMode;
    }
}

