/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.sdksample.batch;

import com.unionpay.acp.sdk.HttpClient;
import com.unionpay.acp.sdk.LogUtil;
import com.unionpay.acp.sdk.SDKConfig;
import com.unionpay.acp.sdk.SDKUtil;
import com.unionpay.acp.sdk.SecureUtil;
import java.io.FileInputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BatchQueryExample {
    public static void main(String[] args) {
        String fileName = "TH00000000700000000000001201407101000I.txt";
        BatchQueryExample.send(fileName);
    }

    public static void fieldUpload(Map<String, String> map, String fileName) {
        try {
            URL dd = BatchQueryExample.class.getClassLoader().getResource(fileName);
            FileInputStream ins = new FileInputStream(dd.getFile());
            byte[] b = new byte[ins.available()];
            ins.read(b);
            ins.close();
            String string = new String(b);
            string = new String(SecureUtil.base64Encode(SecureUtil.deflater(b)));
            System.out.println(string);
            map.put("fileContent", string);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void send(String fileName) {
        SDKConfig.getConfig().loadPropertiesFromSrc();
        String type = fileName.substring(0, 2);
        String acqInsCode = fileName.substring(2, 10);
        String merId = fileName.substring(10, 25);
        String txnTime = fileName.substring(25, 33);
        String batchNo = fileName.substring(33, 37);
        String version = "5.0.0";
        String encoding = "UTF-8";
        String certId = "999999999999";
        String signMethod = "02";
        String txnType = "22";
        String txnSubType = "01";
        if ("TH".equals(type)) {
            txnSubType = "01";
        } else if ("DK".equals(type)) {
            txnSubType = "02";
        } else if ("DF".equals(type)) {
            txnSubType = "03";
        }
        String bizType = "000000";
        String channelType = "08";
        String accessType = "0";
        String reqReserved = "";
        String reserved = "";
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("version", version);
        req.put("encoding", encoding);
        req.put("certId", certId);
        req.put("signMethod", signMethod);
        req.put("txnType", txnType);
        req.put("txnSubType", txnSubType);
        req.put("bizType", bizType);
        req.put("channelType", channelType);
        req.put("accessType", accessType);
        if (StringUtils.isNotBlank((String)acqInsCode)) {
            req.put("acqInsCode", acqInsCode);
        }
        if (StringUtils.isNotBlank((String)merId)) {
            req.put("merId", merId);
        }
        req.put("batchNo", batchNo);
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        req.put("txnTime", txnTime + sdf.format(new Date()));
        if (StringUtils.isNotBlank((String)reqReserved)) {
            req.put("reqReserved", reqReserved);
        }
        if (StringUtils.isNotBlank((String)reserved)) {
            req.put("reserved", reserved);
        }
        SDKUtil.sign(req, encoding);
        LogUtil.writeLog("BackRequest\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u8868\u5355\u5982\u4e0b");
        LogUtil.printRequestLog(req);
        String queryUrl = SDKConfig.getConfig().getBatchQueryUrl();
        LogUtil.writeLog("\u53d1\u9001\u62a5\u6587\u5230\u540e\u53f0");
        LogUtil.writeLog("\u8bf7\u6c42\u5730\u5740queryUrl=[" + queryUrl + "]");
        String result = null;
        HttpClient hc = new HttpClient(queryUrl, 30000, 30000);
        try {
            int status = hc.send(req, encoding);
            if (200 == status) {
                result = hc.getResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u62a5\u6587\u53d1\u9001\u540e\u7684\u54cd\u5e94\u4fe1\u606f\uff1a  " + result);
    }
}

