/*
 * Decompiled with CFR 0.152.
 */
package com.show.api.util;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        char[] chars = obj.toString().toCharArray();
        int length = chars.length;
        if (length < 1) {
            return false;
        }
        int i = 0;
        if (length > 1 && chars[0] == '-') {
            i = 1;
        }
        while (i < length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                result &= !StringUtils.isEmpty(value);
                ++n2;
            }
        }
        return result;
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (!StringUtils.isEmpty(unicode)) {
            int i = 0;
            while (i < unicode.length()) {
                out.append(unicode.charAt(i));
                ++i;
            }
        }
        return out.toString();
    }

    public static String toUnderlineStyle(String name) {
        StringBuilder newName = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    newName.append("_");
                }
                newName.append(Character.toLowerCase(c));
            } else {
                newName.append(c);
            }
            ++i;
        }
        return newName.toString();
    }

    public static String convertString(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, offset, length, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] convertBytes(String data) {
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

