/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.sdk;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger GATELOG = LoggerFactory.getLogger((String)"ACP_SDK_LOG");
    private static final Logger GATELOG_ERROR = LoggerFactory.getLogger((String)"SDK_ERR_LOG");
    private static final Logger GATELOG_MESSAGE = LoggerFactory.getLogger((String)"SDK_MSG_LOG");
    static final String LOG_STRING_REQ_MSG_BEGIN = "============================== SDK REQ MSG BEGIN ==============================";
    static final String LOG_STRING_REQ_MSG_END = "==============================  SDK REQ MSG END  ==============================";
    static final String LOG_STRING_RSP_MSG_BEGIN = "============================== SDK RSP MSG BEGIN ==============================";
    static final String LOG_STRING_RSP_MSG_END = "==============================  SDK RSP MSG END  ==============================";

    public static void writeLog(String cont) {
        GATELOG.info(cont);
    }

    public static void writeErrorLog(String cont) {
        GATELOG_ERROR.error(cont);
    }

    public static void writeErrorLog(String cont, Throwable ex) {
        GATELOG_ERROR.error(cont, ex);
    }

    public static void writeMessage(String msg) {
        GATELOG_MESSAGE.info(msg);
    }

    public static void printRequestLog(Map<String, String> reqParam) {
        LogUtil.writeMessage(LOG_STRING_REQ_MSG_BEGIN);
        for (Map.Entry<String, String> en : reqParam.entrySet()) {
            LogUtil.writeMessage("[" + en.getKey() + "] = [" + en.getValue() + "]");
        }
        LogUtil.writeMessage(LOG_STRING_REQ_MSG_END);
    }

    public static void printResponseLog(String res) {
        LogUtil.writeMessage(LOG_STRING_RSP_MSG_BEGIN);
        LogUtil.writeMessage(res);
        LogUtil.writeMessage(LOG_STRING_RSP_MSG_END);
    }

    public static void debug(String cont) {
        if (GATELOG.isDebugEnabled()) {
            GATELOG.debug(cont);
        }
    }
}

