/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.sdksample.multicert;

import com.unionpay.acp.sdk.HttpClient;
import com.unionpay.acp.sdk.SDKUtil;
import com.unionpay.acp.sdk.SecureUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;

public class DemoBase {
    public static String encoding = "UTF-8";
    public static String version = "5.0.0";
    public static String frontUrl = "http://localhost:8080/ACPTest/acp_front_url.do";
    public static String backUrl = "http://localhost:8080/ACPTest/acp_back_url.do";
    public static final String modulus = "23648629510357402173669374843546537318532861396089478651610490265597426690711092692490012429464861104676801339474220894685964389750254240882066338437712341498313076007251358899488346743554156067576120095739341094220657657611893755799646325194641430110114613586989866468748149428464174345443169749235358776080247588710246733575431530477273705811466095207773188767974550742707293785661521305267533098997705930724499157184797236612324838287379798375903922360666026664942383548006246201656190964746068225967889145661249463716565124050082767382345820178584568857820200627919768134084891356188058390460707236118612628845159";
    public static final String exponent = "65537";

    public static String createHtml(String action, Map<String, String> hiddens) {
        StringBuffer sf = new StringBuffer();
        sf.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/></head><body>");
        sf.append("<form id = \"pay_form\" action=\"" + action + "\" method=\"post\">");
        if (null != hiddens && 0 != hiddens.size()) {
            Set<Map.Entry<String, String>> set = hiddens.entrySet();
            for (Map.Entry<String, String> ey : set) {
                String key = ey.getKey();
                String value = ey.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.all.pay_form.submit();");
        sf.append("</script>");
        sf.append("</html>");
        return sf.toString();
    }

    public static Map<String, String> signData(Map<String, ?> contentData) {
        Map.Entry<String, ?> obj2 = null;
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        for (Map.Entry<String, ?> obj2 : contentData.entrySet()) {
            String value = (String)obj2.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            submitFromData.put(obj2.getKey(), value.trim());
        }
        SDKUtil.sign(submitFromData, encoding);
        return submitFromData;
    }

    public static Map<String, String> signData(Map<String, ?> contentData, String certPath, String certPwd) {
        Map.Entry<String, ?> obj2 = null;
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        for (Map.Entry<String, ?> obj2 : contentData.entrySet()) {
            String value = (String)obj2.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            submitFromData.put(obj2.getKey(), value.trim());
            System.out.println(obj2.getKey() + "-->" + String.valueOf(value));
        }
        SDKUtil.signByCertInfo(submitFromData, encoding, certPath, certPwd);
        return submitFromData;
    }

    public static Map<String, String> submitUrl(Map<String, String> submitFromData, String requestUrl) {
        String resultString = "";
        System.out.println("requestUrl=[" + requestUrl + "]");
        HttpClient hc = new HttpClient(requestUrl, 30000, 30000);
        try {
            int status = hc.send(submitFromData, encoding);
            if (200 == status) {
                resultString = hc.getResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, String> resData = new HashMap<String, String>();
        if (null != resultString && !"".equals(resultString)) {
            resData = SDKUtil.convertResultStringToMap(resultString);
            if (SDKUtil.validate(resData, encoding)) {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f");
            } else {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            }
        }
        return resData;
    }

    public static void deCodeFileContent(Map<String, String> resData) {
        String fileContent = resData.get("fileContent");
        if (null != fileContent && !"".equals(fileContent)) {
            try {
                byte[] fileArray = SecureUtil.inflater(SecureUtil.base64Decode(fileContent.getBytes(encoding)));
                String root = "D:\\";
                String filePath = null;
                filePath = SDKUtil.isEmpty(resData.get("fileName")) ? root + File.separator + resData.get("merId") + "_" + resData.get("batchNo") + "_" + resData.get("txnTime") + ".txt" : root + File.separator + resData.get("fileName");
                File file = new File(filePath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file);
                out.write(fileArray, 0, fileArray.length);
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, String> submitDate(Map<String, ?> contentData, String requestUrl) {
        Map<String, String> submitFromData = DemoBase.signData(contentData);
        return DemoBase.submitUrl(submitFromData, requestUrl);
    }

    public static Map<String, String> submitDate(Map<String, ?> contentData, String requestUrl, String certPath, String certPwd) {
        Map<String, String> submitFromData = DemoBase.signData(contentData, certPath, certPwd);
        return DemoBase.submitUrl(submitFromData, requestUrl);
    }

    public static String getCustomer(Map<String, ?> contentData, String encoding) {
        String pin = "123456";
        String expired = "1249";
        pin = SDKUtil.encryptPin(contentData.get("accNo").toString(), pin, encoding);
        expired = SDKUtil.encryptAvailable(expired, encoding);
        HashMap<String, String> customerInfoMap = new HashMap<String, String>();
        customerInfoMap.put("pin", pin);
        StringBuffer sf = new StringBuffer();
        String customerInfo = sf.append("{").append(SDKUtil.coverMap2String(customerInfoMap)).append("}").toString();
        try {
            return new String(SecureUtil.base64Encode(sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return customerInfo;
    }

    public static String getCurrentTime() {
        return DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
    }

    public static String getOrderId() {
        return DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
    }

    public static String getCardTransData(Map<String, ?> contentData, String encoding) {
        StringBuffer cardTransDataBuffer = new StringBuffer();
        String iCCardData = "9F2608E949441859FB25309F2701809F101307000103A00002010A010000052000F26F86559F3704DFE09A299F360201A2950500800008009A031504089C01009F02060000000001005F2A02015682027D009F1A0201569F03060000000000009F330360F8C89F34031E03009F3501219F1E0831323334353637388410A00000033301010211223344556677889F090200019F410413";
        String iCCardSeqNumber = "123";
        String track2Data = "6214441000010020=301020600000F";
        String track3Data = "6214441000010020=301020600000F";
        StringBuffer track2Buffer = new StringBuffer();
        track2Buffer.append(contentData.get("merId")).append("|").append(contentData.get("orderId")).append("|").append(contentData.get("txnTime")).append("|").append(contentData.get("txnAmt")).append("|").append(track2Data);
        String encryptedTrack2 = SDKUtil.encryptTrack(track2Buffer.toString(), encoding, modulus, exponent);
        StringBuffer track3Buffer = new StringBuffer();
        track3Buffer.append(contentData.get("merId")).append("|").append(contentData.get("orderId")).append("|").append(contentData.get("txnTime")).append("|").append(contentData.get("txnAmt")).append("|").append(track3Data);
        String encryptedTrack3 = SDKUtil.encryptTrack(track3Buffer.toString(), encoding, modulus, exponent);
        try {
            iCCardData = new String(SecureUtil.base64Encode(iCCardData.getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, String> cardTransDataMap = new HashMap<String, String>();
        cardTransDataMap.put("track2Data", encryptedTrack2);
        cardTransDataMap.put("track3Data", encryptedTrack3);
        cardTransDataMap.put("carrierAppTp", "3");
        cardTransDataMap.put("carrierTp", "0");
        return cardTransDataBuffer.append("{").append(SDKUtil.coverMap2String(cardTransDataMap)).append("}").toString();
    }
}

