/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.XMLDocument;
import com.hitrust.trustpay.client.b2c.InsureOrder;
import com.hitrust.trustpay.client.b2c.InsureUser;

public class Insure {
    private String iType;
    private String iFurl;
    private InsureOrder iOrder;
    private InsureUser iUser;
    public static final String INSURE_TYPE_COMMON = "1";
    public static final String INSURE_TYPE_FINANCING = "2";
    public static final String INSURE_TYPE_APPOINTED = "3";

    public Insure setType(String aType) {
        this.iType = aType.trim();
        return this;
    }

    public String getType() {
        return this.iType;
    }

    public Insure setFurl(String aFurl) {
        this.iFurl = aFurl.trim();
        return this;
    }

    public String getFurl() {
        return this.iFurl;
    }

    public Insure setOrder(InsureOrder aOrder) {
        this.iOrder = aOrder;
        return this;
    }

    public InsureOrder getOrder() {
        return this.iOrder;
    }

    public Insure setUser(InsureUser aUser) {
        this.iUser = aUser;
        return this;
    }

    public InsureUser getUser() {
        return this.iUser;
    }

    public String isValid() {
        if (this.iType == null) {
            return "\u4fdd\u9669\u652f\u4ed8\u7c7b\u578b\u4e3a\u7a7a";
        }
        if (!(this.iType.equals(INSURE_TYPE_COMMON) || this.iType.equals(INSURE_TYPE_FINANCING) || this.iType.equals(INSURE_TYPE_APPOINTED))) {
            return "\u4fdd\u9669\u652f\u4ed8\u7c7b\u578b\u4e3a\u4e0d\u5408\u6cd5";
        }
        if (this.iType.equals(INSURE_TYPE_FINANCING) && (this.iFurl == null || this.iFurl.length() == 0)) {
            return "\u9a8c\u8bc1\u9519\u8bef\u4fe1\u606f\u663e\u793a\u5730\u5740\u4e3a\u7a7a";
        }
        String tError = this.iOrder.isValid();
        if (tError.length() > 0) {
            return tError;
        }
        if ((this.iType.equals(INSURE_TYPE_FINANCING) || this.iType.equals(INSURE_TYPE_APPOINTED)) && (tError = this.iUser.isValid()).length() > 0) {
            return tError;
        }
        return "";
    }

    public Insure() {
    }

    public Insure(XMLDocument aXMLDocument) {
        this.initByXMLDocument(aXMLDocument);
    }

    public XMLDocument getXMLDocument() {
        StringBuffer tXML = new StringBuffer("").append("<Insure>").append("<Type>").append(this.iType).append("</Type>").append("<Orders>").append(this.iOrder.getXMLDocument()).append("</Orders>");
        if (this.iType.equals(INSURE_TYPE_FINANCING)) {
            tXML.append("<Furl>").append(this.iFurl).append("</Furl>");
        }
        if (this.iType.equals(INSURE_TYPE_FINANCING) || this.iType.equals(INSURE_TYPE_APPOINTED)) {
            tXML.append("<User>").append(this.iUser.getXMLDocument()).append("</User>");
        }
        tXML.append("</Insure>");
        return new XMLDocument(tXML.toString());
    }

    public Insure initByString(String aInsureString) {
        this.initByXMLDocument(new XMLDocument(aInsureString));
        return this;
    }

    private Insure initByXMLDocument(XMLDocument aXMLDocument) {
        this.setType(aXMLDocument.getValueNoNull("Type"));
        this.setFurl(aXMLDocument.getValueNoNull("Furl"));
        this.setOrder(new InsureOrder(aXMLDocument.getValueNoNull("Orders")));
        this.setUser(new InsureUser(aXMLDocument.getValueNoNull("User")));
        return this;
    }
}

