/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.XMLDocument;

public class OrderItem {
    private String iProductID = "";
    private String iProductName = "";
    private double iUnitPrice = 0.0;
    private int iQty = 0;
    public static final int PRODUCT_ID_LEN = 20;
    public static final int PRODUCT_NAME_LEN = 50;

    public OrderItem() {
    }

    public OrderItem(String aProductID, String aProductName, double aUnitPrice, int aQty) {
        this.setProductID(aProductID);
        this.setProductName(aProductName);
        this.setUnitPrice(aUnitPrice);
        this.setQty(aQty);
    }

    public OrderItem(XMLDocument aXMLDocument) {
        this.setProductID(aXMLDocument.getValueNoNull("ProductID"));
        this.setProductName(aXMLDocument.getValueNoNull("ProductName"));
        try {
            this.setUnitPrice(Double.parseDouble(aXMLDocument.getValueNoNull("UnitPrice")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setQty(Integer.parseInt(aXMLDocument.getValueNoNull("Qty")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OrderItem setProductID(String aProductID) {
        this.iProductID = aProductID.trim();
        return this;
    }

    public String getProductID() {
        return this.iProductID;
    }

    public OrderItem setProductName(String aProductName) {
        this.iProductName = aProductName.trim();
        return this;
    }

    public String getProductName() {
        return this.iProductName;
    }

    public OrderItem setUnitPrice(double aUnitPrice) {
        this.iUnitPrice = aUnitPrice;
        return this;
    }

    public double getUnitPrice() {
        return this.iUnitPrice;
    }

    public OrderItem setQty(int aQty) {
        this.iQty = aQty;
        return this;
    }

    public int getQty() {
        return this.iQty;
    }

    public double getAmount() {
        return this.iUnitPrice * (double)this.iQty;
    }

    public boolean isValid() {
        if (this.iProductID == null) {
            return false;
        }
        if (this.iProductName == null) {
            return false;
        }
        if (this.iUnitPrice <= 0.0) {
            return false;
        }
        if (this.iQty <= 0) {
            return false;
        }
        if (this.iProductID.length() == 0) {
            return false;
        }
        if (this.iProductID.getBytes().length > 20) {
            return false;
        }
        if (this.iProductName.length() == 0) {
            return false;
        }
        if (this.iProductName.getBytes().length > 50) {
            return false;
        }
        return DataVerifier.isValidAmount(this.iUnitPrice, 2);
    }

    public XMLDocument getXMLDocument() {
        StringBuffer tXML = new StringBuffer("").append("<OrderItem>").append("<ProductID>").append(this.iProductID).append("</ProductID>").append("<ProductName>").append(this.iProductName).append("</ProductName>").append("<UnitPrice>").append(this.iUnitPrice).append("</UnitPrice>").append("<Qty>").append(this.iQty).append("</Qty>").append("</OrderItem>");
        return new XMLDocument(tXML.toString());
    }
}

