/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.XMLDocument;

public class RefundBatchDetail {
    public static final String STATUS_UNDONE = "X";
    public static final String STATUS_SUCCESS = "0";
    public static final String STATUS_FAIL = "1";
    public static final String STATUS_NORESPONSE = "2";
    private String iMerchantNo = "";
    private String iBatchNo = "";
    private String iBatchDate = "";
    private String iOrderNo = "";
    private String iNewOrderNo = "";
    private double iOrderAmount = 0.0;
    private String iOrderStatus = "";
    private String iCurrency = "";
    public static final int ORDER_NO_LEN = 50;

    public RefundBatchDetail() {
    }

    public RefundBatchDetail(XMLDocument aXMLDocument) {
        this.setOrderNo(aXMLDocument.getValueNoNull("OrderNo"));
        this.setNewOrderNo(aXMLDocument.getValueNoNull("NewOrderNo"));
        try {
            this.setOrderAmount(Double.parseDouble(aXMLDocument.getValueNoNull("OrderAmount")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setOrderStatus(aXMLDocument.getValueNoNull("OrderStatus"));
    }

    public RefundBatchDetail setMerchantNo(String aMerchantNo) {
        this.iMerchantNo = aMerchantNo;
        return this;
    }

    public String getMerchantNo() {
        return this.iMerchantNo;
    }

    public RefundBatchDetail setBatchNo(String aBatchNo) {
        this.iBatchNo = aBatchNo;
        return this;
    }

    public String getBatchNo() {
        return this.iBatchNo;
    }

    public RefundBatchDetail setBatchDate(String aBatchDate) {
        this.iBatchDate = aBatchDate;
        return this;
    }

    public String getBatchDate() {
        return this.iBatchDate;
    }

    public RefundBatchDetail setOrderNo(String aOrderNo) {
        this.iOrderNo = aOrderNo;
        return this;
    }

    public String getOrderNo() {
        return this.iOrderNo;
    }

    public RefundBatchDetail setNewOrderNo(String aOrderNo) {
        this.iNewOrderNo = aOrderNo;
        return this;
    }

    public String getNewOrderNo() {
        return this.iNewOrderNo;
    }

    public RefundBatchDetail setOrderAmount(double aOrderAmount) {
        this.iOrderAmount = aOrderAmount;
        return this;
    }

    public double getOrderAmount() {
        return this.iOrderAmount;
    }

    public RefundBatchDetail setCurrency(String aCurrency) {
        this.iCurrency = aCurrency;
        return this;
    }

    public String getCurrency() {
        return this.iCurrency;
    }

    public RefundBatchDetail setOrderStatus(String aOrderStatus) {
        this.iOrderStatus = aOrderStatus;
        return this;
    }

    public String getOrderStatus() {
        return this.iOrderStatus;
    }

    public String getStatusChinese(String aStatus) {
        String tStatusChinese = "";
        tStatusChinese = aStatus.equals(STATUS_UNDONE) ? "\u672a\u5904\u7406" : (aStatus.equals(STATUS_SUCCESS) ? "\u5904\u7406\u6210\u529f" : (aStatus.equals(STATUS_FAIL) ? "\u5904\u7406\u5931\u8d25" : (aStatus.equals(STATUS_NORESPONSE) ? "\u65e0\u56de\u5e94" : "\u672a\u77e5\u72b6\u6001")));
        return tStatusChinese;
    }

    public void checkRequest() throws TrxException {
        if (!DataVerifier.isValidString(this.iOrderNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iNewOrderNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u65b0\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidAmount(this.iOrderAmount, 2)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8d26\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
    }
}

