/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    int port;
    String host;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$lang$String;

    public TcpNTAdapter(String string, Properties properties) throws NLException {
        this.socketOptions = properties;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        if (nVPair3 == null) {
            throw new NLException("NoNVPair-04614", "PORT");
        }
        this.host = nVPair2.getAtom();
        try {
            this.port = Integer.parseInt(nVPair3.getAtom());
        }
        catch (Exception exception) {
            throw new NLException(new NetException(116).getMessage());
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
    }

    public void connect() throws IOException {
        String string = (String)this.socketOptions.get(new Integer(2));
        if (string != null) {
            try {
                Class[] classArray = new Class[]{Class.forName("java.net.SocketAddress"), Integer.TYPE};
                Method method = (class$java$net$Socket == null ? (class$java$net$Socket = TcpNTAdapter.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", classArray);
                if (method != null) {
                    Class[] classArray2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TcpNTAdapter.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
                    Object[] objectArray = new Object[]{this.host, new Integer(this.port)};
                    Object[] objectArray2 = new Object[]{Class.forName("java.net.InetSocketAddress").getConstructor(classArray2).newInstance(objectArray), new Integer(string)};
                    this.socket = (Socket)Class.forName("java.net.Socket").newInstance();
                    method.invoke((Object)this.socket, objectArray2);
                    this.setSocketTimeout(Integer.parseInt(string));
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                    throw new NetException(503);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NetException(505);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket == null) {
            this.socket = new Socket(this.host, this.port);
        }
        this.setSocketOptions();
    }

    public void setSocketOptions() throws IOException {
        int n = 0;
        String string = null;
        Class clazz = class$java$net$Socket == null ? (class$java$net$Socket = TcpNTAdapter.class$("java.net.Socket")) : class$java$net$Socket;
        Class[] classArray = new Class[]{Boolean.TYPE};
        Object[] objectArray = new Object[]{Boolean.TRUE};
        Enumeration<Object> enumeration = this.socketOptions.keys();
        block13: while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            switch (n) {
                case 0: {
                    string = (String)this.socketOptions.get(new Integer(0));
                    try {
                        if (string.equals("YES")) {
                            this.socket.setTcpNoDelay(true);
                            continue block13;
                        }
                        this.socket.setTcpNoDelay(false);
                        continue block13;
                    }
                    catch (SocketException socketException) {
                        throw new IOException(socketException.getMessage());
                    }
                }
                case 1: {
                    string = (String)this.socketOptions.get(new Integer(1));
                    if (!string.equals("YES")) continue block13;
                    try {
                        Method method = clazz.getMethod("setKeepAlive", classArray);
                        if (method == null) continue block13;
                        method.invoke((Object)this.socket, objectArray);
                        continue block13;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue block13;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IOException(illegalAccessException.getMessage());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IOException(invocationTargetException.getMessage());
                    }
                }
                case 3: {
                    if (this.socketOptions.get(new Integer(2)) != null) continue block13;
                    string = (String)this.socketOptions.get(new Integer(3));
                    try {
                        this.sockTimeout = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NetException(506);
                    }
                    this.setSocketTimeout(this.sockTimeout);
                    continue block13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public void setOption(int n, Object object) throws IOException, NetException {
        switch (n) {
            case 1: {
                this.sockTimeout = Integer.parseInt((String)object);
                this.setSocketTimeout(this.sockTimeout);
                return;
            }
        }
    }

    public Object getOption(int n) throws IOException, NetException {
        switch (n) {
            case 1: {
                return "" + this.sockTimeout;
            }
        }
        return null;
    }

    private void setSocketTimeout(int n) throws IOException {
        if (this.socket != null) {
            try {
                Class clazz = class$java$net$Socket == null ? (class$java$net$Socket = TcpNTAdapter.class$("java.net.Socket")) : class$java$net$Socket;
                Class[] classArray = new Class[]{Integer.TYPE};
                Method method = clazz.getMethod("setSoTimeout", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{new Integer(n)};
                    method.invoke((Object)this.socket, objectArray);
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException(invocationTargetException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException.getMessage());
            }
        }
    }

    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    public void sendUrgentByte(int n) throws IOException {
        try {
            Class<?> clazz = this.socket.getClass();
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = clazz.getMethod("sendUrgentData", classArray);
            if (method != null) {
                Object[] objectArray = new Object[]{new Integer(n)};
                method.invoke((Object)this.socket, objectArray);
            }
        }
        catch (Exception exception) {
            throw new IOException("Not able to invoke Socket.sendUrgentData(), reason: " + exception.getMessage());
        }
    }

    public boolean isCharacteristicUrgentSupported() throws IOException {
        boolean bl = false;
        try {
            Class<?> clazz = this.socket.getClass();
            Method method = null;
            try {
                method = clazz.getMethod("getOOBInline", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
            if (method != null) {
                bl = (Boolean)method.invoke((Object)this.socket, null) == false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

