/*
 * Decompiled with CFR 0.152.
 */
package chinapay;

import chinapay.Des;
import chinapay.DesKey;
import chinapay.TripleDes;

public class DesRsa {
    public static char[] DigitalMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String i2a(int x, int len, int base) {
        char[] s = new char[len];
        int i = len - 1;
        while (i >= 0) {
            s[i] = DigitalMap[x % base];
            x /= base;
            --i;
        }
        return new String(s);
    }

    public static int c2i(char c) {
        int i = 0;
        while (i < 16) {
            if (c == DigitalMap[i]) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static byte[] byte2Key(byte[] key0, int len) {
        byte[] Key;
        block5: {
            int keylen;
            block4: {
                Key = new byte[len];
                keylen = key0.length;
                if (keylen == len) {
                    return key0;
                }
                if (keylen <= len) break block4;
                int i = 0;
                while (i < len) {
                    Key[i] = key0[i];
                    ++i;
                }
                break block5;
            }
            if (keylen >= len) break block5;
            int i = 0;
            while (i < keylen) {
                Key[i] = key0[i];
                ++i;
            }
            while (i < len) {
                Key[i] = 32;
                ++i;
            }
        }
        return Key;
    }

    public static String SingleDes(String ClearStr, byte[] key, boolean flag) {
        String OutStr;
        int i;
        byte[] clrb = new byte[8];
        byte[] iv = new byte[8];
        int j = 0;
        while (j < 8) {
            iv[j] = 0;
            ++j;
        }
        int keylen = key.length;
        byte[] key0 = DesRsa.byte2Key(key, 8);
        DesKey ks = new DesKey(key0, false);
        Des des = new Des(ks);
        int strlen = ClearStr.length();
        if (flag) {
            if (strlen > 8) {
                ClearStr = ClearStr.substring(0, 8);
            }
            if (strlen < 8) {
                i = 1;
                while (i <= 8 - strlen) {
                    ClearStr = String.valueOf(ClearStr) + " ";
                    ++i;
                }
            }
            clrb = ClearStr.getBytes();
        } else {
            if (strlen > 16) {
                ClearStr = ClearStr.substring(0, 16);
            }
            if (strlen < 16) {
                i = 1;
                while (i <= 16 - strlen) {
                    ClearStr = String.valueOf(ClearStr) + "0";
                    ++i;
                }
            }
            i = 0;
            while (i < 8) {
                clrb[i] = (byte)((DesRsa.c2i(ClearStr.charAt(i * 2)) & 0xF) << 4 | DesRsa.c2i(ClearStr.charAt(i * 2 + 1)) & 0xF);
                ++i;
            }
        }
        byte[] out = new byte[8];
        des.cbc_encrypt(clrb, 0, 8, out, 0, iv, flag);
        if (flag) {
            OutStr = "";
            i = 0;
            while (i < 8) {
                OutStr = String.valueOf(OutStr) + DesRsa.i2a(out[i] >> 4 & 0xF, 1, 16);
                OutStr = String.valueOf(OutStr) + DesRsa.i2a(out[i] & 0xF, 1, 16);
                ++i;
            }
        } else {
            OutStr = new String(out, 0, 8);
        }
        return OutStr;
    }

    public static String SingleDes(byte[] ClearStr, byte[] key, boolean flag) {
        String OutStr;
        int i;
        int idx;
        byte[] clrb = new byte[8];
        byte[] iv = new byte[8];
        int j = 0;
        while (j < 8) {
            iv[j] = 0;
            ++j;
        }
        int keylen = key.length;
        byte[] key0 = DesRsa.byte2Key(key, 8);
        DesKey ks = new DesKey(key0, false);
        Des des = new Des(ks);
        int strlen = ClearStr.length;
        if (flag) {
            if (strlen < 8) {
                idx = strlen;
                while (idx < 8) {
                    ClearStr[idx] = 0;
                    ++idx;
                }
            }
            idx = 0;
            while (idx < 8) {
                clrb[idx] = ClearStr[idx];
                ++idx;
            }
        } else {
            if (strlen < 16) {
                idx = strlen;
                while (idx < 8) {
                    ClearStr[idx] = 0;
                    ++idx;
                }
            }
            i = 0;
            while (i < 8) {
                clrb[i] = (byte)((DesRsa.c2i((char)ClearStr[i * 2]) & 0xF) << 4 | DesRsa.c2i((char)ClearStr[i * 2 + 1]) & 0xF);
                ++i;
            }
        }
        byte[] out = new byte[8];
        des.cbc_encrypt(clrb, 0, 8, out, 0, iv, flag);
        if (flag) {
            OutStr = "";
            i = 0;
            while (i < 8) {
                OutStr = String.valueOf(OutStr) + DesRsa.i2a(out[i] >> 4 & 0xF, 1, 16);
                OutStr = String.valueOf(OutStr) + DesRsa.i2a(out[i] & 0xF, 1, 16);
                ++i;
            }
        } else {
            OutStr = new String(out, 0, 8);
        }
        return OutStr;
    }

    public static String SingleDesEnc(byte[] ClearStr, byte[] key) {
        return DesRsa.SingleDes(ClearStr, key, true);
    }

    public static String SingleDesEnc(String ClearStr, byte[] key) {
        return DesRsa.SingleDes(ClearStr, key, true);
    }

    public static String SingleDesDec(String ClearStr, byte[] key) {
        return DesRsa.SingleDes(ClearStr, key, false);
    }

    public static String TripleDes(String ClearStr, byte[] Key, boolean flag) {
        String OutStr;
        byte[] clrb = new byte[8];
        byte[] iv = new byte[8];
        int j = 0;
        while (j < 8) {
            iv[j] = 0;
            ++j;
        }
        byte[] key1 = DesRsa.byte2Key(Key, 16);
        byte[] key2 = new byte[8];
        int i = 0;
        while (i < 8) {
            key2[i] = key1[8 + i];
            ++i;
        }
        DesKey ks1 = new DesKey(key1, false);
        DesKey ks2 = new DesKey(key2, false);
        TripleDes tdes = new TripleDes(ks1, ks2);
        int strlen = ClearStr.length();
        if (flag) {
            if (strlen > 8) {
                ClearStr = ClearStr.substring(0, 8);
            }
            if (strlen < 8) {
                i = 1;
                while (i <= 8 - strlen) {
                    ClearStr = String.valueOf(ClearStr) + " ";
                    ++i;
                }
            }
            clrb = ClearStr.getBytes();
        } else {
            if (strlen > 16) {
                ClearStr = ClearStr.substring(0, 16);
            }
            if (strlen < 16) {
                i = 1;
                while (i <= 16 - strlen) {
                    ClearStr = String.valueOf(ClearStr) + "0";
                    ++i;
                }
            }
            i = 0;
            while (i < 8) {
                clrb[i] = (byte)((DesRsa.c2i(ClearStr.charAt(i * 2)) & 0xF) << 4 | DesRsa.c2i(ClearStr.charAt(i * 2 + 1)) & 0xF);
                ++i;
            }
        }
        byte[] out = new byte[8];
        tdes.cbc_encrypt(clrb, 0, 8, out, 0, iv, flag);
        if (flag) {
            OutStr = "";
            i = 0;
            while (i < 8) {
                OutStr = String.valueOf(OutStr) + DesRsa.i2a(out[i] >> 4 & 0xF, 1, 16);
                OutStr = String.valueOf(OutStr) + DesRsa.i2a(out[i] & 0xF, 1, 16);
                ++i;
            }
        } else {
            OutStr = new String(out, 0, 8);
        }
        return OutStr;
    }

    public static String TripleDesEnc(String ClearStr, byte[] Key) {
        return DesRsa.TripleDes(ClearStr, Key, true);
    }

    public static String TripleDesDec(String ClearStr, byte[] Key) {
        return DesRsa.TripleDes(ClearStr, Key, false);
    }

    String DES0(String Key, String s_text) {
        String d_text = "";
        int len = s_text.length();
        int k = len % 8 == 0 ? len / 8 : len / 8 + 1;
        s_text = String.valueOf(s_text) + "         ";
        int i = 0;
        while (i < k) {
            String buf1 = s_text.substring(i * 8, (i + 1) * 8);
            String buf2 = DesRsa.SingleDesEnc(buf1, Key.getBytes());
            d_text = String.valueOf(d_text) + buf2;
            ++i;
        }
        return d_text;
    }

    String _DES0(String Key, String s_text) {
        String d_text = "";
        int len = s_text.length();
        int k = len % 16 == 0 ? len / 16 : len / 16 + 1;
        int i = 0;
        while (i < k) {
            String buf1 = s_text.substring(i * 16, (i + 1) * 16);
            String buf2 = DesRsa.SingleDesDec(buf1, Key.getBytes());
            d_text = String.valueOf(d_text) + buf2;
            ++i;
        }
        return d_text;
    }

    public static byte[] bTripleDes(byte[] clrb, byte[] key, boolean flag) {
        byte[] iv = new byte[8];
        int j = 0;
        while (j < 8) {
            iv[j] = 0;
            ++j;
        }
        byte[] key1 = new byte[8];
        byte[] key2 = new byte[8];
        int i = 0;
        while (i < 8) {
            key1[i] = key[i];
            key2[i] = key[i + 8];
            ++i;
        }
        DesKey ks1 = new DesKey(key1, false);
        DesKey ks2 = new DesKey(key2, false);
        TripleDes tdes = new TripleDes(ks1, ks2);
        byte[] out = new byte[8];
        tdes.cbc_encrypt(clrb, 0, 8, out, 0, iv, flag);
        return out;
    }

    public static byte[] bTripleDesEnc(byte[] ClearStr, byte[] Key) {
        return DesRsa.bTripleDes(ClearStr, Key, true);
    }

    public static byte[] bTripleDesDec(byte[] ClearStr, byte[] Key) {
        return DesRsa.bTripleDes(ClearStr, Key, false);
    }

    public byte[] DES3b(byte[] Key, byte[] s_text) {
        byte[] buf1 = new byte[8];
        byte[] buf2 = new byte[8];
        byte[] IV_temp = "ChinaPay".getBytes();
        byte[] tail = "         ".getBytes();
        int len = s_text.length;
        byte[] bText = new byte[len + tail.length];
        int k = len % 8 == 0 ? len / 8 : len / 8 + 1;
        System.arraycopy(s_text, 0, bText, 0, len);
        System.arraycopy(tail, 0, bText, len, tail.length);
        byte[] d_text = new byte[k * 8];
        int i = 0;
        while (i < k) {
            System.arraycopy(bText, i * 8, buf1, 0, 8);
            int j = 0;
            while (j < 8) {
                buf1[j] = (byte)(IV_temp[j] ^ buf1[j]);
                ++j;
            }
            buf2 = DesRsa.bTripleDesEnc(buf1, Key);
            j = 0;
            while (j < 8) {
                IV_temp[j] = buf2[j];
                ++j;
            }
            System.arraycopy(d_text, 0, d_text, 0, i * 8);
            System.arraycopy(buf2, 0, d_text, i * 8, 8);
            ++i;
        }
        return d_text;
    }

    byte[] _DES3bs(byte[] Key, byte[] stringgetbyte) {
        String sorg = new String(stringgetbyte);
        int slen = sorg.length();
        if (slen % 8 != 0) {
            byte[] err = "InStream bitNum wrong!".getBytes();
            return err;
        }
        byte[] bOrg = DesRsa.Asc2Hex(slen, sorg);
        return this._DES3b(Key, bOrg);
    }

    public byte[] _DES3b(byte[] Key, byte[] s_text) {
        byte[] buf1 = new byte[8];
        byte[] buf2 = new byte[8];
        byte[] IV_temp = "ChinaPay".getBytes();
        int len = s_text.length;
        int k = len % 8 == 0 ? len / 8 : len / 8 + 1;
        byte[] d_text = new byte[k * 8];
        int i = 0;
        while (i < k) {
            System.arraycopy(s_text, i * 8, buf1, 0, 8);
            buf2 = DesRsa.bTripleDesDec(buf1, Key);
            int j = 0;
            while (j < 8) {
                buf2[j] = (byte)(IV_temp[j] ^ buf2[j]);
                IV_temp[j] = buf1[j];
                ++j;
            }
            System.arraycopy(buf2, 0, d_text, i * 8, 8);
            ++i;
        }
        return d_text;
    }

    public static String Hex2Asc(int len, byte[] in) {
        byte[] out = new byte[2 * len];
        int i = 0;
        while (i < len) {
            byte h = (byte)(in[i] >> 4);
            h = (byte)(h & 0xF);
            byte l = (byte)(in[i] & 0xF);
            out[i * 2] = (byte)(h > 9 ? 65 + h - 10 : 48 + h);
            out[i * 2 + 1] = (byte)(l > 9 ? 65 + l - 10 : 48 + l);
            ++i;
        }
        return new String(out);
    }

    public static byte[] Asc2Hex(int len, String in) {
        char ch;
        in = in.toUpperCase();
        if (len % 2 != 0) {
            return null;
        }
        int i = 0;
        while (i < len) {
            ch = in.charAt(i);
            if (ch < '0' || ch > '9' && ch < 'A' || ch > 'Z') {
                return null;
            }
            ++i;
        }
        byte[] out = new byte[len / 2];
        i = 0;
        while (i < len / 2) {
            ch = in.charAt(i * 2);
            byte h = (byte)(ch >= '0' && ch <= '9' ? ch - 48 : ch - 65 + 10);
            ch = in.charAt(i * 2 + 1);
            byte l = (byte)(ch >= '0' && ch <= '9' ? ch - 48 : ch - 65 + 10);
            out[i] = (byte)(h * 16 + l);
            ++i;
        }
        return out;
    }
}

