/*
 * Decompiled with CFR 0.152.
 */
package chinapay;

public class ShaHash {
    private int hashSize = 20;
    private byte[] hashBytes;
    private static final boolean USE_MODIFIED_SHA = true;
    private static final int SHA_BLOCKSIZE = 64;
    private static final int SHA_DIGESTSIZE = 20;
    private int[] digest = new int[5];
    private long bitCount;
    private byte[] dataB = new byte[64];
    private int[] dataI = new int[16];
    private static final int K1 = 1518500249;
    private static final int K2 = 1859775393;
    private static final int K3 = -1894007588;
    private static final int K4 = -899497514;
    private static final int h0init = 1732584193;
    private static final int h1init = -271733879;
    private static final int h2init = -1732584194;
    private static final int h3init = 271733878;
    private static final int h4init = -1009589776;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int A;
    private int B;
    private int C;
    private int D;
    private int E;
    private int[] W = new int[80];

    public ShaHash() {
        this.hashBytes = new byte[20];
    }

    public void add(byte[] data, int off, int len) {
        this.reset();
        this.shaUpdate(data, off, len);
    }

    public static void copyBlock(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        int i = 0;
        while (i < len) {
            dst[dstOff + i] = src[srcOff + i];
            ++i;
        }
    }

    private static int f1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int f2(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int f3(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private static int f4(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static void fillBlock(byte[] block, byte b) {
        ShaHash.fillBlock(block, 0, b, block.length);
    }

    private static void fillBlock(byte[] block, int blockOff, byte b, int len) {
        int i = blockOff;
        while (i < blockOff + len) {
            block[i] = b;
            ++i;
        }
    }

    public byte[] get() {
        this.prepare();
        byte[] hb = new byte[this.hashSize + 108];
        byte[] byArray = new byte[128];
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[48] = -1;
        byArray[49] = -1;
        byArray[50] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[53] = -1;
        byArray[54] = -1;
        byArray[55] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[65] = -1;
        byArray[66] = -1;
        byArray[67] = -1;
        byArray[68] = -1;
        byArray[69] = -1;
        byArray[70] = -1;
        byArray[71] = -1;
        byArray[72] = -1;
        byArray[73] = -1;
        byArray[74] = -1;
        byArray[75] = -1;
        byArray[76] = -1;
        byArray[77] = -1;
        byArray[78] = -1;
        byArray[79] = -1;
        byArray[80] = -1;
        byArray[81] = -1;
        byArray[82] = -1;
        byArray[83] = -1;
        byArray[84] = -1;
        byArray[85] = -1;
        byArray[86] = -1;
        byArray[87] = -1;
        byArray[88] = -1;
        byArray[89] = -1;
        byArray[90] = -1;
        byArray[91] = -1;
        byArray[93] = 48;
        byArray[94] = 33;
        byArray[95] = 48;
        byArray[96] = 9;
        byArray[97] = 6;
        byArray[98] = 5;
        byArray[99] = 43;
        byArray[100] = 14;
        byArray[101] = 3;
        byArray[102] = 2;
        byArray[103] = 26;
        byArray[104] = 5;
        byArray[106] = 4;
        byArray[107] = 20;
        byte[] HashpadString = byArray;
        System.arraycopy(HashpadString, 0, hb, 0, 108);
        System.arraycopy(this.hashBytes, 0, hb, 108, this.hashSize);
        return hb;
    }

    public void prepare() {
        this.shaFinal();
        ShaHash.spreadIntsToBytes(this.digest, 0, this.hashBytes, 0, 5);
    }

    public void reset() {
        this.shaInit();
    }

    private static int rotateL(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    public void shaFinal() {
        int count = (int)(this.bitCount >>> 3) & 0x3F;
        this.dataB[count++] = -128;
        if (count > 56) {
            ShaHash.fillBlock(this.dataB, count, (byte)0, 64 - count);
            ShaHash.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
            this.shaTransform();
            ShaHash.fillBlock(this.dataB, 0, (byte)0, 56);
        } else {
            ShaHash.fillBlock(this.dataB, count, (byte)0, 56 - count);
        }
        ShaHash.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
        this.dataI[14] = (int)(this.bitCount >>> 32);
        this.dataI[15] = (int)(this.bitCount & 0xFFFFFFFFFFFFFFFFL);
        this.shaTransform();
    }

    private void shaInit() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
        this.digest[4] = -1009589776;
        this.bitCount = 0L;
    }

    public void shaTransform() {
        int i = 0;
        while (i < 16) {
            this.W[i] = this.dataI[i];
            ++i;
        }
        while (i < 80) {
            this.W[i] = this.W[i - 3] ^ this.W[i - 8] ^ this.W[i - 14] ^ this.W[i - 16];
            this.W[i] = ShaHash.rotateL(this.W[i], 1);
            ++i;
        }
        this.A = this.digest[0];
        this.B = this.digest[1];
        this.C = this.digest[2];
        this.D = this.digest[3];
        this.E = this.digest[4];
        i = 0;
        while (i < 20) {
            this.subRound1(i);
            ++i;
        }
        while (i < 40) {
            this.subRound2(i);
            ++i;
        }
        while (i < 60) {
            this.subRound3(i);
            ++i;
        }
        while (i < 80) {
            this.subRound4(i);
            ++i;
        }
        this.digest[0] = this.digest[0] + this.A;
        this.digest[1] = this.digest[1] + this.B;
        this.digest[2] = this.digest[2] + this.C;
        this.digest[3] = this.digest[3] + this.D;
        this.digest[4] = this.digest[4] + this.E;
    }

    public void shaUpdate(byte[] buffer, int offset, int count) {
        this.bitCount += (long)(count << 3);
        while (count >= 64) {
            ShaHash.copyBlock(buffer, offset, this.dataB, 0, 64);
            ShaHash.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
            this.shaTransform();
            offset += 64;
            count -= 64;
        }
        ShaHash.copyBlock(buffer, offset, this.dataB, 0, count);
    }

    private static void spreadIntsToBytes(int[] inInts, int inOff, byte[] outBytes, int outOff, int intLen) {
        int i = 0;
        while (i < intLen) {
            outBytes[outOff + i * 4] = (byte)(inInts[inOff + i] >>> 24);
            outBytes[outOff + i * 4 + 1] = (byte)(inInts[inOff + i] >>> 16);
            outBytes[outOff + i * 4 + 2] = (byte)(inInts[inOff + i] >>> 8);
            outBytes[outOff + i * 4 + 3] = (byte)inInts[inOff + i];
            ++i;
        }
    }

    private static void squashBytesToInts(byte[] inBytes, int inOff, int[] outInts, int outOff, int intLen) {
        int i = 0;
        while (i < intLen) {
            outInts[outOff + i] = (inBytes[inOff + i * 4] & 0xFF) << 24 | (inBytes[inOff + i * 4 + 1] & 0xFF) << 16 | (inBytes[inOff + i * 4 + 2] & 0xFF) << 8 | inBytes[inOff + i * 4 + 3] & 0xFF;
            ++i;
        }
    }

    private void subRound1(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f1(this.B, this.C, this.D) + this.E + this.W[count] + 1518500249;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private void subRound2(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f2(this.B, this.C, this.D) + this.E + this.W[count] + 1859775393;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private void subRound3(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f3(this.B, this.C, this.D) + this.E + this.W[count] + -1894007588;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private void subRound4(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f4(this.B, this.C, this.D) + this.E + this.W[count] + -899497514;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private static String toStringBlock(byte[] block) {
        return ShaHash.toStringBlock(block, 0, block.length);
    }

    private static String toStringBlock(byte[] block, int off, int len) {
        String hexits = "0123456789abcdef";
        StringBuffer buf = new StringBuffer();
        int i = off;
        while (i < off + len) {
            buf.append(hexits.charAt(block[i] >>> 4 & 0xF));
            buf.append(hexits.charAt(block[i] & 0xF));
            ++i;
        }
        return String.valueOf(String.valueOf(buf));
    }
}

