/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionCacheTimeOutThread;
import oracle.jdbc.pool.OracleConnectionEventListener;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheImpl
extends OracleDataSource
implements OracleConnectionCache,
Serializable,
Referenceable {
    protected ConnectionPoolDataSource cpds = null;
    protected static int _DEFAULT_MIN_LIMIT = 0;
    protected static int _DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected int _MIN_LIMIT = _DEFAULT_MIN_LIMIT;
    protected int _MAX_LIMIT = _DEFAULT_MAX_LIMIT;
    protected static final int DEFAULT_CACHE_TIMEOUT = -1;
    protected static final int DEFAULT_THREAD_INTERVAL = 900;
    public static final int ORAERROR_END_OF_FILE_ON_COCHANNEL = 3113;
    public static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    public static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    public static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    public static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    public static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    public static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected long cacheTTLTimeOut = -1L;
    protected long cacheInactivityTimeOut = -1L;
    protected long cacheFixedWaitTimeOut = -1L;
    protected long threadInterval = 900L;
    Stack cache = new Stack();
    Hashtable activeCache = new Hashtable(50);
    private Object CACHE_SIZE_LOCK = new String("");
    protected int cacheSize = 0;
    protected int activeSize = 0;
    protected int cacheScheme = 1;
    protected long cleanupInterval = 30L;
    protected int[] fatalErrorCodes = null;
    public static final long DEFAULT_FIXED_WAIT_IDLE_TIME = 30L;
    protected long fixedWaitIdleTime = -1L;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    protected OracleConnectionEventListener ocel = null;
    protected int stmtCacheSize = 0;
    protected boolean stmtClearMetaData = false;
    protected OracleConnectionCacheTimeOutThread timeOutThread = null;
    SQLWarning warning = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Thu_Apr__8_03:39:21_PDT_2010";

    public OracleConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        this.cpds = connectionPoolDataSource;
        this.ocel = new OracleConnectionEventListener(this);
        this.dataSourceName = "OracleConnectionCacheImpl";
        this.isOracleDataSource = false;
    }

    public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        if (this.cacheSize > 0) {
            DatabaseError.throwSqlException(78);
        }
        this.cpds = connectionPoolDataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        Connection connection = null;
        PooledConnection pooledConnection = this.getPooledConnection(string, string2);
        if (pooledConnection != null) {
            connection = pooledConnection.getConnection();
        }
        if (connection != null) {
            ((OracleConnection)connection).setStartTime(System.currentTimeMillis());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected PooledConnection getPooledConnection(String var1_1, String var2_2) throws SQLException {
        var3_3 = null;
        var4_4 = false;
        var5_5 = false;
        var6_6 = 0x7FFFFFFFFFFFFFFFL;
        var8_7 = null;
        var9_8 /* !! */  = this;
        synchronized (var9_8 /* !! */ ) {
            if (!this.cache.empty()) {
                this.checkCredentials(var1_1, var2_2);
                var3_3 = this.removeConnectionFromCache();
            } else if (this.cacheSize < this._MAX_LIMIT || this.cacheScheme == 1) {
                var10_10 = null;
                var11_12 = null;
                if (this.cpds != null) {
                    var10_10 = ((OracleConnectionPoolDataSource)this.cpds).getUser();
                    var11_12 = ((OracleConnectionPoolDataSource)this.cpds).getPassword();
                }
                if (this.cacheSize > 0 && var1_1 != null && !var1_1.equalsIgnoreCase((String)var10_10)) {
                    DatabaseError.throwSqlException(79);
                }
                if (this.cacheSize > 0 && var2_2 != null && !var2_2.equalsIgnoreCase(var11_12)) {
                    DatabaseError.throwSqlException(79);
                }
                var4_4 = true;
                var8_7 = new Properties();
                if (this.url != null) {
                    var8_7.setProperty("connection_url", this.url);
                }
                if (var1_1 != null) {
                    var8_7.setProperty("user", var1_1);
                } else if (this.cpds != null && ((OracleDataSource)this.cpds).user != null) {
                    var8_7.setProperty("user", ((OracleDataSource)this.cpds).user);
                }
                if (var2_2 != null) {
                    var8_7.setProperty("password", var2_2);
                } else if (this.cpds != null && ((OracleDataSource)this.cpds).password != null) {
                    var8_7.setProperty("password", ((OracleDataSource)this.cpds).password);
                }
                if (this.stmtCacheSize == 0 && this.cpds != null && ((OracleDataSource)this.cpds).maxStatements != 0) {
                    var8_7.setProperty("stmt_cache_size", "" + ((OracleDataSource)this.cpds).maxStatements);
                } else {
                    var8_7.setProperty("stmt_cache_size", "" + this.stmtCacheSize);
                    var8_7.setProperty("stmt_cache_clear_metadata", "" + this.stmtClearMetaData);
                    var8_7.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                    var8_7.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                }
                if (this.loginTimeout != 0) {
                    var8_7.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                var12_13 = this.CACHE_SIZE_LOCK;
                synchronized (var12_13) {
                    ++this.cacheSize;
                }
                if (this.cpds == null) {
                    this.initializeConnectionPoolDataSource();
                }
            } else if (this.cacheScheme != 3) {
                this.checkCredentials(var1_1, var2_2);
                var6_6 = System.currentTimeMillis();
                var5_5 = true;
            }
        }
        if (var4_4) {
            try {
                var3_3 = this.getNewPoolOrXAConnection(var8_7);
                if (var3_3 == null) ** GOTO lbl119
                var3_3.addConnectionEventListener(this.ocel);
            }
            catch (SQLException var9_9) {
                var10_10 = this.CACHE_SIZE_LOCK;
                synchronized (var10_10) {
                    --this.cacheSize;
                }
                throw var9_9;
            }
        } else {
            if (var5_5) {
                while (var3_3 == null && this.cache.empty()) {
                    var9_8 /* !! */  = this;
                    synchronized (var9_8 /* !! */ ) {
                        if (this.cacheFixedWaitTimeOut > 0L && System.currentTimeMillis() - var6_6 > this.cacheFixedWaitTimeOut * 1000L) {
                            DatabaseError.throwSqlException(126);
                        }
                    }
                    var9_8 /* !! */  = this.cache;
                    synchronized (var9_8 /* !! */ ) {
                        try {
                            this.cache.wait((this.fixedWaitIdleTime == -1L ? 30L : this.fixedWaitIdleTime) * 1000L);
                        }
                        catch (InterruptedException var10_11) {
                            // empty catch block
                        }
                        if (!this.cache.empty()) {
                            var3_3 = this.removeConnectionFromCache();
                        }
                    }
                }
            }
            if (var3_3 != null && this.stmtCacheSize > 0) {
                if (!this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                    ((OraclePooledConnection)var3_3).setStmtCacheSize(this.stmtCacheSize);
                } else {
                    ((OraclePooledConnection)var3_3).setStatementCacheSize(this.stmtCacheSize);
                    ((OraclePooledConnection)var3_3).setExplicitCachingEnabled(this.explicitCachingEnabled);
                    ((OraclePooledConnection)var3_3).setImplicitCachingEnabled(this.implicitCachingEnabled);
                }
            }
        }
lbl119:
        // 6 sources

        if (var3_3 != null) {
            if (!var4_4) {
                ((OraclePooledConnection)var3_3).physicalConn.setDefaultRowPrefetch(10);
                ((OraclePooledConnection)var3_3).physicalConn.setDefaultExecuteBatch(1);
            }
            this.activeCache.put(var3_3, var3_3);
            var9_8 /* !! */  = this;
            synchronized (var9_8 /* !! */ ) {
                this.activeSize = this.activeCache.size();
            }
        }
        return var3_3;
    }

    PooledConnection getNewPoolOrXAConnection(Properties properties) throws SQLException {
        PooledConnection pooledConnection = ((OracleConnectionPoolDataSource)this.cpds).getPooledConnection(properties);
        return pooledConnection;
    }

    public void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.detachSingleConnection(pooledConnection);
        if (this.cache.size() >= this._MAX_LIMIT && this.cacheScheme == 1) {
            this.closeSingleConnection(pooledConnection, false);
        } else {
            this.putConnectionToCache(pooledConnection);
        }
    }

    public void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.detachSingleConnection(pooledConnection);
        this.closeSingleConnection(pooledConnection, false);
    }

    private void detachSingleConnection(PooledConnection pooledConnection) {
        this.activeCache.remove(pooledConnection);
        this.activeSize = this.activeCache.size();
    }

    public void closeSingleConnection(PooledConnection pooledConnection) throws SQLException {
        this.closeSingleConnection(pooledConnection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeSingleConnection(PooledConnection pooledConnection, boolean bl) throws SQLException {
        if (!this.removeConnectionFromCache(pooledConnection) && bl) {
            return;
        }
        try {
            pooledConnection.removeConnectionEventListener(this.ocel);
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            this.warning = DatabaseError.addSqlWarning(this.warning, new SQLWarning(sQLException.getMessage()));
        }
        Object object = this.CACHE_SIZE_LOCK;
        synchronized (object) {
            --this.cacheSize;
        }
    }

    public synchronized void close() throws SQLException {
        this.closeConnections();
        this.cache = null;
        this.activeCache = null;
        this.ocel = null;
        this.cpds = null;
        this.timeOutThread = null;
        this.clearWarnings();
    }

    public void closeConnections() {
        OraclePooledConnection oraclePooledConnection;
        Enumeration enumeration = this.activeCache.keys();
        while (enumeration.hasMoreElements()) {
            try {
                OraclePooledConnection oraclePooledConnection2 = (OraclePooledConnection)enumeration.nextElement();
                oraclePooledConnection = (OraclePooledConnection)this.activeCache.get(oraclePooledConnection2);
                if (oraclePooledConnection == null) continue;
                oraclePooledConnection.removeConnectionEventListener(this.ocel);
                this.detachSingleConnection(oraclePooledConnection);
                this.closeSingleConnection(oraclePooledConnection, false);
            }
            catch (Exception exception) {}
        }
        while (!this.cache.empty()) {
            try {
                oraclePooledConnection = (OraclePooledConnection)this.cache.peek();
                oraclePooledConnection.removeConnectionEventListener(this.ocel);
                this.closeSingleConnection(oraclePooledConnection, false);
            }
            catch (SQLException sQLException) {}
        }
    }

    public synchronized void setConnectionCleanupInterval(long l) throws SQLException {
        if (l > 0L) {
            this.cleanupInterval = l;
        }
    }

    public long getConnectionCleanupInterval() throws SQLException {
        return this.cleanupInterval;
    }

    public synchronized void setConnectionErrorCodes(int[] nArray) throws SQLException {
        if (nArray != null) {
            // empty if block
        }
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        return this.fatalErrorCodes;
    }

    public boolean isFatalConnectionError(SQLException sQLException) {
        if (this.cleanupInterval < 0L) {
            return false;
        }
        boolean bl = false;
        int n = sQLException.getErrorCode();
        if (n == 3113 || n == 3114 || n == 1033 || n == 1034 || n == 1089 || n == 1090 || n == 17002) {
            bl = true;
        } else if (this.fatalErrorCodes != null) {
            for (int i = 0; i < this.fatalErrorCodes.length; ++i) {
                if (n != this.fatalErrorCodes[i]) continue;
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void setMinLimit(int n) throws SQLException {
        if (n < 0 || n > this._MAX_LIMIT) {
            DatabaseError.throwSqlException(68);
        }
        this._MIN_LIMIT = n;
        if (this.cpds == null) {
            this.initializeConnectionPoolDataSource();
        }
        if (this.cacheSize < this._MIN_LIMIT) {
            Properties properties = new Properties();
            if (this.url != null) {
                properties.setProperty("connection_url", this.url);
            }
            if (this.user != null) {
                properties.setProperty("user", this.user);
            }
            if (this.password != null) {
                properties.setProperty("password", this.password);
            }
            if (this.stmtCacheSize == 0 && this.maxStatements != 0) {
                properties.setProperty("stmt_cache_size", "" + this.maxStatements);
            } else {
                properties.setProperty("stmt_cache_size", "" + this.stmtCacheSize);
                properties.setProperty("stmt_cache_clear_metadata", "" + this.stmtClearMetaData);
                properties.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                properties.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
            }
            properties.setProperty("LoginTimeout", "" + this.loginTimeout);
            for (int i = this.cacheSize; i < this._MIN_LIMIT; ++i) {
                PooledConnection pooledConnection = this.getNewPoolOrXAConnection(properties);
                if (pooledConnection != null) {
                    pooledConnection.addConnectionEventListener(this.ocel);
                }
                this.putConnectionToCache(pooledConnection);
            }
            this.cacheSize = this._MIN_LIMIT;
        }
    }

    void initializeConnectionPoolDataSource() throws SQLException {
        if (this.cpds == null) {
            if (this.user == null || this.password == null) {
                DatabaseError.throwSqlException(79);
            }
            this.cpds = new OracleConnectionPoolDataSource();
            this.copy((OracleDataSource)((Object)this.cpds));
        }
    }

    public synchronized int getMinLimit() {
        return this._MIN_LIMIT;
    }

    public synchronized void setMaxLimit(int n) throws SQLException {
        if (n < 0 || n < this._MIN_LIMIT) {
            DatabaseError.throwSqlException(68);
        }
        this._MAX_LIMIT = n;
        if (this.cacheSize > this._MAX_LIMIT && this.cacheScheme != 1) {
            for (int i = this._MAX_LIMIT; i < this.cacheSize; ++i) {
                if (this.cache.empty()) {
                    DatabaseError.throwSqlException(78);
                    continue;
                }
                OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.removeConnectionFromCache();
                oraclePooledConnection.removeConnectionEventListener(this.ocel);
                oraclePooledConnection.close();
            }
            this.cacheSize = this._MAX_LIMIT;
        }
    }

    public synchronized int getMaxLimit() {
        return this._MAX_LIMIT;
    }

    public synchronized int getCacheScheme() {
        return this.cacheScheme;
    }

    public synchronized void setCacheScheme(int n) throws SQLException {
        if (n == 1 || n == 3 || n == 2) {
            this.cacheScheme = n;
            return;
        }
        DatabaseError.throwSqlException(68);
    }

    public synchronized void setCacheScheme(String string) throws SQLException {
        if (string.equalsIgnoreCase("DYNAMIC_SCHEME")) {
            this.cacheScheme = 1;
        } else if (string.equalsIgnoreCase("FIXED_RETURN_NULL_SCHEME")) {
            this.cacheScheme = 3;
        } else if (string.equalsIgnoreCase("FIXED_WAIT_SCHEME")) {
            this.cacheScheme = 2;
        } else {
            DatabaseError.throwSqlException(68);
        }
    }

    public synchronized int getActiveSize() {
        return this.activeSize;
    }

    public synchronized int getCacheSize() {
        return this.cacheSize;
    }

    public synchronized void setCacheTimeToLiveTimeout(long l) throws SQLException {
        if (this.timeOutThread == null) {
            this.timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (l <= 0L) {
            this.cacheTTLTimeOut = -1L;
            this.warning = DatabaseError.addSqlWarning(this.warning, 111);
        } else {
            this.cacheTTLTimeOut = l;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setCacheInactivityTimeout(long l) throws SQLException {
        if (this.timeOutThread == null) {
            this.timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (l <= 0L) {
            this.cacheInactivityTimeOut = -1L;
            this.warning = DatabaseError.addSqlWarning(this.warning, 124);
        } else {
            this.cacheInactivityTimeOut = l;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setCacheFixedWaitTimeout(long l) throws SQLException {
        if (l <= 0L) {
            this.cacheFixedWaitTimeOut = -1L;
            this.warning = DatabaseError.addSqlWarning(this.warning, 127);
        } else {
            this.cacheFixedWaitTimeOut = l;
        }
    }

    public long getCacheTimeToLiveTimeout() throws SQLException {
        return this.cacheTTLTimeOut;
    }

    public long getCacheInactivityTimeout() throws SQLException {
        return this.cacheInactivityTimeOut;
    }

    public long getCacheFixedWaitTimeout() throws SQLException {
        return this.cacheFixedWaitTimeOut;
    }

    public synchronized void setThreadWakeUpInterval(long l) throws SQLException {
        if (l <= 0L) {
            this.threadInterval = 900L;
            this.warning = DatabaseError.addSqlWarning(this.warning, 112);
        } else {
            this.threadInterval = l;
        }
        if (this.cacheTTLTimeOut > 0L && this.threadInterval > this.cacheTTLTimeOut || this.cacheInactivityTimeOut > 0L && this.threadInterval > this.cacheInactivityTimeOut) {
            this.warning = DatabaseError.addSqlWarning(this.warning, 113);
        }
    }

    public long getThreadWakeUpInterval() throws SQLException {
        return this.threadInterval;
    }

    private void checkAndStartTimeOutThread() throws SQLException {
        try {
            if (!this.timeOutThread.isAlive()) {
                this.timeOutThread.setDaemon(true);
                this.timeOutThread.start();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warning;
    }

    public void clearWarnings() throws SQLException {
        this.warning = null;
    }

    private final void checkCredentials(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        if (this.cpds != null) {
            string3 = ((OracleConnectionPoolDataSource)this.cpds).getUser();
            string4 = ((OracleConnectionPoolDataSource)this.cpds).getPassword();
        }
        if (string != null && !string.equals(string3) || string2 != null && !string2.equals(string4)) {
            DatabaseError.throwSqlException(79);
        }
    }

    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        if (this._MIN_LIMIT != _DEFAULT_MIN_LIMIT) {
            reference.add(new StringRefAddr("minLimit", Integer.toString(this._MIN_LIMIT)));
        }
        if (this._MAX_LIMIT != _DEFAULT_MAX_LIMIT) {
            reference.add(new StringRefAddr("maxLimit", Integer.toString(this._MAX_LIMIT)));
        }
        if (this.cacheScheme != 1) {
            reference.add(new StringRefAddr("cacheScheme", Integer.toString(this.cacheScheme)));
        }
        return reference;
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.stmtCacheSize = n;
        this.stmtClearMetaData = bl;
    }

    public synchronized int getStmtCacheSize() {
        return this.stmtCacheSize;
    }

    synchronized boolean isStmtCacheEnabled() {
        return this.stmtCacheSize > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putConnectionToCache(PooledConnection pooledConnection) throws SQLException {
        ((OraclePooledConnection)pooledConnection).setLastAccessedTime(System.currentTimeMillis());
        this.cache.push(pooledConnection);
        Stack stack = this.cache;
        synchronized (stack) {
            this.cache.notify();
        }
    }

    private PooledConnection removeConnectionFromCache() throws SQLException {
        return (PooledConnection)this.cache.pop();
    }

    private boolean removeConnectionFromCache(PooledConnection pooledConnection) throws SQLException {
        return this.cache.removeElement(pooledConnection);
    }

    public synchronized void setCacheFixedWaitIdleTime(long l) throws SQLException {
        if (this.cacheScheme == 2) {
            if (l <= 0L) {
                DatabaseError.addSqlWarning(this.warning, 68);
                this.fixedWaitIdleTime = 30L;
            } else {
                this.fixedWaitIdleTime = l;
            }
        } else {
            DatabaseError.addSqlWarning(this.warning, new SQLWarning("Caching scheme is not FIXED_WAIT_SCHEME"));
        }
    }

    public long getCacheFixedWaitIdleTime() throws SQLException {
        return this.fixedWaitIdleTime == -1L ? 30L : this.fixedWaitIdleTime;
    }
}

