/*
 * Decompiled with CFR 0.152.
 */
package chinapay;

import chinapay.DesRsa;
import chinapay.PrivateKey;
import chinapay.RSAEncrypt;
import chinapay.ShaHash;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Random;

public class SecureLink {
    private String IpAddress;
    private String Port;
    private String ProxyAddress;
    private String ProxyPort;
    private String TimeOut;
    private String timeStamp;
    private final String[] HttpVer = new String[]{"HTTP/1.0", "HTTP/1.1"};
    private PrivateKey privateKey;
    private boolean containTimestamp = false;
    private String EncMsg;
    private String DecTxt;
    private byte[] DataBuf;
    private String CheckValue;
    private String EncPin;

    public SecureLink(PrivateKey key) {
        this.privateKey = key;
        this.timeStamp = "";
    }

    public boolean getContainsTimestamp() {
        return this.containTimestamp;
    }

    public void setContainTimestamp(boolean value) {
        this.containTimestamp = value;
    }

    private String currentTimeStamp() {
        Calendar now = Calendar.getInstance();
        int hour = now.get(11);
        int minute = now.get(12);
        int second = now.get(13);
        int month = now.get(2) + 1;
        int day = now.get(5);
        int year = now.get(1);
        StringBuffer buffer = new StringBuffer();
        buffer.append(year).append(this.leftFillZero(month, 2)).append(this.leftFillZero(day, 2)).append(this.leftFillZero(hour, 2)).append(this.leftFillZero(minute, 2)).append(this.leftFillZero(second, 2));
        return buffer.toString();
    }

    private String DecryptMessage(String input) {
        BigInteger result;
        try {
            BigInteger In = new BigInteger(input, 16);
            BigInteger Modulus = new BigInteger(1, this.privateKey.Modulus);
            BigInteger Exponent = new BigInteger("010001", 16);
            result = In.modPow(Exponent, Modulus);
        }
        catch (NumberFormatException _ex) {
            return "-1";
        }
        String rb = result.toString(16);
        while (rb.length() < 256) {
            rb = "0" + rb;
        }
        return rb;
    }

    private static void fillBlock(byte[] block, byte b) {
        SecureLink.fillBlock(block, 0, b, block.length);
    }

    private static void fillBlock(byte[] block, int blockOff, byte b, int len) {
        int i = blockOff;
        while (i < blockOff + len) {
            block[i] = b;
            ++i;
        }
    }

    private String leftPad(String str, int length, char c) {
        StringBuffer buffer = new StringBuffer("");
        if (str == null) {
            str = "";
        }
        if (length <= str.length()) {
            return str;
        }
        int strLen = length - str.length();
        int i = 0;
        while (i < strLen) {
            buffer.append(c);
            ++i;
        }
        buffer.append(str);
        return buffer.toString();
    }

    private String leftFillZero(int number, int length) {
        String str;
        StringBuffer buffer = new StringBuffer("");
        if (number >= 0) {
            str = "" + number;
        } else {
            buffer.append("-");
            str = "" + Math.abs(number);
            --length;
        }
        buffer.append(this.leftPad(str, length, '0'));
        return buffer.toString();
    }

    public String rightPad(String str, int len, char ch) {
        int p = len - str.length();
        String nstr = "";
        int i = 0;
        while (i < p) {
            nstr = String.valueOf(nstr) + ch;
            ++i;
        }
        nstr = String.valueOf(str) + nstr;
        return nstr;
    }

    public String genRandom(int len) {
        String result = "";
        Random ran = new Random();
        String sValue = String.valueOf(Math.abs(ran.nextLong()));
        result = sValue.length() >= len ? sValue.substring(0, len) : this.rightPad(sValue, len, '0');
        return result;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public String Sign(String MsgBody) {
        String plainData;
        if (this.containTimestamp) {
            this.timeStamp = this.currentTimeStamp();
            plainData = String.valueOf(this.timeStamp) + MsgBody;
        } else {
            this.timeStamp = "";
            plainData = MsgBody;
        }
        return String.valueOf(this.timeStamp) + this.Sign(plainData, plainData.length());
    }

    public String Sign(String MsgBody, int MsgLen) {
        byte[] data = new byte[500];
        ShaHash hash = new ShaHash();
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        SecureLink.fillBlock(data, (byte)0);
        byte[] tmp = MsgBody.getBytes();
        System.arraycopy(tmp, 0, data, 0, MsgLen);
        hash.add(data, 0, MsgLen);
        byte[] hb = hash.get();
        String rb = S.EncryptMessage(hb);
        return rb.toUpperCase();
    }

    public String genSign(String MerID, String OrderNO, String Amount, String CurrencyCode, String TransDate, String TransType) {
        ShaHash hash = new ShaHash();
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        int len = MerID.length();
        if (len > 15) {
            MerID = MerID.substring(0, 15);
        }
        if ((len = OrderNO.length()) > 16) {
            OrderNO = OrderNO.substring(0, 16);
        }
        if ((len = Amount.length()) > 12) {
            Amount = Amount.substring(0, 12);
        }
        if ((len = CurrencyCode.length()) > 3) {
            CurrencyCode = CurrencyCode.substring(0, 3);
        }
        if ((len = TransDate.length()) > 8) {
            TransDate = TransDate.substring(0, 8);
        }
        if ((len = TransType.length()) > 4) {
            TransType = TransType.substring(0, 4);
        }
        String MsgBody = "";
        MsgBody = String.valueOf(MsgBody) + MerID + OrderNO + Amount + CurrencyCode + TransDate + TransType;
        int MsgLen = MsgBody.length();
        return this.Sign(MsgBody, MsgLen);
    }

    public String signOrder(String MerID, String OrderNO, String Amount, String CurrencyCode, String TransDate, String TransType) {
        return this.genSign(MerID, OrderNO, Amount, CurrencyCode, TransDate, TransType);
    }

    public String inquery_func(String MerID, String OrderNO, String TransDate, String TransType, String FileName) {
        Socket ConnectedSocket;
        String Amount = "123456789012";
        String CurrencyCode = "156";
        boolean resultLen = false;
        int m_Pos = 0;
        if (MerID.length() > 15) {
            MerID = MerID.substring(0, 15);
        }
        if (OrderNO.length() > 16) {
            OrderNO = OrderNO.substring(0, 16);
        }
        if (TransDate.length() > 8) {
            TransDate = TransDate.substring(0, 8);
        }
        if (TransType.length() > 4) {
            TransType = TransType.substring(0, 4);
        }
        String CheckValue = this.genSign(MerID, OrderNO, Amount, CurrencyCode, TransDate, TransType);
        String Data = "MerID=" + MerID + "&";
        Data = String.valueOf(Data) + "OrderNO=" + OrderNO + "&";
        Data = String.valueOf(Data) + "TransDate=" + TransDate + "&";
        Data = String.valueOf(Data) + "TransType=" + TransType + "&";
        Data = String.valueOf(Data) + "CheckValue=" + CheckValue + "&";
        Data = String.valueOf(Data) + "Amount=" + Amount + "&";
        Data = String.valueOf(Data) + "CurrencyCode=" + CurrencyCode;
        try {
            ConnectedSocket = this.prepareConnect(FileName);
        }
        catch (Exception e) {
            return new String(e.getMessage());
        }
        if (ConnectedSocket == null) {
            return new String("SOCKET CREATE ERROR!");
        }
        String ReplyString = this.sendHttpCommand(ConnectedSocket, Data);
        if (ReplyString == null) {
            return new String("Error accured while Inquerying!");
        }
        this.releaseConnect(ConnectedSocket);
        m_Pos = ReplyString.indexOf("ChinaPayBack=");
        if (m_Pos < 0) {
            return new String("Error accured because of no field ChinaPayBack");
        }
        String result = ReplyString.substring(m_Pos + 13, m_Pos + 17);
        return result;
    }

    public static boolean memcmp(byte[] out, byte[] in, int len) {
        int i = 0;
        while (i < len) {
            if (out[i] != in[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Socket prepareConnect(String FileName) throws Exception {
        Socket HttpSocket;
        String m_ProxyPortInfo;
        String m_ProxyIpInfo;
        String m_ChinaPayPortInfo;
        String m_ChinaPayIpInfo;
        FileInputStream fis;
        int m_Pos = 0;
        String m_TimeOutInfo = null;
        try {
            fis = new FileInputStream(FileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String m_title = br.readLine();
            m_ChinaPayIpInfo = br.readLine();
            m_ChinaPayPortInfo = br.readLine();
            if (m_title.indexOf("[NetPayClientWithProxy]") >= 0) {
                m_ProxyIpInfo = br.readLine();
                m_ProxyPortInfo = br.readLine();
            } else {
                m_ProxyIpInfo = m_ChinaPayIpInfo;
                m_ProxyPortInfo = m_ChinaPayPortInfo;
            }
            br.close();
        }
        catch (IOException _ex) {
            System.out.println("Oper file error !");
            throw new Exception("open file error!");
        }
        fis = null;
        m_Pos = m_ChinaPayIpInfo.indexOf("=");
        this.IpAddress = m_ChinaPayIpInfo.substring(m_Pos + 1, m_ChinaPayIpInfo.length());
        m_Pos = m_ChinaPayPortInfo.indexOf("=");
        this.Port = m_ChinaPayPortInfo.substring(m_Pos + 1, m_ChinaPayPortInfo.length());
        m_Pos = m_ProxyIpInfo.indexOf("=");
        this.ProxyAddress = m_ProxyIpInfo.substring(m_Pos + 1, m_ProxyIpInfo.length());
        m_Pos = m_ProxyPortInfo.indexOf("=");
        this.ProxyPort = m_ProxyPortInfo.substring(m_Pos + 1, m_ProxyPortInfo.length());
        System.out.println("IpAddress = [" + this.IpAddress + "]");
        System.out.println("Port = [" + this.Port + "]");
        System.out.println("ProxyAddress = [" + this.ProxyAddress + "]");
        System.out.println("ProxyPort = [" + this.ProxyPort + "]");
        if (m_TimeOutInfo == null) {
            this.TimeOut = "3";
        } else {
            m_Pos = m_TimeOutInfo.indexOf("=");
            this.TimeOut = m_TimeOutInfo.substring(m_Pos + 1, m_TimeOutInfo.length());
        }
        try {
            InetAddress HostAddress = InetAddress.getByName(this.ProxyAddress);
            HttpSocket = new Socket(HostAddress, Integer.parseInt(this.ProxyPort));
        }
        catch (IOException _ex) {
            System.out.println("InetAddress.getByName or Socket error !");
            return null;
        }
        try {
            HttpSocket.setSoTimeout(Integer.parseInt(this.TimeOut) * 1000);
        }
        catch (Exception _ex) {
            System.out.println("setSoTimeout error !");
            try {
                HttpSocket.close();
            }
            catch (IOException _ex2) {
                System.out.println("Socket close error !");
                return null;
            }
            return null;
        }
        return HttpSocket;
    }

    private void releaseConnect(Socket HttpSocket) {
        try {
            if (HttpSocket != null) {
                HttpSocket.close();
            }
        }
        catch (IOException _ex) {
            return;
        }
    }

    private String sendHttpCommand(Socket HttpSocket, String Data) {
        OutputStream socketOut;
        InputStream socketIn;
        byte[] InBuffer = new byte[1024];
        int nSize = 0;
        String HttpCommand = "POST http://" + this.IpAddress + ":" + this.Port + "/chk/ProcGet" + " " + this.HttpVer[0];
        HttpCommand = String.valueOf(HttpCommand) + "\r\nContent-Type: application/x-www-form-urlencoded";
        HttpCommand = String.valueOf(HttpCommand) + "\r\nUser-Agent: cert";
        HttpCommand = String.valueOf(HttpCommand) + "\r\nHost: " + this.IpAddress;
        HttpCommand = String.valueOf(HttpCommand) + "\r\nContent-Length: " + Integer.toString(Data.length());
        HttpCommand = String.valueOf(HttpCommand) + "\r\nPragma: No-Cache\r\n\r\n" + Data + "\r\n";
        try {
            socketIn = HttpSocket.getInputStream();
            socketOut = HttpSocket.getOutputStream();
        }
        catch (IOException _ex) {
            return null;
        }
        try {
            try {
                socketOut.write(HttpCommand.getBytes());
                socketOut.flush();
                nSize = socketIn.read(InBuffer);
            }
            catch (IOException _ex) {
                String s;
                String string = s = null;
                try {
                    socketIn.close();
                    socketOut.close();
                }
                catch (IOException _ex2) {
                    return null;
                }
                return string;
            }
        }
        finally {
            try {
                socketIn.close();
                socketOut.close();
            }
            catch (IOException _ex) {
                return null;
            }
        }
        return new String(InBuffer);
    }

    private static String toStringBlock(byte[] block) {
        return SecureLink.toStringBlock(block, 0, block.length);
    }

    private static String toStringBlock(byte[] block, int off, int len) {
        String hexits = "0123456789abcdef";
        StringBuffer buf = new StringBuffer();
        int i = off;
        while (i < off + len) {
            buf.append(hexits.charAt(block[i] >>> 4 & 0xF));
            buf.append(hexits.charAt(block[i] & 0xF));
            ++i;
        }
        return String.valueOf(String.valueOf(buf));
    }

    public boolean verifyAuthToken(String MerID, String OrderNO, String Amount, String CurrencyCode, String TransDate, String TransType, String TransCode, String CheckValue) {
        byte[] data = new byte[100];
        ShaHash hash = new ShaHash();
        int len = 0;
        SecureLink.fillBlock(data, (byte)0);
        byte[] tmp = MerID.getBytes();
        len = MerID.length();
        if (len > 15) {
            len = 15;
        }
        System.arraycopy(tmp, 0, data, 0, len);
        tmp = OrderNO.getBytes();
        len = OrderNO.length();
        if (len > 16) {
            len = 16;
        }
        System.arraycopy(tmp, 0, data, 15, len);
        tmp = Amount.getBytes();
        len = Amount.length();
        if (len > 12) {
            len = 12;
        }
        System.arraycopy(tmp, 0, data, 31, len);
        tmp = CurrencyCode.getBytes();
        len = CurrencyCode.length();
        if (len > 3) {
            len = 3;
        }
        System.arraycopy(tmp, 0, data, 43, len);
        tmp = TransDate.getBytes();
        len = TransDate.length();
        if (len > 8) {
            len = 8;
        }
        System.arraycopy(tmp, 0, data, 46, len);
        tmp = TransType.getBytes();
        len = TransType.length();
        if (len > 4) {
            len = 4;
        }
        System.arraycopy(tmp, 0, data, 54, len);
        if (TransCode != null) {
            tmp = TransCode.getBytes();
            len = TransCode.length();
            if (len > 4) {
                len = 4;
            }
            System.arraycopy(tmp, 0, data, 58, len);
        }
        hash.add(data, 0, 62);
        byte[] hb = hash.get();
        String rb = this.DecryptMessage(CheckValue);
        String sb = SecureLink.toStringBlock(hb);
        return sb.equalsIgnoreCase(rb);
    }

    public boolean verifyAuthToken(String PlainData, String CheckValue) {
        byte[] data = PlainData.getBytes();
        ShaHash hash = new ShaHash();
        hash.add(data, 0, data.length);
        byte[] hb = hash.get();
        String rb = this.DecryptMessage(CheckValue);
        String sb = SecureLink.toStringBlock(hb);
        return sb.equalsIgnoreCase(rb);
    }

    public boolean verifyTransResponse(String MerID, String OrderNO, String Amount, String CurrencyCode, String TransDate, String TransType, String TransCode, String CheckValue) {
        return this.verifyAuthToken(MerID, OrderNO, Amount, CurrencyCode, TransDate, TransType, TransCode, CheckValue);
    }

    public String inqueryOrderByOrderNO(String MerID, String OrderNum, String OrderList, String ConfigFileName) {
        Socket ConnectedSocket;
        String ProcType = "0011";
        if (MerID.length() > 15) {
            MerID = MerID.substring(0, 15);
        }
        if (OrderNum.length() > 4) {
            OrderNum = OrderNum.substring(0, 4);
        }
        int tmpnum = Integer.parseInt(OrderNum);
        int num = tmpnum * 40;
        if (OrderList.length() < num) {
            return new String("The length of OrderList is error");
        }
        if (OrderList.length() > num) {
            OrderList = OrderList.substring(0, num);
        }
        String rand_num = this.genRandom(16);
        String MsgBody = String.valueOf(MerID) + rand_num;
        String CheckValue = this.Sign(MsgBody, 31);
        String ReqData = "ProcType=" + ProcType + "&";
        ReqData = String.valueOf(ReqData) + "Random=" + rand_num + "&";
        ReqData = String.valueOf(ReqData) + "MerID=" + MerID + "&";
        ReqData = String.valueOf(ReqData) + "OrderNum=" + OrderNum + "&";
        ReqData = String.valueOf(ReqData) + "OrderList=" + OrderList + "&";
        ReqData = String.valueOf(ReqData) + "CheckValue=" + CheckValue;
        try {
            ConnectedSocket = this.prepareConnect(ConfigFileName);
        }
        catch (Exception e) {
            return new String(e.getMessage());
        }
        if (ConnectedSocket == null) {
            return new String("SOCKET CREATE ERROR!");
        }
        String ReplyString = this.sendHttpCommand(ConnectedSocket, ReqData);
        if (ReplyString == null) {
            return new String("Error accured while sendHttpCommand!");
        }
        int m_Pos = ReplyString.indexOf("ChinaPayBack=");
        if (m_Pos < 0) {
            return new String("Error accured because of no field ChinaPayBack");
        }
        ReplyString = ReplyString.trim();
        int len = ReplyString.length();
        String result = ReplyString.substring(m_Pos + 13, len);
        return result;
    }

    public String inqueryOrderByOrderTime(String MerID, String BeginTime, String EndTime, String TransType, String ConfigFileName) {
        Socket ConnectedSocket;
        String ProcType = "0012";
        if (MerID.length() > 15) {
            MerID = MerID.substring(0, 15);
        }
        if (BeginTime.length() > 14) {
            BeginTime = BeginTime.substring(0, 14);
        }
        if (EndTime.length() > 14) {
            EndTime = EndTime.substring(0, 14);
        }
        if (TransType.length() > 4) {
            TransType = TransType.substring(0, 4);
        }
        String rand_num = this.genRandom(16);
        String MsgBody = String.valueOf(MerID) + rand_num;
        String CheckValue = this.Sign(MsgBody, 31);
        String ReqData = "ProcType=" + ProcType + "&";
        ReqData = String.valueOf(ReqData) + "Random=" + rand_num + "&";
        ReqData = String.valueOf(ReqData) + "MerID=" + MerID + "&";
        ReqData = String.valueOf(ReqData) + "BeginTime=" + BeginTime + "&";
        ReqData = String.valueOf(ReqData) + "EndTime=" + EndTime + "&";
        ReqData = String.valueOf(ReqData) + "TransType=" + TransType + "&";
        ReqData = String.valueOf(ReqData) + "CheckValue=" + CheckValue;
        try {
            ConnectedSocket = this.prepareConnect(ConfigFileName);
        }
        catch (Exception e) {
            return new String(e.getMessage());
        }
        if (ConnectedSocket == null) {
            return new String("SOCKET CREATE ERROR!");
        }
        String ReplyString = this.sendHttpCommand(ConnectedSocket, ReqData);
        if (ReplyString == null) {
            return new String("Error accured while sendHttpCommand!");
        }
        int m_Pos = ReplyString.indexOf("ChinaPayBack=");
        if (m_Pos < 0) {
            return new String("Error accured because of no field ChinaPayBack");
        }
        ReplyString = ReplyString.trim();
        int len = ReplyString.length();
        String result = ReplyString.substring(m_Pos + 13, len);
        return result;
    }

    public String batchCheckSum(String MerID, String OrderNum, String TransAmtSum, String TransDate, String TransType, String OrderStatus, String ConfigFileName) {
        Socket ConnectedSocket;
        String ProcType = "0020";
        if (MerID.length() > 15) {
            MerID = MerID.substring(0, 15);
        }
        if (OrderNum.length() > 4) {
            OrderNum = OrderNum.substring(0, 4);
        }
        if (TransAmtSum.length() > 12) {
            TransAmtSum = TransAmtSum.substring(0, 12);
        }
        if (TransDate.length() > 8) {
            TransDate = TransDate.substring(0, 8);
        }
        if (TransType.length() > 4) {
            TransType = TransType.substring(0, 4);
        }
        if (OrderStatus.length() > 4) {
            OrderStatus = OrderStatus.substring(0, 4);
        }
        String rand_num = this.genRandom(16);
        String MsgBody = String.valueOf(MerID) + rand_num;
        String CheckValue = this.Sign(MsgBody, 31);
        String ReqData = "ProcType=" + ProcType + "&";
        ReqData = String.valueOf(ReqData) + "Random=" + rand_num + "&";
        ReqData = String.valueOf(ReqData) + "MerID=" + MerID + "&";
        ReqData = String.valueOf(ReqData) + "OrderNum=" + OrderNum + "&";
        ReqData = String.valueOf(ReqData) + "TransAmtSum=" + TransAmtSum + "&";
        ReqData = String.valueOf(ReqData) + "TransDate=" + TransDate + "&";
        ReqData = String.valueOf(ReqData) + "TransType=" + TransType + "&";
        ReqData = String.valueOf(ReqData) + "OrderStatus=" + OrderStatus + "&";
        ReqData = String.valueOf(ReqData) + "CheckValue=" + CheckValue;
        try {
            ConnectedSocket = this.prepareConnect(ConfigFileName);
        }
        catch (Exception e) {
            return new String(e.getMessage());
        }
        if (ConnectedSocket == null) {
            return new String("SOCKET CREATE ERROR!");
        }
        String ReplyString = this.sendHttpCommand(ConnectedSocket, ReqData);
        if (ReplyString == null) {
            return new String("Error accured while sendHttpCommand!");
        }
        int m_Pos = ReplyString.indexOf("ChinaPayBack=");
        if (m_Pos < 0) {
            return new String("Error accured because of no field ChinaPayBack");
        }
        ReplyString = ReplyString.trim();
        int len = ReplyString.length();
        String result = ReplyString.substring(m_Pos + 13, len);
        return result;
    }

    public String batchCheckOrder(String MerID, String OrderNum, String OrderTable, String TransDate, String ConfigFileName) {
        Socket ConnectedSocket;
        String ProcType = "0030";
        if (MerID.length() > 15) {
            MerID = MerID.substring(0, 15);
        }
        if (OrderNum.length() > 4) {
            OrderNum = OrderNum.substring(0, 4);
        }
        int tmpnum = Integer.parseInt(OrderNum);
        int num = tmpnum * 36;
        if (OrderTable.length() < num) {
            return new String("The length of OrderTable is error");
        }
        if (OrderTable.length() > num) {
            OrderTable = OrderTable.substring(0, num);
        }
        String rand_num = this.genRandom(16);
        String MsgBody = String.valueOf(MerID) + rand_num;
        String CheckValue = this.Sign(MsgBody, 31);
        String ReqData = "ProcType=" + ProcType + "&";
        ReqData = String.valueOf(ReqData) + "Random=" + rand_num + "&";
        ReqData = String.valueOf(ReqData) + "MerID=" + MerID + "&";
        ReqData = String.valueOf(ReqData) + "OrderNum=" + OrderNum + "&";
        ReqData = String.valueOf(ReqData) + "OrderTable=" + OrderTable + "&";
        ReqData = String.valueOf(ReqData) + "TransDate=" + TransDate + "&";
        ReqData = String.valueOf(ReqData) + "CheckValue=" + CheckValue;
        try {
            ConnectedSocket = this.prepareConnect(ConfigFileName);
        }
        catch (Exception e) {
            return new String(e.getMessage());
        }
        if (ConnectedSocket == null) {
            return new String("SOCKET CREATE ERROR!");
        }
        String ReplyString = this.sendHttpCommand(ConnectedSocket, ReqData);
        if (ReplyString == null) {
            return new String("Error accured while sendHttpCommand!");
        }
        int m_Pos = ReplyString.indexOf("ChinaPayBack=");
        if (m_Pos < 0) {
            return new String("Error accured because of no field ChinaPayBack");
        }
        ReplyString = ReplyString.trim();
        int len = ReplyString.length();
        String result = ReplyString.substring(m_Pos + 13, len);
        return result;
    }

    public boolean uploadPendingOrder(String MerID, String OrderNo, String TransAmt, String TransDate, String TransType, String OrderStatus, String ErrorMsg, String ConfigFileName) {
        Socket ConnectedSocket;
        String ProcType = "0040";
        if (MerID.length() > 15) {
            MerID = MerID.substring(0, 15);
        }
        if (OrderNo.length() > 16) {
            OrderNo = OrderNo.substring(0, 16);
        }
        if (TransAmt.length() > 12) {
            TransAmt = TransAmt.substring(0, 12);
        }
        if (TransDate.length() > 8) {
            TransDate = TransDate.substring(0, 8);
        }
        if (TransType.length() > 4) {
            TransType = TransType.substring(0, 4);
        }
        if (OrderStatus.length() > 4) {
            OrderStatus = OrderStatus.substring(0, 4);
        }
        if (ErrorMsg.length() > 60) {
            ErrorMsg = ErrorMsg.substring(0, 60);
        }
        String rand_num = this.genRandom(16);
        String MsgBody = String.valueOf(MerID) + rand_num;
        String CheckValue = this.Sign(MsgBody, 31);
        String ReqData = "ProcType=" + ProcType + "&";
        ReqData = String.valueOf(ReqData) + "Random=" + rand_num + "&";
        ReqData = String.valueOf(ReqData) + "MerID=" + MerID + "&";
        ReqData = String.valueOf(ReqData) + "OrderNo=" + OrderNo + "&";
        ReqData = String.valueOf(ReqData) + "TransAmt=" + TransAmt + "&";
        ReqData = String.valueOf(ReqData) + "TransDate=" + TransDate + "&";
        ReqData = String.valueOf(ReqData) + "TransType=" + TransType + "&";
        ReqData = String.valueOf(ReqData) + "OrderStatus=" + OrderStatus + "&";
        ReqData = String.valueOf(ReqData) + "ErrorMsg=" + ErrorMsg + "&";
        ReqData = String.valueOf(ReqData) + "CheckValue=" + CheckValue;
        try {
            ConnectedSocket = this.prepareConnect(ConfigFileName);
        }
        catch (Exception e) {
            System.err.println("prepareConnect error");
            return false;
        }
        if (ConnectedSocket == null) {
            System.err.println("Socket create error ");
            return false;
        }
        String ReplyString = this.sendHttpCommand(ConnectedSocket, ReqData);
        if (ReplyString == null) {
            System.err.println("Error accured while sendHttpCommand");
            return false;
        }
        int m_Pos = ReplyString.indexOf("ChinaPayBack=");
        if (m_Pos < 0) {
            System.err.println("Error accured because of no field ChinaPayBack");
            return false;
        }
        String result = (ReplyString = ReplyString.trim()).substring(m_Pos + 13, m_Pos + 17);
        return result.equals("0000");
    }

    public static byte[] md5Digest(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input);
            byte[] toChapter1Digest = md.digest();
            return toChapter1Digest;
        }
        catch (Exception e) {
            return "error".getBytes();
        }
    }

    public static byte[] md5digestAdd128(byte[] input) {
        int hashSize = input.length;
        byte[] hb = new byte[128];
        byte[] byArray = new byte[128];
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[48] = -1;
        byArray[49] = -1;
        byArray[50] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[53] = -1;
        byArray[54] = -1;
        byArray[55] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[65] = -1;
        byArray[66] = -1;
        byArray[67] = -1;
        byArray[68] = -1;
        byArray[69] = -1;
        byArray[70] = -1;
        byArray[71] = -1;
        byArray[72] = -1;
        byArray[73] = -1;
        byArray[74] = -1;
        byArray[75] = -1;
        byArray[76] = -1;
        byArray[77] = -1;
        byArray[78] = -1;
        byArray[79] = -1;
        byArray[80] = -1;
        byArray[81] = -1;
        byArray[82] = -1;
        byArray[83] = -1;
        byArray[84] = -1;
        byArray[85] = -1;
        byArray[86] = -1;
        byArray[87] = -1;
        byArray[88] = -1;
        byArray[89] = -1;
        byArray[90] = -1;
        byArray[91] = -1;
        byArray[93] = 48;
        byArray[94] = 33;
        byArray[95] = 48;
        byArray[96] = 9;
        byArray[97] = 6;
        byArray[98] = 5;
        byArray[99] = 43;
        byArray[100] = 14;
        byArray[101] = 3;
        byArray[102] = 2;
        byArray[103] = 26;
        byArray[104] = 5;
        byArray[106] = 4;
        byArray[107] = 20;
        byte[] HashpadString = byArray;
        System.arraycopy(HashpadString, 0, hb, 0, 112);
        System.arraycopy(input, 0, hb, 112, 16);
        return hb;
    }

    byte[] OAEP_Two(byte[] DES_Key1, byte[] DES_Key2, byte[] IV) {
        byte[] tmpStr = "ffFIEFlw81f03frL8f2lfsg".getBytes();
        Random rd = new Random();
        byte[] R = new byte[128];
        rd.nextBytes(R);
        R[0] = 1;
        R[1] = 0;
        System.arraycopy(tmpStr, 0, R, 10, tmpStr.length);
        R[103] = 0;
        System.arraycopy(DES_Key1, 0, R, 104, 8);
        System.arraycopy(DES_Key2, 0, R, 112, 8);
        System.arraycopy(IV, 0, R, 120, 8);
        return R;
    }

    String addLenString(int len) {
        if (len > 9999) {
            return "-1";
        }
        String sOut = Integer.toString(len);
        int b = 4 - sOut.length();
        if (b != 0) {
            int i = 0;
            while (i < b) {
                sOut = "0" + sOut;
                ++i;
            }
        }
        return sOut;
    }

    int getLenString(String sIn) {
        if (sIn.length() != 4) {
            return -1;
        }
        int iOut = 0;
        try {
            Integer I = new Integer(sIn);
            iOut = I;
        }
        catch (Exception e) {
            return -2;
        }
        return iOut;
    }

    public int newEncData_J_Client(byte[] DataBuf) {
        byte[] deskey1 = new byte[8];
        byte[] deskey2 = new byte[8];
        byte[] IV = "FIEf124H".getBytes();
        Random rd = new Random();
        rd.nextBytes(deskey1);
        rd.nextBytes(deskey2);
        byte[] msgKey = this.OAEP_Two(deskey1, deskey2, IV);
        int DataBufLen = DataBuf.length;
        if (DataBufLen > 9999) {
            return -9999;
        }
        String sLen = this.addLenString(DataBufLen);
        if (sLen.compareTo("-1") == 0) {
            return -9998;
        }
        if (sLen.length() != 4) {
            return -9997;
        }
        DesRsa dr = new DesRsa();
        String tmp = DesRsa.Hex2Asc(msgKey.length, msgKey);
        byte[] trkey = new byte[16];
        System.arraycopy(deskey1, 0, trkey, 0, 8);
        System.arraycopy(deskey2, 0, trkey, 8, 8);
        tmp = new String(DataBuf);
        byte[] btrOut = dr.DES3b(trkey, DataBuf);
        String strOut = DesRsa.Hex2Asc(btrOut.length, btrOut);
        String shMsgKey = DesRsa.Hex2Asc(msgKey.length, msgKey);
        String sMsgKey = this.DecryptMessage(shMsgKey);
        sMsgKey = sMsgKey.toUpperCase();
        this.EncMsg = String.valueOf(sMsgKey) + sLen + strOut;
        return 0;
    }

    public int newEncData_J_Client(byte[] DataBuf, int encoding) {
        String content;
        String ecd = null;
        switch (encoding) {
            case 0: {
                ecd = "US-ASCII";
                break;
            }
            case 1: {
                ecd = "UTF-16LE";
                break;
            }
            case 2: {
                ecd = "UTF-16BE";
                break;
            }
            case 3: {
                ecd = "UTF-8";
                break;
            }
            default: {
                return -1102;
            }
        }
        try {
            content = new String(DataBuf, ecd);
        }
        catch (UnsupportedEncodingException e) {
            return -1101;
        }
        DataBuf = content.getBytes();
        byte[] deskey1 = new byte[8];
        byte[] deskey2 = new byte[8];
        byte[] IV = "FIEf124H".getBytes();
        Random rd = new Random();
        rd.nextBytes(deskey1);
        rd.nextBytes(deskey2);
        byte[] msgKey = this.OAEP_Two(deskey1, deskey2, IV);
        int DataBufLen = DataBuf.length;
        if (DataBufLen > 9999) {
            return -9999;
        }
        String sLen = this.addLenString(DataBufLen);
        if (sLen.compareTo("-1") == 0) {
            return -9998;
        }
        if (sLen.length() != 4) {
            return -9997;
        }
        DesRsa dr = new DesRsa();
        String tmp = DesRsa.Hex2Asc(msgKey.length, msgKey);
        byte[] trkey = new byte[16];
        System.arraycopy(deskey1, 0, trkey, 0, 8);
        System.arraycopy(deskey2, 0, trkey, 8, 8);
        tmp = new String(DataBuf);
        byte[] btrOut = dr.DES3b(trkey, DataBuf);
        String strOut = DesRsa.Hex2Asc(btrOut.length, btrOut);
        String shMsgKey = DesRsa.Hex2Asc(msgKey.length, msgKey);
        String sMsgKey = this.DecryptMessage(shMsgKey);
        sMsgKey = sMsgKey.toUpperCase();
        this.EncMsg = String.valueOf(sMsgKey) + sLen + strOut;
        return 0;
    }

    public String getEncMsg() {
        return this.EncMsg;
    }

    int checkOAEP(byte[] R, byte[] trKey) {
        if (R[0] != 1) {
            return -2000;
        }
        if (R[1] != 0) {
            return 2001;
        }
        byte[] tmpStr = "ffFIEFlw81f03frL8f2lfsg".getBytes();
        int tlen = tmpStr.length;
        byte[] gettmpStr = new byte[tlen];
        System.arraycopy(R, 10, gettmpStr, 0, tlen);
        if (!Arrays.equals(tmpStr, gettmpStr)) {
            return -1009;
        }
        byte[] IV = "FIEf124H".getBytes();
        tlen = IV.length;
        byte[] getIV = new byte[tlen];
        System.arraycopy(R, 120, getIV, 0, tlen);
        if (!Arrays.equals(IV, getIV)) {
            return -1008;
        }
        if (trKey.length != 16) {
            return -2;
        }
        System.arraycopy(R, 104, trKey, 0, 16);
        return 0;
    }

    int getMsgKey(String CipherTxt, byte[] ClearTxt) {
        if (CipherTxt.length() != 256) {
            return -2;
        }
        if (ClearTxt.length != 128) {
            return -3;
        }
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        byte[] cpt = DesRsa.Asc2Hex(CipherTxt.length(), CipherTxt);
        String rb = S.EncryptMessage(cpt);
        byte[] br = DesRsa.Asc2Hex(rb.length(), rb);
        String s = DesRsa.Hex2Asc(br.length, br);
        if (rb.compareTo("-1") == 0) {
            return -1;
        }
        System.arraycopy(br, 0, ClearTxt, 0, ClearTxt.length);
        return 0;
    }

    public int newDecData_J_Client(String EncMsg) {
        String msgKeyCipher = EncMsg.substring(0, 256);
        String sLen = EncMsg.substring(256, 260);
        String desResult = EncMsg.substring(260);
        int DataLen = this.getLenString(sLen);
        if (DataLen <= 0) {
            return -8999;
        }
        byte[] deskey = new byte[128];
        int rs = this.getMsgKey(msgKeyCipher, deskey);
        if (rs != 0) {
            return rs;
        }
        String s = DesRsa.Hex2Asc(deskey.length, deskey);
        byte[] trkey = new byte[16];
        rs = this.checkOAEP(deskey, trkey);
        if (rs != 0) {
            return rs;
        }
        DesRsa dr = new DesRsa();
        byte[] bDec = dr._DES3bs(trkey, desResult.getBytes());
        int blen = bDec.length;
        this.DataBuf = new byte[DataLen];
        System.arraycopy(bDec, 0, this.DataBuf, 0, DataLen);
        return 0;
    }

    public byte[] getDecMsg() {
        return this.DataBuf;
    }

    public String getDataBuf() {
        try {
            this.DecTxt = new String(this.DataBuf);
        }
        catch (Exception e) {
            return "-1";
        }
        return this.DecTxt;
    }

    public int newSignData_J_Client(int CompressType, byte[] DataBuf) {
        int MsgLen = DataBuf.length;
        byte[] data = new byte[MsgLen];
        byte[] hb = new byte[128];
        byte[] md5out = new byte[16];
        if (MsgLen > 10240) {
            return -2;
        }
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(DataBuf, 0, data, 0, MsgLen);
        if (CompressType == 0) {
            ShaHash hash = new ShaHash();
            hash.add(data, 0, MsgLen);
            hb = hash.get();
        } else if (CompressType == 1) {
            md5out = SecureLink.md5Digest(DataBuf);
            hb = SecureLink.md5digestAdd128(md5out);
        } else {
            return -3;
        }
        String rb = S.EncryptMessage(hb);
        this.CheckValue = rb.toUpperCase();
        return 0;
    }

    public int newSignData_J_Client(int CompressType, byte[] DataBuf, int encoding) {
        String content;
        String ecd = null;
        switch (encoding) {
            case 0: {
                ecd = "US-ASCII";
                break;
            }
            case 1: {
                ecd = "UTF-16LE";
                break;
            }
            case 2: {
                ecd = "UTF-16BE";
                break;
            }
            case 3: {
                ecd = "UTF-8";
                break;
            }
            default: {
                return -1102;
            }
        }
        try {
            content = new String(DataBuf, ecd);
        }
        catch (UnsupportedEncodingException e) {
            return -1101;
        }
        DataBuf = content.getBytes();
        int MsgLen = DataBuf.length;
        byte[] data = new byte[MsgLen];
        byte[] hb = new byte[128];
        byte[] md5out = new byte[16];
        if (MsgLen > 10240) {
            return -2;
        }
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(DataBuf, 0, data, 0, MsgLen);
        if (CompressType == 0) {
            ShaHash hash = new ShaHash();
            hash.add(data, 0, MsgLen);
            hb = hash.get();
        } else if (CompressType == 1) {
            md5out = SecureLink.md5Digest(DataBuf);
            hb = SecureLink.md5digestAdd128(md5out);
        } else {
            return -3;
        }
        String rb = S.EncryptMessage(hb);
        this.CheckValue = rb.toUpperCase();
        return 0;
    }

    public String getCheckValue() {
        return this.CheckValue;
    }

    public int newVeriSignData_J_Client(int CompressType, byte[] DataBuf, String ChkValue) {
        byte[] hb;
        byte[] data = new byte[10240];
        int MsgLen = DataBuf.length;
        if (MsgLen > 10240) {
            return -2;
        }
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(DataBuf, 0, data, 0, MsgLen);
        if (CompressType == 0) {
            ShaHash hash = new ShaHash();
            hash.add(data, 0, MsgLen);
            hb = hash.get();
        } else if (CompressType == 1) {
            hb = SecureLink.md5Digest(data);
            hb = SecureLink.md5digestAdd128(hb);
        } else {
            return -3;
        }
        String rb = this.DecryptMessage(ChkValue);
        String sb = SecureLink.toStringBlock(hb);
        if (sb.equalsIgnoreCase(rb)) {
            return 0;
        }
        return 1;
    }

    public int newEncPin_J_Client(String Pin, String MerId, String TransDate, String SeqId, String CardId) {
        if (CardId.length() < 7) {
            return -1;
        }
        DesRsa drPin = new DesRsa();
        this.EncPin = DesRsa.SingleDesEnc(Pin, CardId.substring(CardId.length() - 8).getBytes());
        return 0;
    }

    public String getEncPin() {
        return this.EncPin;
    }
}

