/**
 * Created by Jacky.Gao on 2018-04-15.
 * Base on Webpack4
 */
const path=require('path');
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
module.exports={
    mode:'production',
    entry: {
        todo:'./src/todo/index.jsx',
        central:'./src/central/index.jsx',
        calendar:'./src/calendar/index.jsx',
        designer:'./src/designer/designer.js',
        diagram:'./src/ProcessDiagram.js'
    },
    output:{
        path:path.resolve('../uflo-console/src/main/resources/uflo-asserts/js'),
        filename:'[name].bundle.js'
    },
    plugins:[
        new UglifyJsPlugin(
            {
                uglifyOptions: {
                    warnings: false,
                    output: {
                        comments: false
                    },
                    compress: {
                        drop_console: true
                    }
                }
            }
        )
    ],
    module:{
        rules:[
            {
                test: /\.(jsx|js)?$/,
                exclude: /node_modules/,
                loader: "babel-loader",
                options:{
                    "presets": [
                        "react","env"
                    ]
                }
            },
            {
                test:/\.css$/,
                use: [{ loader: 'style-loader' }, { loader: 'css-loader' }]
            },
            {
                test: /\.(eot|woff|woff2|ttf|svg|png|jpg)$/,
                use: [
                    {
                        loader: 'url-loader',
                        options: {
                            limit: 10000000
                        }
                    }
                ]
            }
        ]
    }
};