package com.easy.cms.servlet;

import java.util.List;
import java.util.Map;

import javax.inject.Inject;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.easy.base.BaseServlet;
import com.easy.cms.obj.Node;
import com.easy.cms.service.CfgService;
import com.easy.cms.service.FieldService;
import com.easy.cms.service.CountService;
import com.easy.cms.service.DataService;
import com.easy.cms.service.SubjectService;
import com.easy.common.obj.Ajax;
import com.easy.util.EhcacheUtil;

@WebServlet("/cms/home")
public class HomeServlet extends BaseServlet {

	@Inject
	CfgService cfgService;
	@Inject
	SubjectService subjectService;
	@Inject
	FieldService fieldService;
	@Inject
	DataService dataService;
	@Inject
	CountService countService;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected void service(HttpServletRequest request, HttpServletResponse response) {
		String action = getDefaultString("action", "", request);
		try {
			switch (action) {
			case "numSubjectCode":
				numSubjectCode(request, response);
				break;
			case "numMonth":
				numMonth(request, response);
				break;
			case "clearCache":
				clearCache(request, response);
				break;
			default:
				index(request, response);
			}
		} catch (Exception e) {
			e.printStackTrace();
			this.write(new Ajax(false, "出现错误"+e.getMessage()), response);
		}
	}

	public void index(HttpServletRequest request, HttpServletResponse response) throws Exception {
		List<Node> list = subjectService.menu();
		//构造菜单
		request.setAttribute("menus", list);
		forward(prefix + "home/index.jsp", request, response);
	}

		
	private void numSubjectCode(HttpServletRequest request, HttpServletResponse response) throws Exception {
		Map<String, Object> map = countService.numSubjectCode();
		this.write(map, response);
	}
	private void numMonth(HttpServletRequest request, HttpServletResponse response) throws Exception {
		Map<String, Object> map = countService.numMonth();
		this.write(map, response);
	}
	private void clearCache(HttpServletRequest request, HttpServletResponse response) {
		EhcacheUtil.clearCache();
		this.write(new Ajax(true, "清除成功"), response);
	}
}
