package com.easy.cms.tag;

import java.io.IOException;
import java.util.List;

import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

import com.easy.cms.obj.Node;
import com.easy.cms.service.SubjectService;
import com.easy.core.Context;

public class MenuTag extends BodyTagSupport {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	@Inject
	SubjectService subjectService;
	public MenuTag() {
		Context.getInjector().injectMembers(this);
	}
	@Override
	public int doEndTag() throws JspException {
		try {
			ServletRequest request= pageContext.getRequest();
			String ctx = request.getServletContext().getContextPath();
			JspWriter out = pageContext.getOut();
			List<Node> list = subjectService.menu();
			StringBuffer html = new StringBuffer();
			for (Node node : list) {
				html.append("<li><a subjectId=\"").append(node.getId()).append("\" href=\"").append(ctx).append("/cms/content?action=toList&subjectId=").append(node.getId()).append("\"><i class=\"icon-briefcase\"></i>").append(node.getName()).append("\n");
				html.append("<span class=\"submenu-icon\"></span></a>").append("\n");
				recursive(node.getNodes(), html, ctx);
				html.append("</li>").append("\n");
			}
			out.println(html);
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return EVAL_PAGE;
	}
	//递归处理子菜单
	private void recursive(List<Node> nodes, StringBuffer html, String ctx) {
		if (!nodes.isEmpty()) {
			html.append("<ul>").append("\n");
			for (Node ns : nodes) {
				html.append("<li><a subjectId=\"").append(ns.getId()).append("\" href=\"").append(ctx).append("/cms/content?action=toList&subjectId=").append(ns.getId()).append("\">").append(ns.getName());
				if(!ns.getNodes().isEmpty()) {
					html.append("<span class=\"submenu-icon\"></span>").append("\n");
				}
				html.append("</a>").append("\n");
				//递归处理子菜单
				recursive(ns.getNodes(), html, ctx);
				html.append("</li>").append("\n");
			}
			html.append("</ul>").append("\n");
		}
	}
}
