package com.easy.files;

import java.io.File;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

import com.google.common.collect.Lists;

public class FileList {
	
	public static List<String> list(String path, String UPLOAD_DIRECTORY) {
		List<String> list = Lists.newArrayList();
		/*try {
			File directory = new File("D:/workspace/easycms/src/main/webapp/files");
			getFiles(directory);
		} catch (Exception e) {
			e.printStackTrace();
		}*/
		
		try {
			File directory = new File(path);
			IOFileFilter fileFilter = FileFilterUtils.and(EmptyFileFilter.NOT_EMPTY);

			List<File> found = (List<File>) FileUtils.listFiles(directory, fileFilter,
					DirectoryFileFilter.INSTANCE);
			for (File file : found) {
				String aPath = file.getAbsolutePath();
				String[] s = aPath.split(UPLOAD_DIRECTORY);
				String p = s[1].replaceAll("\\\\", "/");
				list.add(UPLOAD_DIRECTORY +p);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return list;
	}
	 public static void getFiles(File dir) {
	        //如果当前文件或目录存在
	        if(dir.exists()){
	            //如果是目录，则：
	            if(dir.isDirectory()){
	                //打印当前目录的路径
	                System.out.println(dir);
	                //获取该目录下的所有文件和目录组成的File数组
	                File[] files = dir.listFiles();
	                //递归遍历每一个子文件
	                for(File file : files){
	                    getFiles(file);
	                }
	            }
	            //如果是文件，则打印该文件路径及名称
	            else{
	                System.out.println(dir);
	            }
	        }
	    }
}
