/*
 * The contents of this file are subject to the GNU Lesser General Public
 * License Version 2.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.gnu.org/copyleft/lesser.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Developer:
 * Todd Ditchendorf, todd@ditchnet.org
 *
 */

/**
 *	@author Todd Ditchendorf
 *	@since 2005-03-12
 *	@version 0.8
 *
 *
 *
 *
 */
package org.ditchnet.xml;

/**
 *	<p>Some of the {@link org.ditchnet.jsp.util.JspResponseWriter} class' 
 *	public instance methods write markup (XML, specifically) to the response
 *	stream. The <code>Xml</code> interface, it's static inner interfaces
 *	<code>Tag</code> and <code>Attr</code> enforce type-safety and decrease the
 *	likelyhood of malformed XML (which is not truely XML anyway) being 
 *	generated by the JspResponseWriter class.</p>
 *	<p>For example the <code>JspResponseWriter</code>'s <code>startElement()</code>
 *	method accepts one parameter of type <code>Xml.Tag</code> instead of just a
 *	<code>String</code>. Again, this ensures type safety, but more importantly,
 *	allows a fixed set of markup elements to be sent to the response stream
 *	making XML well-formedness errors much less likely.</p>
 *	<p>This class is purely a utilitly class, and may not be instaciated 
 *	by client code (private constructor).</p>
 *	<p>Note that the {@link org.ditchnet.xml.Xml.Tag} class implements
 *	the Type-Safe Enum Pattern as described by Joshua Bloch in <em>Effective
 *	Java</em>.</p>
 *	<p>Subclasses of this class should represent a specific XML vocabulary
 *	or application. For example, the {@link org.ditchnet.xml.Xhtml}
 *	class represents the XHTML vocabulary.</p>
 *
 *
 *
 *	@author Todd Ditchendorf
 *	
 *
 */
public interface Xml {
	
	/**
	 *	<p>This class implements the Type-Safe Enum pattern as outlined by
	 *	Joshua Bloch in <em>Effective Java</em>. The only constructor is 
	 *	private, and therefore this class may not be instanciated by client
	 *	code.</p>
	 *	<p>Subclasses of this class will provide enumerations of valid
	 *	elements allowed in a particular XML vocabulary or application.</p>
	 *
	 *	@since 2005-03-12
	 *	@version 0.8
	 *	@author Todd Ditchendorf
	 *
	 */
	public static interface Tag { }
	
	/**
	 *	<p>Concrete implementations of this interface should impelement
	 *	the Type-Safe Enum pattern as outlined by Joshua Bloch in 
	 *	<em>Effective Java</em> and provide static member variables that
	 *	present the complete set of attribute names available in the
	 *	XML vocabulary in question.</p>
	 *
	 *	@since 2005-03-12
	 *	@version 0.8
	 *	@author Todd Ditchendorf
	 *
	 *
	 *
	 */
	public static interface Attr { }
	
}
