/*
 * restserver - A smart, efficient, low consumption RESTful application service platform writen in C
 * author	: calvin
 * email	: calvinwilliams@163.com
 *
 * Licensed under the Apache License v2.0, see the file LICENSE in base directory.
 */

#include "restserver_api.h"

funcRestServiceEntry GET_hello;
int GET_hello( struct RestServerContext *ctx )
{
	char		response[1024] ;
	int		response_len ;
	
	int		nret = 0 ;
	
	/* ʼʱ */
	memset( response , 0x00 , sizeof(response) );
	response_len = 0 ;
	
	/* helloϢ */
	response_len = snprintf( response , sizeof(response) , "Hello restserver\n" ) ;
	
	/* HTTP */
	nret = RSAPIFormatHttpResponse( ctx , response , response_len , NULL ) ;
	if( nret )
		return nret;
	
	return 0;
}

static struct RestServiceConfig		g_rest_services_config[] = {
		{ "GET" , "/hello" , GET_hello } ,
		{ "" , "" , NULL }
	} ;

funcInitRestApplication InitRestApplication;
int InitRestApplication( struct RestServerContext *ctx )
{
	struct RestServiceControler	*ctl = NULL ;
	
	/* RESTful */
	ctl = RSAPICreateRestServiceControler( g_rest_services_config ) ;
	if( ctl == NULL )
		return RESTSERVER_FATAL_CREATE_RESTSERVICECONTROLER;
	
	/* RESTfulrestserverƽ̨Ļ */
	RSAPISetUserData( ctx , ctl );
	
	return 0;
}

#include "LOGC.h"

funcCallRestApplication CallRestApplication;
int CallRestApplication( struct RestServerContext *ctx )
{
	struct RestServiceControler	*ctl = NULL ;
	
	int				nret = 0 ;
	
	/* restserverƽ̨ĻȡRESTful */
	ctl = RSAPIGetUserData( ctx ) ;
	if( ctl == NULL )
		return RESTSERVER_FATAL_GET_RESTSERVICECONTROLER;
	
	/* RESTfulɷ */
	nret = RSAPIDispatchRestServiceControler( ctl , ctx ) ;
	if( nret )
		return nret;
	
	return 0;
}

funcCleanRestApplication CleanRestApplication;
int CleanRestApplication( struct RestServerContext *ctx )
{
	struct RestServiceControler	*ctl = NULL ;
	
	/* restserverƽ̨ĻȡRESTful */
	ctl = RSAPIGetUserData( ctx ) ;
	
	/* RESTful */
	RSAPIDestroyRestServiceControler( ctl );
	
	return 0;
}

