/*
 * restserver - A smart, efficient, low consumption RESTful application service platform writen in C
 * author	: calvin
 * email	: calvinwilliams@163.com
 *
 * Licensed under the Apache License v2.0, see the file LICENSE in base directory.
 */

#include "restserver_api.h"

funcRestServiceEntry GET_hello;
int GET_hello( struct RestServerContext *ctx )
{
	char		response[4096] ;
	int		response_len ;
	
	char		*method = NULL ;
	int		method_len ;
	char		*uri = NULL ;
	int		uri_len ;
	
	int		uri_paths_count ;
	int		uri_path_index ;
	char		*uri_path = NULL ;
	int		uri_path_len ;
	
	int		queries_count ;
	int		query_index ;
	char		*key = NULL ;
	int		key_len ;
	char		*value = NULL ;
	int		value_len ;
	
	int		nret = 0 ;
	
	/* ʼʱ */
	memset( response , 0x00 , sizeof(response) );
	response_len = 0 ;
	
	/* ȡHTTP */
	method = RSAPIGetHttpMethodPtr( ctx , & method_len ) ;
	BUFPRINTF( response , response_len , "method[%.*s]\n" , method_len,method )
	
	/* ȡHTTP· */
	uri = RSAPIGetHttpUriPtr( ctx , & uri_len ) ;
	BUFPRINTF( response , response_len , "uri[%.*s]\n" , uri_len,uri )
	
	/* ȡѷֽ· */
	uri_paths_count = RSAPIGetHttpUriPathsCount( ctx ) ;
	BUFPRINTF( response , response_len , "uri_paths_count[%d]\n" , uri_paths_count ) ;
	for( uri_path_index = 1 ; uri_path_index <= uri_paths_count ; uri_path_index++ )
	{
		uri_path = RSAPIGetHttpUriPathPtr( ctx , uri_path_index , & uri_path_len ) ;
		BUFPRINTF( response , response_len , "uri_path[%.*s]\n" , uri_path_len,uri_path )
	}
	
	/* ȡѷֽĲ */
	queries_count = RSAPIGetHttpUriQueriesCount( ctx ) ;
	BUFPRINTF( response , response_len , "queries_count[%d]\n" , queries_count ) ;
	for( query_index = 1 ; query_index <= queries_count ; query_index++ )
	{
		key = RSAPIGetHttpUriQueryKeyPtr( ctx , query_index , & key_len ) ;
		value = RSAPIGetHttpUriQueryValuePtr( ctx , query_index , & value_len ) ;
		BUFPRINTF( response , response_len , "query[%d][%.*s][%.*s]\n" , query_index , key_len,key , value_len,value ) ;
	}
	
	/* HTTP */
	nret = RSAPIFormatHttpResponse( ctx , response , response_len , NULL ) ;
	if( nret )
		return nret;
	
	return 0;
}

/* RESTful  */
static struct RestServiceConfig		g_rest_services_config[] = {
		{ "GET" , "/rsapi" , GET_hello } ,
		{ "" , "" , NULL }
	} ;

funcInitRestApplication InitRestApplication;
int InitRestApplication( struct RestServerContext *ctx )
{
	struct RestServiceControler	*ctl = NULL ;
	
	/* RESTful */
	ctl = RSAPICreateRestServiceControler( g_rest_services_config ) ;
	if( ctl == NULL )
		return RESTSERVER_FATAL_CREATE_RESTSERVICECONTROLER;
	
	/* RESTfulrestserverƽ̨Ļ */
	RSAPISetUserData( ctx , ctl );
	
	return 0;
}

funcCallRestApplication CallRestApplication;
int CallRestApplication( struct RestServerContext *ctx )
{
	struct RestServiceControler	*ctl = NULL ;
	
	int				nret = 0 ;
	
	/* restserverƽ̨ĻȡRESTful */
	ctl = RSAPIGetUserData( ctx ) ;
	if( ctl == NULL )
		return RESTSERVER_FATAL_GET_RESTSERVICECONTROLER;
	
	/* RESTfulɷ */
	nret = RSAPIDispatchRestServiceControler( ctl , ctx ) ;
	if( nret )
		return nret;
	
	return 0;
}

funcCleanRestApplication CleanRestApplication;
int CleanRestApplication( struct RestServerContext *ctx )
{
	struct RestServiceControler	*ctl = NULL ;
	
	/* restserverƽ̨ĻȡRESTful */
	ctl = RSAPIGetUserData( ctx ) ;
	
	/* RESTful */
	RSAPIDestroyRestServiceControler( ctl );
	
	return 0;
}

