/**
 * Generated by build-library.php, Please DO NOT modify!
 */

static const char* swoole_library_source_constants =
    "\n"
    "define('SWOOLE_LIBRARY', true);\n";

static const char* swoole_library_source_std_array =
    "\n"
    "function swoole_array_walk(array &$array, callable $callback, ...$userdata): bool\n"
    "{\n"
    "    if (($argc = func_num_args()) > 3) {\n"
    "        throw new TypeError(\"array_walk() expects at most 3 parameters, {$argc} given\");\n"
    "    }\n"
    "    foreach ($array as $key => &$item) {\n"
    "        $callback($item, $key, ...$userdata);\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_array_walk_recursive(array &$array, callable $callback, ...$userdata): bool\n"
    "{\n"
    "    if (($argc = func_num_args()) > 3) {\n"
    "        throw new TypeError(\"array_walk_recursive() expects at most 3 parameters, {$argc} given\");\n"
    "    }\n"
    "    foreach ($array as $key => &$item) {\n"
    "        if (is_array($item)) {\n"
    "            swoole_array_walk_recursive($item, $callback, ...$userdata);\n"
    "        } else {\n"
    "            $callback($item, $key, ...$userdata);\n"
    "        }\n"
    "    }\n"
    "    return true;\n"
    "}\n";

static const char* swoole_library_source_std_exec =
    "\n"
    "function swoole_exec(string $command, &$output = null, &$returnVar = null)\n"
    "{\n"
    "    $result = Swoole\\Coroutine::exec($command);\n"
    "    if ($result) {\n"
    "        $outputList = explode(PHP_EOL, $result['output']);\n"
    "        if ($output) {\n"
    "            $output = array_merge($output, $outputList);\n"
    "        } else {\n"
    "            $output = $outputList;\n"
    "        }\n"
    "        $returnVar = $result['code'];\n"
    "        return end($outputList);\n"
    "    } else {\n"
    "        return false;\n"
    "    }\n"
    "}\n"
    "\n"
    "function swoole_shell_exec(string $cmd)\n"
    "{\n"
    "    $result = Swoole\\Coroutine::exec($cmd);\n"
    "    if ($result && '' !== $result['output']) {\n"
    "        return $result['output'];\n"
    "    }\n"
    "    return null;\n"
    "}\n";

static const char* swoole_library_source_core_curl_exception =
    "\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "use Swoole;\n"
    "\n"
    "class Exception extends Swoole\\Exception\n"
    "{\n"
    "\n"
    "}\n";

static const char* swoole_library_source_core_http_status_code =
    "\n"
    "\n"
    "namespace Swoole\\Http;\n"
    "\n"
    "abstract class StatusCode\n"
    "{\n"
    "    const CONTINUE = 100;\n"
    "    const SWITCHING_PROTOCOLS = 101;\n"
    "    const PROCESSING = 102;\n"
    "    const OK = 200;\n"
    "    const CREATED = 201;\n"
    "    const ACCEPTED = 202;\n"
    "    const NON_AUTHORITATIVE_INFORMATION = 203;\n"
    "    const NO_CONTENT = 204;\n"
    "    const RESET_CONTENT = 205;\n"
    "    const PARTIAL_CONTENT = 206;\n"
    "    const MULTI_STATUS = 207;\n"
    "    const ALREADY_REPORTED = 208;\n"
    "    const IM_USED = 226;\n"
    "    const MULTIPLE_CHOICES = 300;\n"
    "    const MOVED_PERMANENTLY = 301;\n"
    "    const FOUND = 302;\n"
    "    const SEE_OTHER = 303;\n"
    "    const NOT_MODIFIED = 304;\n"
    "    const USE_PROXY = 305;\n"
    "    const SWITCH_PROXY = 306;\n"
    "    const TEMPORARY_REDIRECT = 307;\n"
    "    const PERMANENT_REDIRECT = 308;\n"
    "    const BAD_REQUEST = 400;\n"
    "    const UNAUTHORIZED = 401;\n"
    "    const PAYMENT_REQUIRED = 402;\n"
    "    const FORBIDDEN = 403;\n"
    "    const NOT_FOUND = 404;\n"
    "    const METHOD_NOT_ALLOWED = 405;\n"
    "    const NOT_ACCEPTABLE = 406;\n"
    "    const PROXY_AUTHENTICATION_REQUIRED = 407;\n"
    "    const REQUEST_TIME_OUT = 408;\n"
    "    const CONFLICT = 409;\n"
    "    const GONE = 410;\n"
    "    const LENGTH_REQUIRED = 411;\n"
    "    const PRECONDITION_FAILED = 412;\n"
    "    const REQUEST_ENTITY_TOO_LARGE = 413;\n"
    "    const REQUEST_URI_TOO_LARGE = 414;\n"
    "    const UNSUPPORTED_MEDIA_TYPE = 415;\n"
    "    const REQUESTED_RANGE_NOT_SATISFIABLE = 416;\n"
    "    const EXPECTATION_FAILED = 417;\n"
    "    const MISDIRECTED_REQUEST = 421;\n"
    "    const UNPROCESSABLE_ENTITY = 422;\n"
    "    const LOCKED = 423;\n"
    "    const FAILED_DEPENDENCY = 424;\n"
    "    const UNORDERED_COLLECTION = 425;\n"
    "    const UPGRADE_REQUIRED = 426;\n"
    "    const PRECONDITION_REQUIRED = 428;\n"
    "    const TOO_MANY_REQUESTS = 429;\n"
    "    const REQUEST_HEADER_FIELDS_TOO_LARGE = 431;\n"
    "    const UNAVAILABLE_FOR_LEGAL_REASONS = 451;\n"
    "    const INTERNAL_SERVER_ERROR = 500;\n"
    "    const NOT_IMPLEMENTED = 501;\n"
    "    const BAD_GATEWAY = 502;\n"
    "    const SERVICE_UNAVAILABLE = 503;\n"
    "    const GATEWAY_TIME_OUT = 504;\n"
    "    const HTTP_VERSION_NOT_SUPPORTED = 505;\n"
    "    const VARIANT_ALSO_NEGOTIATES = 506;\n"
    "    const INSUFFICIENT_STORAGE = 507;\n"
    "    const LOOP_DETECTED = 508;\n"
    "    const NOT_EXTENDED = 510;\n"
    "    const NETWORK_AUTHENTICATION_REQUIRED = 511;\n"
    "\n"
    "    protected static $reasonPhrases = [\n"
    "        self::CONTINUE => 'Continue',\n"
    "        self::SWITCHING_PROTOCOLS => 'Switching Protocols',\n"
    "        self::PROCESSING => 'Processing',\n"
    "        self::OK => 'OK',\n"
    "        self::CREATED => 'Created',\n"
    "        self::ACCEPTED => 'Accepted',\n"
    "        self::NON_AUTHORITATIVE_INFORMATION => 'Non-Authoritative Information',\n"
    "        self::NO_CONTENT => 'No Content',\n"
    "        self::RESET_CONTENT => 'Reset Content',\n"
    "        self::PARTIAL_CONTENT => 'Partial Content',\n"
    "        self::MULTI_STATUS => 'Multi-status',\n"
    "        self::ALREADY_REPORTED => 'Already Reported',\n"
    "        self::IM_USED => 'IM Used',\n"
    "        self::MULTIPLE_CHOICES => 'Multiple Choices',\n"
    "        self::MOVED_PERMANENTLY => 'Moved Permanently',\n"
    "        self::FOUND => 'Found',\n"
    "        self::SEE_OTHER => 'See Other',\n"
    "        self::NOT_MODIFIED => 'Not Modified',\n"
    "        self::USE_PROXY => 'Use Proxy',\n"
    "        self::SWITCH_PROXY => 'Switch Proxy',\n"
    "        self::TEMPORARY_REDIRECT => 'Temporary Redirect',\n"
    "        self::PERMANENT_REDIRECT => 'Permanent Redirect',\n"
    "        self::BAD_REQUEST => 'Bad Request',\n"
    "        self::UNAUTHORIZED => 'Unauthorized',\n"
    "        self::PAYMENT_REQUIRED => 'Payment Required',\n"
    "        self::FORBIDDEN => 'Forbidden',\n"
    "        self::NOT_FOUND => 'Not Found',\n"
    "        self::METHOD_NOT_ALLOWED => 'Method Not Allowed',\n"
    "        self::NOT_ACCEPTABLE => 'Not Acceptable',\n"
    "        self::PROXY_AUTHENTICATION_REQUIRED => 'Proxy Authentication Required',\n"
    "        self::REQUEST_TIME_OUT => 'Request Time-out',\n"
    "        self::CONFLICT => 'Conflict',\n"
    "        self::GONE => 'Gone',\n"
    "        self::LENGTH_REQUIRED => 'Length Required',\n"
    "        self::PRECONDITION_FAILED => 'Precondition Failed',\n"
    "        self::REQUEST_ENTITY_TOO_LARGE => 'Request Entity Too Large',\n"
    "        self::REQUEST_URI_TOO_LARGE => 'Request-URI Too Large',\n"
    "        self::UNSUPPORTED_MEDIA_TYPE => 'Unsupported Media Type',\n"
    "        self::REQUESTED_RANGE_NOT_SATISFIABLE => 'Requested range not satisfiable',\n"
    "        self::EXPECTATION_FAILED => 'Expectation Failed',\n"
    "        self::MISDIRECTED_REQUEST => 'Unprocessable Entity',\n"
    "        self::UNPROCESSABLE_ENTITY => 'Unprocessable Entity',\n"
    "        self::LOCKED => 'Locked',\n"
    "        self::FAILED_DEPENDENCY => 'Failed Dependency',\n"
    "        self::UNORDERED_COLLECTION => 'Unordered Collection',\n"
    "        self::UPGRADE_REQUIRED => 'Upgrade Required',\n"
    "        self::PRECONDITION_REQUIRED => 'Precondition Required',\n"
    "        self::TOO_MANY_REQUESTS => 'Too Many Requests',\n"
    "        self::REQUEST_HEADER_FIELDS_TOO_LARGE => 'Request Header Fields Too Large',\n"
    "        self::UNAVAILABLE_FOR_LEGAL_REASONS => 'Unavailable For Legal Reasons',\n"
    "        self::INTERNAL_SERVER_ERROR => 'Internal Server Error',\n"
    "        self::NOT_IMPLEMENTED => 'Not Implemented',\n"
    "        self::BAD_GATEWAY => 'Bad Gateway',\n"
    "        self::SERVICE_UNAVAILABLE => 'Service Unavailable',\n"
    "        self::GATEWAY_TIME_OUT => 'Gateway Time-out',\n"
    "        self::HTTP_VERSION_NOT_SUPPORTED => 'HTTP Version not supported',\n"
    "        self::VARIANT_ALSO_NEGOTIATES => 'Variant Also Negotiates',\n"
    "        self::INSUFFICIENT_STORAGE => 'Insufficient Storage',\n"
    "        self::LOOP_DETECTED => 'Loop Detected',\n"
    "        self::NOT_EXTENDED => 'Not Extended',\n"
    "        self::NETWORK_AUTHENTICATION_REQUIRED => 'Network Authentication Required'\n"
    "    ];\n"
    "\n"
    "    /**\n"
    "     * getReasonPhrase\n"
    "     * @param int $value\n"
    "     * @return string\n"
    "     */\n"
    "    public static function getReasonPhrase(int $value): string\n"
    "    {\n"
    "        return static::$reasonPhrases[$value] ?? 'Unknown';\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_curl_handler =
    "\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "\n"
    "use Swoole;\n"
    "use Swoole\\Coroutine\\Http\\Client;\n"
    "use CURLFile;\n"
    "use Iterator;\n"
    "\n"
    "class Handler\n"
    "{\n"
    "    private const ERRORS = [\n"
    "        CURLE_URL_MALFORMAT => 'No URL set!',\n"
    "    ];\n"
    "\n"
    "    /**\n"
    "     * @var Client\n"
    "     */\n"
    "    private $client;\n"
    "    private $info = [\n"
    "        'url' => '',\n"
    "        'content_type' => '',\n"
    "        'http_code' => 0,\n"
    "        'header_size' => 0,\n"
    "        'request_size' => 0,\n"
    "        'filetime' => -1,\n"
    "        'ssl_verify_result' => 0,\n"
    "        'redirect_count' => 0,\n"
    "        'total_time' => 5.3E-5,\n"
    "        'namelookup_time' => 0.0,\n"
    "        'connect_time' => 0.0,\n"
    "        'pretransfer_time' => 0.0,\n"
    "        'size_upload' => 0.0,\n"
    "        'size_download' => 0.0,\n"
    "        'speed_download' => 0.0,\n"
    "        'speed_upload' => 0.0,\n"
    "        'download_content_length' => -1.0,\n"
    "        'upload_content_length' => -1.0,\n"
    "        'starttransfer_time' => 0.0,\n"
    "        'redirect_time' => 0.0,\n"
    "        'redirect_url' => '',\n"
    "        'primary_ip' => '',\n"
    "        'certinfo' => [],\n"
    "        'primary_port' => 0,\n"
    "        'local_ip' => '',\n"
    "        'local_port' => 0,\n"
    "        'http_version' => 0,\n"
    "        'protocol' => 0,\n"
    "        'ssl_verifyresult' => 0,\n"
    "        'scheme' => '',\n"
    "    ];\n"
    "    private $urlInfo;\n"
    "    private $postData;\n"
    "    private $outputStream;\n"
    "    private $proxy;\n"
    "    private $clientOptions = [];\n"
    "    private $followLocation = false;\n"
    "    private $maxRedirs;\n"
    "    private $withHeader = false;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $headerFunction;\n"
    "    /** @var callable */\n"
    "    private $readFunction;\n"
    "    /** @var callable */\n"
    "    private $writeFunction;\n"
    "    /** @var callable */\n"
    "    private $progressFunction;\n"
    "\n"
    "    public $returnTransfer = false;\n"
    "    public $method = 'GET';\n"
    "    public $headers = [];\n"
    "\n"
    "    public $errCode = 0;\n"
    "    public $errMsg = '';\n"
    "\n"
    "    public function __construct($url = null)\n"
    "    {\n"
    "        if ($url) {\n"
    "            $this->create($url);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    private function create(string $url): void\n"
    "    {\n"
    "        if (!swoole_string($url)->contains('://')) {\n"
    "            $url = 'http://' . $url;\n"
    "        }\n"
    "        $this->info['url'] = $url;\n"
    "        $info = parse_url($url);\n"
    "        $proto = swoole_array_default_value($info, 'scheme');\n"
    "        if ($proto != 'http' and $proto != 'https') {\n"
    "            $this->setError(CURLE_UNSUPPORTED_PROTOCOL, \"Protocol \\\"{$proto}\\\" not supported or disabled in libcurl\");\n"
    "            return;\n"
    "        }\n"
    "        $ssl = $proto === 'https';\n"
    "        if (empty($info['port'])) {\n"
    "            $port = $ssl ? 443 : 80;\n"
    "        } else {\n"
    "            $port = intval($info['port']);\n"
    "        }\n"
    "        $this->urlInfo = $info;\n"
    "        $this->client = new Client($info['host'], $port, $ssl);\n"
    "    }\n"
    "\n"
    "    public function execute()\n"
    "    {\n"
    "        $this->info['redirect_count'] = $this->info['starttransfer_time'] = 0;\n"
    "        $this->info['redirect_url'] = '';\n"
    "        $timeBegin = microtime(true);\n"
    "        /**\n"
    "         * Socket\n"
    "         */\n"
    "        $client = $this->client;\n"
    "        if (!$client) {\n"
    "            if (!$this->errCode) {\n"
    "                $this->setError(CURLE_URL_MALFORMAT);\n"
    "            }\n"
    "            return false;\n"
    "        }\n"
    "        $isRedirect = false;\n"
    "        do {\n"
    "            if ($isRedirect and !$client) {\n"
    "                $proto = swoole_array_default_value($this->urlInfo, 'scheme');\n"
    "                if ($proto != 'http' and $proto != 'https') {\n"
    "                    $this->setError(CURLE_UNSUPPORTED_PROTOCOL, \"Protocol \\\"{$proto}\\\" not supported or disabled in libcurl\");\n"
    "                    return false;\n"
    "                }\n"
    "                $ssl = $proto === 'https';\n"
    "                if (empty($this->urlInfo['port'])) {\n"
    "                    $port = $ssl ? 443 : 80;\n"
    "                } else {\n"
    "                    $port = intval($this->urlInfo['port']);\n"
    "                }\n"
    "                $client = new Client($this->urlInfo['host'], $port, $ssl);\n"
    "            }\n"
    "            /**\n"
    "             * Http Proxy\n"
    "             */\n"
    "            if ($this->proxy) {\n"
    "                list($proxy_host, $proxy_port) = explode(':', $this->proxy);\n"
    "                if (!filter_var($proxy_host, FILTER_VALIDATE_IP)) {\n"
    "                    $ip = Swoole\\Coroutine::gethostbyname($proxy_host);\n"
    "                    if (!$ip) {\n"
    "                        $this->setError(CURLE_COULDNT_RESOLVE_PROXY, 'Could not resolve proxy: ' . $proxy_host);\n"
    "                        return false;\n"
    "                    } else {\n"
    "                        $proxy_host = $ip;\n"
    "                    }\n"
    "                }\n"
    "                $client->set(['http_proxy_host' => $proxy_host, 'http_proxy_port' => $proxy_port]);\n"
    "            }\n"
    "            /**\n"
    "             * Client Options\n"
    "             */\n"
    "            if ($this->clientOptions) {\n"
    "                $client->set($this->clientOptions);\n"
    "            }\n"
    "            $client->setMethod($this->method);\n"
    "            /**\n"
    "             * Upload File\n"
    "             */\n"
    "            if ($this->postData and is_array($this->postData)) {\n"
    "                foreach ($this->postData as $k => $v) {\n"
    "                    if ($v instanceof CURLFile) {\n"
    "                        $client->addFile($v->getFilename(), $k, $v->getMimeType() ?: 'application/octet-stream', $v->getPostFilename());\n"
    "                        unset($this->postData[$k]);\n"
    "                    }\n"
    "                }\n"
    "            }\n"
    "            /**\n"
    "             * Post Data\n"
    "             */\n"
    "            if ($this->postData) {\n"
    "                if (is_string($this->postData) and empty($this->headers['Content-Type'])) {\n"
    "                    $this->headers['Content-Type'] = 'application/x-www-form-urlencoded';\n"
    "                }\n"
    "                $client->setData($this->postData);\n"
    "                $this->postData = [];\n"
    "            }\n"
    "            /**\n"
    "             * Http Header\n"
    "             */\n"
    "            $this->headers['Host'] = $this->urlInfo['host'] . (isset($this->urlInfo['port']) ? (':' . $this->urlInfo['port']) : '');\n"
    "            $client->setHeaders($this->headers);\n"
    "            /**\n"
    "             * Execute\n"
    "             */\n"
    "            $executeResult = $client->execute($this->getUrl());\n"
    "            if (!$executeResult) {\n"
    "                $errCode = $client->errCode;\n"
    "                if ($errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_FAILED or $errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_TIMEOUT) {\n"
    "                    $this->setError(CURLE_COULDNT_RESOLVE_HOST, 'Could not resolve host: ' . $client->host);\n"
    "                }\n"
    "                $this->info['total_time'] = microtime(true) - $timeBegin;\n"
    "                return false;\n"
    "            }\n"
    "            if ($client->statusCode >= 300 and $client->statusCode < 400 and isset($client->headers['location'])) {\n"
    "                $redirectParsedUrl = $this->getRedirectUrl($client->headers['location']);\n"
    "                $redirectUrl = $this->unparseUrl($redirectParsedUrl);\n"
    "                if ($this->followLocation and (null === $this->maxRedirs or $this->info['redirect_count'] < $this->maxRedirs)) {\n"
    "                    $isRedirect = true;\n"
    "                    if (0 === $this->info['redirect_count']) {\n"
    "                        $this->info['starttransfer_time'] = microtime(true) - $timeBegin;\n"
    "                        $redirectBeginTime = microtime(true);\n"
    "                    }\n"
    "                    // force GET\n"
    "                    if (in_array($client->statusCode, [301, 302, 303])) {\n"
    "                        $this->method = 'GET';\n"
    "                    }\n"
    "                    if ($this->urlInfo['host'] !== $redirectParsedUrl['host'] or ($this->urlInfo['port'] ?? null) !== ($redirectParsedUrl['port'] ?? null) or $this->urlInfo['scheme'] !== $redirectParsedUrl['scheme']) {\n"
    "                        // If host, port, and scheme are the same, reuse $client. Otherwise, release the old $client\n"
    "                        $client = null;\n"
    "                    }\n"
    "                    $this->urlInfo = $redirectParsedUrl;\n"
    "                    $this->info['url'] = $redirectUrl;\n"
    "                    $this->info['redirect_count']++;\n"
    "                } else {\n"
    "                    $this->info['redirect_url'] = $redirectUrl;\n"
    "                    break;\n"
    "                }\n"
    "            } else {\n"
    "                break;\n"
    "            }\n"
    "        } while (true);\n"
    "        $this->info['total_time'] = microtime(true) - $timeBegin;\n"
    "        $this->info['http_code'] = $client->statusCode;\n"
    "        $this->info['content_type'] = $client->headers['content-type'] ?? '';\n"
    "        $this->info['size_download'] = $this->info['download_content_length'] = strlen($client->body);;\n"
    "        $this->info['speed_download'] = 1 / $this->info['total_time'] * $this->info['size_download'];\n"
    "        if (isset($redirectBeginTime)) {\n"
    "            $this->info['redirect_time'] = microtime(true) - $redirectBeginTime;\n"
    "        }\n"
    "\n"
    "        $headerContent = '';\n"
    "        if ($client->headers) {\n"
    "            $cb = $this->headerFunction;\n"
    "            if ($client->statusCode > 0) {\n"
    "                $row = 'HTTP/1.1 ' . $client->statusCode . ' ' . Swoole\\Http\\StatusCode::getReasonPhrase($client->statusCode) . \"\\r\\n\";\n"
    "                if ($cb) {\n"
    "                    $cb($this, $row);\n"
    "                }\n"
    "                $headerContent .= $row;\n"
    "            }\n"
    "            foreach ($client->headers as $k => $v) {\n"
    "                $row = \"$k: $v\\r\\n\";\n"
    "                if ($cb) {\n"
    "                    $cb($this, $row);\n"
    "                }\n"
    "                $headerContent .= $row;\n"
    "            }\n"
    "            $headerContent .= \"\\r\\n\";\n"
    "            $this->info['header_size'] = strlen($headerContent);\n"
    "            if ($cb) {\n"
    "                $cb($this, '');\n"
    "            }\n"
    "        } else {\n"
    "            $this->info['header_size'] = 0;\n"
    "        }\n"
    "\n"
    "        if ($client->body and $this->readFunction) {\n"
    "            $cb = $this->readFunction;\n"
    "            $cb($this, $this->outputStream, strlen($client->body));\n"
    "        }\n"
    "\n"
    "        if ($this->withHeader) {\n"
    "            $transfer = $headerContent . $client->body;\n"
    "        } else {\n"
    "            $transfer = $client->body;\n"
    "        }\n"
    "\n"
    "        if ($this->returnTransfer) {\n"
    "            return $transfer;\n"
    "        } else {\n"
    "            if ($this->outputStream) {\n"
    "                return fwrite($this->outputStream, $transfer) === strlen($transfer);\n"
    "            } else {\n"
    "                echo $transfer;\n"
    "            }\n"
    "            return true;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function close(): void\n"
    "    {\n"
    "        $this->client = null;\n"
    "    }\n"
    "\n"
    "    private function setError($code, $msg = ''): void\n"
    "    {\n"
    "        $this->errCode = $code;\n"
    "        $this->errMsg = $msg ? $msg : self::ERRORS[$code];\n"
    "    }\n"
    "\n"
    "    private function getUrl(): string\n"
    "    {\n"
    "        if (empty($this->urlInfo['path'])) {\n"
    "            $url = '/';\n"
    "        } else {\n"
    "            $url = $this->urlInfo['path'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['query'])) {\n"
    "            $url .= '?' . $this->urlInfo['query'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['fragment'])) {\n"
    "            $url .= '#' . $this->urlInfo['fragment'];\n"
    "        }\n"
    "        return $url;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $opt\n"
    "     * @param $value\n"
    "     * @return bool\n"
    "     * @throws Swoole\\Curl\\Exception\n"
    "     */\n"
    "    public function setOption(int $opt, $value): bool\n"
    "    {\n"
    "        switch ($opt) {\n"
    "            /**\n"
    "             * Basic\n"
    "             */\n"
    "            case CURLOPT_URL:\n"
    "                $this->create($value);\n"
    "                break;\n"
    "            case CURLOPT_RETURNTRANSFER:\n"
    "                $this->returnTransfer = $value;\n"
    "                break;\n"
    "            case CURLOPT_ENCODING:\n"
    "                if (empty($value)) {\n"
    "                    $value = 'gzip';\n"
    "                }\n"
    "                $this->headers['Accept-Encoding'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXY:\n"
    "                $this->proxy = $value;\n"
    "                break;\n"
    "            /**\n"
    "             * Http Post\n"
    "             */\n"
    "            case CURLOPT_POST:\n"
    "                $this->method = 'POST';\n"
    "                break;\n"
    "            case CURLOPT_POSTFIELDS:\n"
    "                $this->postData = $value;\n"
    "                $this->method = 'POST';\n"
    "                break;\n"
    "            /**\n"
    "             * Upload\n"
    "             */\n"
    "            case CURLOPT_SAFE_UPLOAD:\n"
    "                if (!$value) {\n"
    "                    trigger_error('curl_setopt(): Disabling safe uploads is no longer supported', E_USER_WARNING);\n"
    "                }\n"
    "                break;\n"
    "            /**\n"
    "             * Http Header\n"
    "             */\n"
    "            case CURLOPT_HTTPHEADER:\n"
    "                if (!is_array($value) and !($value instanceof Iterator)) {\n"
    "                    trigger_error('swoole_curl_setopt(): You must pass either an object or an array with the CURLOPT_HTTPHEADER argument', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                foreach ($value as $header) {\n"
    "                    list($k, $v) = explode(':', $header);\n"
    "                    $v = trim($v);\n"
    "                    if ($v) {\n"
    "                        $this->headers[$k] = $v;\n"
    "                    }\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_REFERER:\n"
    "                $this->headers['Referer'] = $value;\n"
    "                break;\n"
    "\n"
    "            case CURLOPT_USERAGENT:\n"
    "                $this->headers['User-Agent'] = $value;\n"
    "                break;\n"
    "\n"
    "            case CURLOPT_CUSTOMREQUEST:\n"
    "                break;\n"
    "            case CURLOPT_PROTOCOLS:\n"
    "                if ($value > 3) {\n"
    "                    throw new Swoole\\Curl\\Exception(\"option[{$opt}={$value}] not supported\");\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_HTTP_VERSION:\n"
    "                if ($value != CURL_HTTP_VERSION_1_1) {\n"
    "                    trigger_error(\"swoole_curl: http version[{$value}] not supported\", E_USER_WARNING);\n"
    "                }\n"
    "                break;\n"
    "            /**\n"
    "             * Http Cookie\n"
    "             */\n"
    "            case CURLOPT_COOKIE:\n"
    "                $this->headers['Cookie'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_SSL_VERIFYHOST:\n"
    "                break;\n"
    "            case CURLOPT_SSL_VERIFYPEER:\n"
    "                $this->clientOptions['ssl_verify_peer'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT:\n"
    "                $this->clientOptions['connect_timeout'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT_MS:\n"
    "                $this->clientOptions['connect_timeout'] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT:\n"
    "                $this->clientOptions['timeout'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT_MS:\n"
    "                $this->clientOptions['timeout'] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_FILE:\n"
    "                $this->outputStream = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADER:\n"
    "                $this->withHeader = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADERFUNCTION:\n"
    "                $this->headerFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_READFUNCTION:\n"
    "                $this->readFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_WRITEFUNCTION:\n"
    "                $this->writeFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROGRESSFUNCTION:\n"
    "                $this->progressFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_USERPWD:\n"
    "                $this->headers['Authorization'] = 'Basic ' . base64_encode($value);\n"
    "                break;\n"
    "            case CURLOPT_FOLLOWLOCATION:\n"
    "                $this->followLocation = $value;\n"
    "                break;\n"
    "            case CURLOPT_MAXREDIRS:\n"
    "                $this->maxRedirs = $value;\n"
    "                break;\n"
    "            default:\n"
    "                throw new Swoole\\Curl\\Exception(\"option[{$opt}] not supported\");\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function reset(): void\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public function getInfo()\n"
    "    {\n"
    "        return $this->info;\n"
    "    }\n"
    "\n"
    "    private function unparseUrl(array $parsedUrl): string\n"
    "    {\n"
    "        $scheme = ($parsedUrl['scheme'] ?? 'http') . '://';\n"
    "        $host = $parsedUrl['host'] ?? '';\n"
    "        $port = isset($parsedUrl['port']) ? ':' . $parsedUrl['port'] : '';\n"
    "        $user = $parsedUrl['user'] ?? '';\n"
    "        $pass = isset($parsedUrl['pass']) ? ':' . $parsedUrl['pass'] : '';\n"
    "        $pass = ($user or $pass) ? \"$pass@\" : '';\n"
    "        $path = $parsedUrl['path'] ?? '';\n"
    "        $query = (isset($parsedUrl['query']) and '' !== $parsedUrl['query']) ? '?' . $parsedUrl['query'] : '';\n"
    "        $fragment = isset($parsedUrl['fragment']) ? '#' . $parsedUrl['fragment'] : '';\n"
    "        return $scheme . $user . $pass . $host . $port . $path . $query . $fragment;\n"
    "    }\n"
    "\n"
    "    private function getRedirectUrl(string $location): array\n"
    "    {\n"
    "        $uri = parse_url($location);\n"
    "        if (isset($uri['host'])) {\n"
    "            $redirectUri = $uri;\n"
    "        } else {\n"
    "            if (!isset($location[0])) {\n"
    "                return [];\n"
    "            }\n"
    "            $redirectUri = $this->urlInfo;\n"
    "            $redirectUri['query'] = '';\n"
    "            if ('/' === $location[0]) {\n"
    "                $redirectUri['path'] = $location;\n"
    "            } else {\n"
    "                $path = dirname($redirectUri['path'] ?? '');\n"
    "                if ('.' === $path) {\n"
    "                    $path = '/';\n"
    "                }\n"
    "                if (isset($location[1]) and './' === substr($location, 0, 2)) {\n"
    "                    $location = substr($location, 2);\n"
    "                }\n"
    "                $redirectUri['path'] = $path . $location;\n"
    "            }\n"
    "            foreach ($uri as $k => $v) {\n"
    "                if (!in_array($k, ['path', 'query'])) {\n"
    "                    $redirectUri[$k] = $v;\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "        return $redirectUri;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_ext_curl =
    "\n"
    "\n"
    "function swoole_curl_init($url = null): Swoole\\Curl\\Handler\n"
    "{\n"
    "    return new Swoole\\Curl\\Handler($url);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @param Swoole\\Curl\\Handler $obj\n"
    " * @param $opt\n"
    " * @param $value\n"
    " * @return bool\n"
    " * @throws Swoole\\Curl\\Exception\n"
    " */\n"
    "function swoole_curl_setopt(Swoole\\Curl\\Handler $obj, $opt, $value): bool\n"
    "{\n"
    "    return $obj->setOption($opt, $value);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @param Swoole\\Curl\\Handler $obj\n"
    " * @param $array\n"
    " * @return bool\n"
    " * @throws Swoole\\Curl\\Exception\n"
    " */\n"
    "function swoole_curl_setopt_array(Swoole\\Curl\\Handler $obj, $array): bool\n"
    "{\n"
    "    foreach ($array as $k => $v) {\n"
    "        if ($obj->setOption($k, $v) === false) {\n"
    "            return false;\n"
    "        }\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_curl_exec(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->execute();\n"
    "}\n"
    "\n"
    "function swoole_curl_close(Swoole\\Curl\\Handler $obj): void\n"
    "{\n"
    "    $obj->close();\n"
    "}\n"
    "\n"
    "function swoole_curl_error(Swoole\\Curl\\Handler $obj): string\n"
    "{\n"
    "    return $obj->errMsg;\n"
    "}\n"
    "\n"
    "function swoole_curl_errno(Swoole\\Curl\\Handler $obj): int\n"
    "{\n"
    "    return $obj->errCode;\n"
    "}\n"
    "\n"
    "function swoole_curl_reset(Swoole\\Curl\\Handler $obj): void\n"
    "{\n"
    "    $obj->reset();\n"
    "}\n"
    "\n"
    "function swoole_curl_getinfo(Swoole\\Curl\\Handler $obj, int $opt = 0)\n"
    "{\n"
    "    $info = $obj->getInfo();\n"
    "    if ($opt) {\n"
    "        switch ($opt) {\n"
    "            case CURLINFO_EFFECTIVE_URL:\n"
    "                return $info['url'];\n"
    "            case CURLINFO_HTTP_CODE:\n"
    "                return $info['http_code'];\n"
    "            case CURLINFO_CONTENT_TYPE:\n"
    "                return $info['content_type'];\n"
    "            case CURLINFO_REDIRECT_COUNT:\n"
    "                return $info['redirect_count'];\n"
    "            case CURLINFO_REDIRECT_URL:\n"
    "                return $info['redirect_url'];\n"
    "            case CURLINFO_TOTAL_TIME:\n"
    "                return $info['total_time'];\n"
    "            case CURLINFO_STARTTRANSFER_TIME:\n"
    "                return $info['starttransfer_time'];\n"
    "            case CURLINFO_SIZE_DOWNLOAD:\n"
    "                return $info['size_download'];\n"
    "            case CURLINFO_SPEED_DOWNLOAD:\n"
    "                return $info['speed_download'];\n"
    "            case CURLINFO_REDIRECT_TIME:\n"
    "                return $info['redirect_time'];\n"
    "            case CURLINFO_HEADER_SIZE:\n"
    "                return $info['header_size'];\n"
    "            default:\n"
    "                return null;\n"
    "        }\n"
    "    } else {\n"
    "        return $info;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_wait_group =
    "\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use BadMethodCallException;\n"
    "use InvalidArgumentException;\n"
    "\n"
    "class WaitGroup\n"
    "{\n"
    "    protected $chan;\n"
    "    protected $count = 0;\n"
    "    protected $waiting = false;\n"
    "\n"
    "    public function __construct()\n"
    "    {\n"
    "        $this->chan = new Channel(1);\n"
    "    }\n"
    "\n"
    "    public function add(int $delta = 1): void\n"
    "    {\n"
    "        if ($this->waiting) {\n"
    "            throw new BadMethodCallException('WaitGroup misuse: add called concurrently with wait');\n"
    "        }\n"
    "        $count = $this->count + $delta;\n"
    "        if ($count < 0) {\n"
    "            throw new InvalidArgumentException('negative WaitGroup counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "    }\n"
    "\n"
    "    public function done(): void\n"
    "    {\n"
    "        $count = $this->count - 1;\n"
    "        if ($count < 0) {\n"
    "            throw new BadMethodCallException('negative WaitGroup counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "        if ($count === 0 && $this->waiting) {\n"
    "            $this->chan->push(true);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function wait(float $timeout = -1): bool\n"
    "    {\n"
    "        if ($this->count > 0) {\n"
    "            $this->waiting = true;\n"
    "            $done = $this->chan->pop($timeout);\n"
    "            $this->waiting = false;\n"
    "            return $done;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_object_pool =
    "\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use BadMethodCallException;\n"
    "use InvalidArgumentException;\n"
    "use RuntimeException;\n"
    "use Swoole\\Coroutine;\n"
    "\n"
    "abstract class ObjectPool\n"
    "{\n"
    "    protected static $context = [];\n"
    "    protected $object_pool;\n"
    "    protected $busy_pool;\n"
    "    protected $type;\n"
    "\n"
    "    public function __construct($type, $pool_size = 10, $concurrency = 10)\n"
    "    {\n"
    "        if (empty($type)) {\n"
    "            throw new InvalidArgumentException('ObjectPool misuse: parameter type can not be empty');\n"
    "        }\n"
    "        if (!is_numeric($concurrency) || $concurrency <= 0) {\n"
    "            throw new InvalidArgumentException('ObjectPool misuse: parameter concurrency must larger than 0');\n"
    "        }\n"
    "\n"
    "        $this->object_pool = new Channel($pool_size);\n"
    "        $this->busy_pool = new Channel($concurrency);\n"
    "        $this->type = $type;\n"
    "    }\n"
    "\n"
    "    public function get()\n"
    "    {\n"
    "        $context = Coroutine::getContext();\n"
    "        if (!$context) {\n"
    "            throw new BadMethodCallException('ObjectPool misuse: get must be used in coroutine');\n"
    "        }\n"
    "        $type = $this->type;\n"
    "        Coroutine::defer(function () {\n"
    "            $this->free();\n"
    "        });\n"
    "        if (isset($context[$type])) {\n"
    "            return $context[$type];\n"
    "        }\n"
    "        if (!$this->object_pool->isEmpty()) {\n"
    "            $object = $this->object_pool->pop();\n"
    "            $context[\"new\"] = false;\n"
    "        } else {\n"
    "            /* create concurrency control */\n"
    "            $this->busy_pool->push(true);\n"
    "            $object = $this->create();\n"
    "            if (empty($object)) {\n"
    "                throw new RuntimeException('ObjectPool misuse: create object failed');\n"
    "            }\n"
    "            $context[\"new\"] = true;\n"
    "        }\n"
    "\n"
    "        $context[$type] = $object;\n"
    "        return $object;\n"
    "    }\n"
    "\n"
    "    public function free()\n"
    "    {\n"
    "        $context = Coroutine::getContext();\n"
    "        if (!$context) {\n"
    "            throw new BadMethodCallException('ObjectPool misuse: free must be used in coroutine');\n"
    "        }\n"
    "        $type = $this->type;\n"
    "        $object = $context[$type];\n"
    "        $this->object_pool->push($object);\n"
    "        if ($context[\"new\"]) {\n"
    "            $this->busy_pool->pop();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public abstract function create();\n"
    "}\n";

static const char* swoole_library_source_core_string_object =
    "\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class StringObject\n"
    "{\n"
    "    /**\n"
    "     * @var string\n"
    "     */\n"
    "    protected $string;\n"
    "\n"
    "    /**\n"
    "     * StringObject constructor.\n"
    "     * @param $string\n"
    "     */\n"
    "    public function __construct(string $string = '')\n"
    "    {\n"
    "        $this->string = $string;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return int\n"
    "     */\n"
    "    public function length(): int\n"
    "    {\n"
    "        return strlen($this->string);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $needle\n"
    "     * @param int $offset\n"
    "     * @return bool|int\n"
    "     */\n"
    "    public function indexOf(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $needle\n"
    "     * @param int $offset\n"
    "     * @return bool|int\n"
    "     */\n"
    "    public function lastIndexOf(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strrpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $needle\n"
    "     * @param int $offset\n"
    "     * @return bool|int\n"
    "     */\n"
    "    public function pos(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $needle\n"
    "     * @param int $offset\n"
    "     * @return bool|int\n"
    "     */\n"
    "    public function rpos(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strrpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $needle\n"
    "     * @return bool|int\n"
    "     */\n"
    "    public function ipos(string $needle)\n"
    "    {\n"
    "        return stripos($this->string, $needle);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function lower(): self\n"
    "    {\n"
    "        return new static(strtolower($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function upper(): self\n"
    "    {\n"
    "        return new static(strtoupper($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function trim(): self\n"
    "    {\n"
    "        return new static(trim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function lrim(): self\n"
    "    {\n"
    "        return new static(ltrim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function rtrim(): self\n"
    "    {\n"
    "        return new static(rtrim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $offset\n"
    "     * @param mixed ...$length\n"
    "     * @return static\n"
    "     */\n"
    "    public function substr(int $offset, ...$length): self\n"
    "    {\n"
    "        return new static(substr($this->string, $offset, ...$length));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $n\n"
    "     * @return StringObject\n"
    "     */\n"
    "    public function repeat($n)\n"
    "    {\n"
    "        return new static(str_repeat($this->string, $n));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $search\n"
    "     * @param string $replace\n"
    "     * @param null $count\n"
    "     * @return static\n"
    "     */\n"
    "    public function replace(string $search, string $replace, &$count = null): self\n"
    "    {\n"
    "        return new static(str_replace($search, $replace, $this->string, $count));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $needle\n"
    "     * @return bool\n"
    "     */\n"
    "    public function startsWith(string $needle): bool\n"
    "    {\n"
    "        return strpos($this->string, $needle) === 0;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $subString\n"
    "     * @return bool\n"
    "     */\n"
    "    public function contains(string $subString): bool\n"
    "    {\n"
    "        return strpos($this->string, $subString) !== false;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $needle\n"
    "     * @return bool\n"
    "     */\n"
    "    public function endsWith(string $needle): bool\n"
    "    {\n"
    "        return strrpos($this->string, $needle) === (strlen($needle) - 1);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $delimiter\n"
    "     * @param int $limit\n"
    "     * @return ArrayObject\n"
    "     */\n"
    "    public function split(string $delimiter, int $limit = PHP_INT_MAX): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(explode($delimiter, $this->string, $limit));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $index\n"
    "     * @return string\n"
    "     */\n"
    "    public function char(int $index): string\n"
    "    {\n"
    "        return $this->string[$index];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $chunkLength\n"
    "     * @param string $chunkEnd\n"
    "     * @return static\n"
    "     */\n"
    "    public function chunkSplit(int $chunkLength = 1, string $chunkEnd = ''): self\n"
    "    {\n"
    "        return new static(chunk_split($this->string, $chunkLength, $chunkEnd));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $splitLength\n"
    "     * @return ArrayObject\n"
    "     */\n"
    "    public function chunk($splitLength = 1): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(str_split($this->string, $splitLength));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return string\n"
    "     */\n"
    "    public function toString()\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return string\n"
    "     */\n"
    "    public function __toString(): string\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $value\n"
    "     * @return ArrayObject\n"
    "     */\n"
    "    protected static function detectArrayType(array $value): ArrayObject\n"
    "    {\n"
    "        return new ArrayObject($value);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_array_object =
    "\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use ArrayAccess;\n"
    "use Countable;\n"
    "use Iterator;\n"
    "use RuntimeException;\n"
    "use Serializable;\n"
    "\n"
    "class ArrayObject implements ArrayAccess, Serializable, Countable, Iterator\n"
    "{\n"
    "    /**\n"
    "     * @var array\n"
    "     */\n"
    "    protected $array;\n"
    "\n"
    "    /**\n"
    "     * ArrayObject constructor.\n"
    "     * @param array $array\n"
    "     */\n"
    "    public function __construct(array $array = [])\n"
    "    {\n"
    "        $this->array = $array;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return bool\n"
    "     */\n"
    "    public function isEmpty(): bool\n"
    "    {\n"
    "        return empty($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return int\n"
    "     */\n"
    "    public function count(): int\n"
    "    {\n"
    "        return count($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function current()\n"
    "    {\n"
    "        return current($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function key()\n"
    "    {\n"
    "        return key($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return bool\n"
    "     */\n"
    "    public function valid(): bool\n"
    "    {\n"
    "        return array_key_exists($this->key(), $this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function rewind()\n"
    "    {\n"
    "        return reset($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function next()\n"
    "    {\n"
    "        return next($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $key\n"
    "     * @return ArrayObject|StringObject|mixed\n"
    "     */\n"
    "    public function get($key)\n"
    "    {\n"
    "        return static::detectType($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $key\n"
    "     * @param $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function set($key, $value): self\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $key\n"
    "     * @return $this\n"
    "     */\n"
    "    public function delete($key): self\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $value\n"
    "     * @param bool $strict\n"
    "     * @param bool $loop\n"
    "     * @return $this\n"
    "     */\n"
    "    public function remove($value, bool $strict = true, bool $loop = false): self\n"
    "    {\n"
    "        do {\n"
    "            $key = $this->search($value, $strict);\n"
    "            if ($key) {\n"
    "                unset($this->array[$key]);\n"
    "            } else {\n"
    "                break;\n"
    "            }\n"
    "        } while ($loop);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function clear(): self\n"
    "    {\n"
    "        $this->array = [];\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return mixed|null\n"
    "     */\n"
    "    public function offsetGet($key)\n"
    "    {\n"
    "        if (!array_key_exists($key, $this->array)) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->array[$key];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @param mixed $value\n"
    "     */\n"
    "    public function offsetSet($key, $value)\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     */\n"
    "    public function offsetUnset($key)\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return bool\n"
    "     */\n"
    "    public function offsetExists($key)\n"
    "    {\n"
    "        return isset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $key\n"
    "     * @return bool\n"
    "     */\n"
    "    public function exists($key): bool\n"
    "    {\n"
    "        return array_key_exists($key, $this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $value\n"
    "     * @param bool $strict\n"
    "     * @return bool\n"
    "     */\n"
    "    public function contains($value, bool $strict = true): bool\n"
    "    {\n"
    "        return in_array($value, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $value\n"
    "     * @param bool $strict\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function indexOf($value, bool $strict = true)\n"
    "    {\n"
    "        return $this->search($value, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $value\n"
    "     * @param bool $strict\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function lastIndexOf($value, bool $strict = true)\n"
    "    {\n"
    "        $array = $this->array;\n"
    "        for (end($array); ($currentKey = key($array)) !== null; prev($array)) {\n"
    "            $currentValue = current($array);\n"
    "            if ($currentValue == $value) {\n"
    "                if ($strict && $currentValue !== $value) {\n"
    "                    continue;\n"
    "                }\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "        return $currentKey;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $needle\n"
    "     * @param $strict\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function search($needle, $strict = true)\n"
    "    {\n"
    "        return array_search($needle, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $glue\n"
    "     * @return StringObject\n"
    "     */\n"
    "    public function join(string $glue = ''): StringObject\n"
    "    {\n"
    "        return static::detectStringType(implode($glue, $this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return StringObject\n"
    "     */\n"
    "    public function serialize(): StringObject\n"
    "    {\n"
    "        return static::detectStringType(serialize($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $string\n"
    "     * @return $this\n"
    "     */\n"
    "    public function unserialize($string): self\n"
    "    {\n"
    "        $this->array = (array)unserialize($string);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function sum()\n"
    "    {\n"
    "        return array_sum($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function product()\n"
    "    {\n"
    "        return array_product($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function push($value)\n"
    "    {\n"
    "        return array_push($this->array, $value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function pushBack($value)\n"
    "    {\n"
    "        return array_unshift($this->array, $value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $offset\n"
    "     * @param $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function insert(int $offset, $value): self\n"
    "    {\n"
    "        if (is_array($value) || is_object($value) || is_null($value)) {\n"
    "            $value = [$value];\n"
    "        }\n"
    "        array_splice($this->array, $offset, 0, $value);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function pop()\n"
    "    {\n"
    "        return array_pop($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function popFront()\n"
    "    {\n"
    "        return array_shift($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $offset\n"
    "     * @param int $length\n"
    "     * @param bool $preserve_keys\n"
    "     * @return static\n"
    "     */\n"
    "    public function slice($offset, int $length = null, bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_slice($this->array, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ArrayObject|StringObject|mixed\n"
    "     */\n"
    "    public function randomGet()\n"
    "    {\n"
    "        return static::detectType($this->array[array_rand($this->array, 1)]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $fn callable\n"
    "     * @return $this\n"
    "     */\n"
    "    public function each(callable $fn): self\n"
    "    {\n"
    "        if (array_walk($this->array, $fn) === false) {\n"
    "            throw new RuntimeException('array_walk() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $fn callable\n"
    "     * @return static\n"
    "     */\n"
    "    public function map(callable $fn): self\n"
    "    {\n"
    "        return new static(array_map($fn, $this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $fn callable\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function reduce(callable $fn)\n"
    "    {\n"
    "        return array_reduce($this->array, $fn);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $search_value\n"
    "     * @param bool $strict\n"
    "     * @return static\n"
    "     */\n"
    "    public function keys(int $search_value = null, $strict = false): self\n"
    "    {\n"
    "        return new static(array_keys($this->array, $search_value, $strict));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function values(): self\n"
    "    {\n"
    "        return new static(array_values($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $column_key\n"
    "     * @param mixed ...$index\n"
    "     * @return static\n"
    "     */\n"
    "    public function column($column_key, ...$index): self\n"
    "    {\n"
    "        return new static(array_column($this->array, $column_key, ...$index));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_flags\n"
    "     * @return static\n"
    "     */\n"
    "    public function unique(int $sort_flags = SORT_STRING): self\n"
    "    {\n"
    "        return new static(array_unique($this->array, $sort_flags));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param bool $preserve_keys\n"
    "     * @return static\n"
    "     */\n"
    "    public function reverse(bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_reverse($this->array, $preserve_keys));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $size\n"
    "     * @param bool $preserve_keys\n"
    "     * @return static\n"
    "     */\n"
    "    public function chunk(int $size, bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_chunk($this->array, $size, $preserve_keys));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Swap keys and values in an array\n"
    "     * @return static\n"
    "     */\n"
    "    public function flip(): self\n"
    "    {\n"
    "        return new static(array_flip($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $fn callable\n"
    "     * @param int $flag\n"
    "     * @return static\n"
    "     */\n"
    "    public function filter(callable $fn, int $flag = 0): self\n"
    "    {\n"
    "        return new static(array_filter($this->array, $fn, $flag));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * | Function name     | Sorts by | Maintains key association   | Order of sort               | Related functions |\n"
    "     * | :---------------- | :------- | :-------------------------- | :-------------------------- | :---------------- |\n"
    "     * | array_multisort() | value    | associative yes, numeric no | first array or sort options | array_walk()      |\n"
    "     * | asort()           | value    | yes                         | low to high                 | arsort()          |\n"
    "     * | arsort()          | value    | yes                         | high to low                 | asort()           |\n"
    "     * | krsort()          | key      | yes                         | high to low                 | ksort()           |\n"
    "     * | ksort()           | key      | yes                         | low to high                 | asort()           |\n"
    "     * | natcasesort()     | value    | yes                         | natural, case insensitive   | natsort()         |\n"
    "     * | natsort()         | value    | yes                         | natural                     | natcasesort()     |\n"
    "     * | rsort()           | value    | no                          | high to low                 | sort()            |\n"
    "     * | shuffle()         | value    | no                          | random                      | array_rand()      |\n"
    "     * | sort()            | value    | no                          | low to high                 | rsort()           |\n"
    "     * | uasort()          | value    | yes                         | user defined                | uksort()          |\n"
    "     * | uksort()          | key      | yes                         | user defined                | uasort()          |\n"
    "     * | usort()           | value    | no                          | user defined                | uasort()          |\n"
    "     */\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_order\n"
    "     * @param int $sort_flags\n"
    "     * @return $this\n"
    "     */\n"
    "    public function multiSort(int $sort_order = SORT_ASC, int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (array_multisort($this->array, $sort_order, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('array_multisort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_flags\n"
    "     * @return $this\n"
    "     */\n"
    "    public function asort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (asort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('asort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_flags\n"
    "     * @return $this\n"
    "     */\n"
    "    public function arsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (arsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('arsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_flags\n"
    "     * @return $this\n"
    "     */\n"
    "    public function krsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (krsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('krsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_flags\n"
    "     * @return $this\n"
    "     */\n"
    "    public function ksort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (ksort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('ksort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natcasesort(): self\n"
    "    {\n"
    "        if (natcasesort($this->array) !== true) {\n"
    "            throw new RuntimeException('natcasesort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natsort(): self\n"
    "    {\n"
    "        if (natsort($this->array) !== true) {\n"
    "            throw new RuntimeException('natsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_flags\n"
    "     * @return $this\n"
    "     */\n"
    "    public function rsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (rsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('rsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function shuffle(): self\n"
    "    {\n"
    "        if (shuffle($this->array) !== true) {\n"
    "            throw new RuntimeException('shuffle() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int $sort_flags\n"
    "     * @return $this\n"
    "     */\n"
    "    public function sort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (sort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('sort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param callable $value_compare_func\n"
    "     * @return $this\n"
    "     */\n"
    "    public function uasort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (uasort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('uasort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param callable $value_compare_func\n"
    "     * @return $this\n"
    "     */\n"
    "    public function uksort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (uksort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('uksort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param callable $value_compare_func\n"
    "     * @return $this\n"
    "     */\n"
    "    public function usort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (usort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('usort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return array\n"
    "     */\n"
    "    public function __toArray(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $value\n"
    "     * @return ArrayObject|StringObject|mixed\n"
    "     */\n"
    "    protected static function detectType($value)\n"
    "    {\n"
    "        if (is_string($value)) {\n"
    "            return static::detectStringType($value);\n"
    "        } elseif (is_array($value)) {\n"
    "            return static::detectArrayType($value);\n"
    "        } else {\n"
    "            return $value;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $value\n"
    "     * @return StringObject\n"
    "     */\n"
    "    protected static function detectStringType(string $value): StringObject\n"
    "    {\n"
    "        return new StringObject($value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $value\n"
    "     * @return static\n"
    "     */\n"
    "    protected static function detectArrayType(array $value): self\n"
    "    {\n"
    "        return new static($value);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server =
    "\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Coroutine\\Server\\Connection;\n"
    "use Swoole\\Exception;\n"
    "\n"
    "class Server\n"
    "{\n"
    "    public $host;\n"
    "    public $port;\n"
    "    public $type;\n"
    "    public $fd;\n"
    "    public $errCode;\n"
    "\n"
    "    protected $running;\n"
    "\n"
    "    protected $fn = null;\n"
    "\n"
    "    /**\n"
    "     * @var Socket\n"
    "     */\n"
    "    protected $socket;\n"
    "\n"
    "    /**\n"
    "     * @var array\n"
    "     */\n"
    "    public $setting;\n"
    "\n"
    "    /**\n"
    "     * Server constructor.\n"
    "     * @param string $host\n"
    "     * @param int $port\n"
    "     * @param bool $ssl\n"
    "     * @throws Exception\n"
    "     */\n"
    "    public function __construct(string $host, int $port = 0, bool $ssl = false)\n"
    "    {\n"
    "        $_host = swoole_string($host);\n"
    "        if ($_host->contains('::')) {\n"
    "            $this->type = AF_INET6;\n"
    "        } else if ($_host->startsWith('unix:/')) {\n"
    "            $host = $_host->substr(5)->__toString();\n"
    "            $this->type = AF_UNIX;\n"
    "        } else {\n"
    "            $this->type = AF_INET;\n"
    "        }\n"
    "        $this->host = $host;\n"
    "\n"
    "        $sock = new Socket($this->type, SOCK_STREAM, 0);\n"
    "        if (!$sock->bind($this->host, $port)) {\n"
    "            throw new Exception(\"bind({$this->host}:$port) failed\", $sock->errCode);\n"
    "        }\n"
    "        if (!$sock->listen()) {\n"
    "            throw new Exception(\"listen() failed\", $sock->errCode);\n"
    "        }\n"
    "        $this->port = $sock->getsockname()['port'] ?? 0;\n"
    "        $this->fd = $sock->fd;\n"
    "        $this->socket = $sock;\n"
    "        $this->setting['open_ssl'] = $ssl;\n"
    "    }\n"
    "\n"
    "    public function set(array $setting)\n"
    "    {\n"
    "        $this->setting = array_merge($this->setting, $setting);\n"
    "    }\n"
    "\n"
    "    public function handle(callable $fn)\n"
    "    {\n"
    "        $this->fn = $fn;\n"
    "    }\n"
    "\n"
    "    public function shutdown()\n"
    "    {\n"
    "        $this->running = false;\n"
    "        return $this->socket->cancel();\n"
    "    }\n"
    "\n"
    "    public function start()\n"
    "    {\n"
    "        $this->running = true;\n"
    "        if ($this->fn == null) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "        $socket = $this->socket;\n"
    "        if (!$socket->setProtocol($this->setting)) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        while ($this->running) {\n"
    "            /**\n"
    "             * @var $conn Socket\n"
    "             */\n"
    "            $conn = $socket->accept();\n"
    "            if ($conn) {\n"
    "                $conn->setProtocol($this->setting);\n"
    "                if (Coroutine::create($this->fn, new Connection($conn)) < 0) {\n"
    "                    goto _wait;\n"
    "                }\n"
    "            } else {\n"
    "                if ($socket->errCode == SOCKET_EMFILE or $socket->errCode == SOCKET_ENFILE) {\n"
    "                    _wait:\n"
    "                    Coroutine::sleep(1);\n"
    "                    continue;\n"
    "                } elseif ($socket->errCode == SOCKET_ETIMEDOUT) {\n"
    "                    continue;\n"
    "                } elseif ($socket->errCode == SOCKET_ECANCELED) {\n"
    "                    break;\n"
    "                } else {\n"
    "                    trigger_error(\"accept failed, Error: {$socket->errMsg}[{$socket->errCode}]\", E_USER_WARNING);\n"
    "                    break;\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server_connection =
    "\n"
    "\n"
    "namespace Swoole\\Coroutine\\Server;\n"
    "\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "\n"
    "class Connection\n"
    "{\n"
    "    public $socket;\n"
    "\n"
    "    public function __construct(Socket $conn)\n"
    "    {\n"
    "        $this->socket = $conn;\n"
    "    }\n"
    "\n"
    "    public function recv($timeout = 0)\n"
    "    {\n"
    "        return $this->socket->recvPacket($timeout);\n"
    "    }\n"
    "\n"
    "    public function send($data)\n"
    "    {\n"
    "        return $this->socket->sendAll($data);\n"
    "    }\n"
    "\n"
    "    public function close()\n"
    "    {\n"
    "        return $this->socket->close();\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_functions =
    "\n"
    "if (ini_get('swoole.use_shortname') === 'On') {\n"
    "    /**\n"
    "     * @param string $string\n"
    "     * @return Swoole\\StringObject\n"
    "     */\n"
    "    function _string(string $string = ''): Swoole\\StringObject\n"
    "    {\n"
    "        return new Swoole\\StringObject($string);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $array\n"
    "     * @return Swoole\\ArrayObject\n"
    "     */\n"
    "    function _array(array $array = []): Swoole\\ArrayObject\n"
    "    {\n"
    "        return new Swoole\\ArrayObject($array);\n"
    "    }\n"
    "}\n"
    "\n"
    "/**\n"
    " * @param string $string\n"
    " * @return Swoole\\StringObject\n"
    " */\n"
    "function swoole_string(string $string = ''): Swoole\\StringObject\n"
    "{\n"
    "    return new Swoole\\StringObject($string);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @param array $array\n"
    " * @return Swoole\\ArrayObject\n"
    " */\n"
    "function swoole_array(array $array = []): Swoole\\ArrayObject\n"
    "{\n"
    "    return new Swoole\\ArrayObject($array);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @param array $array\n"
    " * @param $key\n"
    " * @param $default_value\n"
    " * @return mixed\n"
    " */\n"
    "function swoole_array_default_value(array $array, $key, $default_value = '')\n"
    "{\n"
    "    return array_key_exists($key, $array) ? $array[$key] : $default_value;\n"
    "}\n";

static const char* swoole_library_source_alias =
    "\n"
    "if (ini_get('swoole.use_shortname') === 'On') {\n"
    "    class_alias(Swoole\\Coroutine\\WaitGroup::class, Co\\WaitGroup::class, false);\n"
    "    class_alias(Swoole\\Coroutine\\Server::class, Co\\Server::class, false);\n"
    "}\n";

static const char* swoole_library_source_alias_ns =
    "\n"
    "\n"
    "namespace Swoole\\Coroutine {\n"
    "\n"
    "    function run(callable $fn, ...$args)\n"
    "    {\n"
    "        $s = new Scheduler();\n"
    "        $s->add($fn, ...$args);\n"
    "        return $s->start();\n"
    "    }\n"
    "\n"
    "}\n"
    "\n"
    "namespace Co {\n"
    "\n"
    "    if (ini_get('swoole.use_shortname') === 'On') {\n"
    "        function run(callable $fn, ...$args)\n"
    "        {\n"
    "            return \\Swoole\\Coroutine\\Run($fn, ...$args);\n"
    "        }\n"
    "    }\n"
    "\n"
    "}\n";

static void php_swoole_load_library()
{
    zend::eval(swoole_library_source_constants, "@swoole-src/library/constants.php");
    zend::eval(swoole_library_source_std_array, "@swoole-src/library/std/array.php");
    zend::eval(swoole_library_source_std_exec, "@swoole-src/library/std/exec.php");
    zend::eval(swoole_library_source_core_curl_exception, "@swoole-src/library/core/Curl/Exception.php");
    zend::eval(swoole_library_source_core_http_status_code, "@swoole-src/library/core/Http/StatusCode.php");
    zend::eval(swoole_library_source_core_curl_handler, "@swoole-src/library/core/Curl/Handler.php");
    zend::eval(swoole_library_source_ext_curl, "@swoole-src/library/ext/curl.php");
    zend::eval(swoole_library_source_core_coroutine_wait_group, "@swoole-src/library/core/Coroutine/WaitGroup.php");
    zend::eval(swoole_library_source_core_coroutine_object_pool, "@swoole-src/library/core/Coroutine/ObjectPool.php");
    zend::eval(swoole_library_source_core_string_object, "@swoole-src/library/core/StringObject.php");
    zend::eval(swoole_library_source_core_array_object, "@swoole-src/library/core/ArrayObject.php");
    zend::eval(swoole_library_source_core_coroutine_server, "@swoole-src/library/core/Coroutine/Server.php");
    zend::eval(swoole_library_source_core_coroutine_server_connection, "@swoole-src/library/core/Coroutine/Server/Connection.php");
    zend::eval(swoole_library_source_functions, "@swoole-src/library/functions.php");
    zend::eval(swoole_library_source_alias, "@swoole-src/library/alias.php");
    zend::eval(swoole_library_source_alias_ns, "@swoole-src/library/alias_ns.php");
}
