$(function() {
    var $wrapper = $('#wrapper');

    // theme switcher
    var theme_match = String(window.location).match(/[?&]theme=([a-z0-9]+)/);
    var theme = (theme_match && theme_match[1]) || 'default';
    var themes = ['default','legacy','bootstrap2','bootstrap3'];
    $('head').append('<link rel="stylesheet" href="/admin/css/selectize.' + theme + '.css">');

    var $themes = $('<div>').addClass('theme-selector').insertAfter('h1');
    for (var i = 0; i < themes.length; i++) {
        $themes.append('<a href="?theme=' + themes[i] + '"' + (themes[i] === theme ? ' class="active"' : '') + '>' + themes[i] + '</a>');
    }

    // display scripts on the page
    $('script', $wrapper).each(function() {
        var code = this.text;
        if (code && code.length) {
            var lines = code.split('\n');
            var indent = null;

            for (var i = 0; i < lines.length; i++) {
                if (/^[     ]*$/.test(lines[i])) continue;
                if (!indent) {
                    var lineindent = lines[i].match(/^([     ]+)/);
                    if (!lineindent) break;
                    indent = lineindent[1];
                }
                lines[i] = lines[i].replace(new RegExp('^' + indent), '');
            }

            var code = $.trim(lines.join('\n')).replace(/    /g, '    ');
            var $pre = $('<pre>').addClass('js').text(code);
            $pre.insertAfter(this);
        }
    });

    // show current input values
    $('select.selectized,input.selectized', $wrapper).each(function() {
        var $container = $('<div>').addClass('value').html('Current Value: ');
        var $value = $('<span>').appendTo($container);
        var $input = $(this);
        var update = function(e) { $value.text(JSON.stringify($input.val())); }

        $(this).on('change', update);
        update();

        $container.insertAfter($input);
    });
});