# Join Amaze UI


We would love for you to contribute to Amaze UI and help make it even better than it is today! 

We suggest new contributors to read following articles:

- [Contributing to Open Source on GitHub](https://guides.github.com/activities/contributing-to-open-source/)
- [The Beginner’s Guide to Contributing to Open Source Projects](http://blog.newrelic.com/2014/05/05/open-source_gettingstarted/)
- [How to Start Contributing to Open Source](http://www.developer.com/open/how-to-start-contributing-to-open-source.html)

## Reporting Bugs

- Search the [Issues](https://github.com/allmobilize/amazeui/issues/new?title=Bug%3A%20&body=**%E9%97%AE%E9%A2%98%E6%8F%8F%E8%BF%B0**%0A%0A%EF%BC%88%E6%8F%8F%E8%BF%B0%E4%B8%80%E4%B8%8B%E9%97%AE%E9%A2%98%EF%BC%89%0A%0A**%E4%BA%A7%E7%94%9F%E7%8E%AF%E5%A2%83**%0A%0A-%20%E6%93%8D%E4%BD%9C%E7%B3%BB%E7%BB%9F%E5%8F%8A%E7%89%88%E6%9C%AC%EF%BC%9A%0A-%20%E6%B5%8F%E8%A7%88%E5%99%A8%E5%8F%8A%E7%89%88%E6%9C%AC%EF%BC%9A%0A-%20%E6%BC%94%E7%A4%BA%E5%9C%B0%E5%9D%80%EF%BC%9A%0A%0A**%E5%A4%8D%E7%8E%B0%E6%AD%A5%E5%A5%8F**%0A%0A1.%20%0A2.%20%0A...) and relative comments before submitting a new issue. Probably your issue has been submitted. If this issue has already existed, you may simply add a comment on the former issue. 
Here are some tips for submitting issues:
- First check if your issue has been fixed in the latest version;
- Remove other libraries, and check if the bug is caused by other libraries;
- Describe the bug in detail, including the OS you were using, the browser you were using and their versions;
- Add some screen shot if possible.
- Use online pages to present your issue if possible. We recommend tools like JSBin.

In order to help recreate the bug, we use **[JSBin to build an online debugging tool](http://bin.amazeui.org)**. You can paste your code with issue in that tool and send it back to us.

**Bug Reporting Template**（[Click here to use](https://github.com/allmobilize/amazeui/issues/new?title=Bug%3A%20&body=**%E9%97%AE%E9%A2%98%E6%8F%8F%E8%BF%B0**%0A%0A%EF%BC%88%E6%8F%8F%E8%BF%B0%E4%B8%80%E4%B8%8B%E9%97%AE%E9%A2%98%EF%BC%89%0A%0A**%E4%BA%A7%E7%94%9F%E7%8E%AF%E5%A2%83**%0A%0A-%20%E6%93%8D%E4%BD%9C%E7%B3%BB%E7%BB%9F%E5%8F%8A%E7%89%88%E6%9C%AC%EF%BC%9A%0A-%20%E6%B5%8F%E8%A7%88%E5%99%A8%E5%8F%8A%E7%89%88%E6%9C%AC%EF%BC%9A%0A-%20%E6%BC%94%E7%A4%BA%E5%9C%B0%E5%9D%80%EF%BC%9A%0A%0A**%E5%A4%8D%E7%8E%B0%E6%AD%A5%E5%A5%8F**%0A%0A1.%20%0A2.%20%0A...)）

```
**Description**

(Describe your issue)

**Environment**

- Which OS are you using? Which version?
- Which browser are you using? Which version?
- Presentation URL

**How to recreate the bug**

1.
2.
...
```

## Need new functions?

We will try to satisfy all our users resonable need if it is not conflick with our goals and concepts. Please do following things before submitting your need:

- Visit our [website](http://amazeui.org/), and make sure that your need is currently not satisfied;
- Search in [Issues](https://github.com/allmobilize/amazeui/issues) and [Roadmap](https://github.com/allmobilize/amazeui/wiki/Roadmap), and make sure your need hasn't been submitted by others or in our plan;
- Make sure your need is not conflict with our concept (Amaze UI is built for modern browsers);
- Describe your need in detail. Examples are prefered.

## Pull Request

Please read [Amaze UI coding style](https://github.com/allmobilize/amazeui/wiki/Style-Guide) before submitting your pull request.

(We are still trying to figure out a standard testing procedure.)


## Things where we need your help

- Let us know your [project where you use Amaze UI](https://github.com/allmobilize/amazeui/wiki/Sites-Using-AmazeUI);
- Provide support to other CSS extension languages such as SCSS;
- Develop some template with Amaze UI;
- Provide support to frameworks like Angular.js, Ember.js, Meteor and etc;
- Develop Javascript plugins for Amaze UI;
- Compatibility test. We can only test on several most popular browsers. We hope users can help us test Amaze UI on different user agents;
- ...

## Documents

Development documents are in `docs/styleguide`, you can also find them in [our website](http://amazeui.org/):

- [Amaze UI HTML/CSS Coding Style](http://amazeui.org/getting-started/html-css)
- [Amaze UI JavaScript Coding Style](http://amazeui.org/getting-started/javascript)
- [Amaze UI Web Widget Coding Style](http://amazeui.org/getting-started/widget)
