# Close
---

A close button that can be combined with different components.


## Usage

Add `.am-close` class to elements。

`````html
<a href="#" class="am-close">&times;</a>
<br />
<button type="button" class="am-close">&times;</button>
`````

```html
<a href="#" class="am-close">&times;</a>

<button type="button" class="am-close">&times;</button>
```


## Style modifier

Add `.am-close-alt` class to use alternative style.

### Using x

`````html
<a href="" class="am-close am-close-alt">&times;</a>
`````

```html
<a href="" class="am-close am-close-alt">&times;</a>
```

### Using Icon Font

`````html
  <a href="" class="am-close am-close-alt am-icon-times"></a>
`````

```html
<a href="" class="am-close am-close-alt am-icon-times"></a>
```

### Center Align

<div class="am-alert am-alert-warning">
This problem is pretty exhausting. It's almost impossible achieve center align to all fonts. Now we have added styles using Icon Font. Please contact us if you have any better idea.
</div>

## Spin when Hover

Add `.am-close-spin` class (need support of [CSS3 transform](https://developer.mozilla.org/zh-CN/docs/Web/CSS/transform#.E6.97.8B.E8.BD.AC)).

`````html
<a href="" class="am-close am-close-alt am-close-spin">&times;</a>
<a href="" class="am-close am-close-alt am-close-spin am-icon-times"></a>
`````

```html
<a href="" class="am-close am-close-alt am-close-spin">&times;</a>
<a href="" class="am-close am-close-alt am-close-spin am-icon-times"></a>
```
