const util = require('../../../utils/util.js')
const wxRequest = require('.././../../utils/request.js');
Page({
  data: {
    fabulous: 123,
    isFabulous: false,
    isCollection: false,
    id: 0,
  },
  onLoad: function (options) {
    var that = this;
    that.setData({
      id: options.id,
    });
    wx.setNavigationBarTitle({
      title:options.title,
    });
    this.getArticle();
  },
  onShow: function () {
    var that = this;
    that.articleRead();
  },
  btnFabulous: function () {
    this.setData({
      fabulous: this.data.isFabulous ? 123 : 124,
      isFabulous: !this.data.isFabulous
    });
    this.articleClick();
  },
  getArticle: function () {
    var that = this;
    wxRequest.getRequest('v1/common/article/detail', { id: that.data.id }, function (res) {
      res.content = res.content.replace(/\<img/gi, '<img class="rich-img" ');
      that.setData({
        content: res,
      });
    });
  },
  articleClick: function () {
    wxRequest.postRequest('v1/common/article/click', { id: this.data.id }, function (res) {
    });
  },
  articleRead: function () {
    wxRequest.postRequest('v1/common/article/read', { id: this.data.id }, function (res) {
    });
  },
  onShareAppMessage: function () {
    // 页面被用户分享时执行
  },
})