const util = require('../../../utils/util.js');
const wxRequest = require('../../../utils/request.js');
const app = getApp();
Page({
  data: {
    staticUrl: app.data.sourceUrl,
    height: 64, //header高度
    top: 0, //标题图标距离顶部距离
    scrollH: 0, //滚动总高度
    opcity: 0,
    iconOpcity: 0.5,
    banner: [],
    bannerIndex: 0,
    topMenu: [{
      icon: "send",
      text: "路线规划",
      size: 26,
      badge: 0,
      url: "",
      type:'click',
      val:'route',
    }, 
    {
      icon: "house",
      text: "周边搜索",
      size: 26,
      badge: 0,
      url: "",
      type:'click',
      val:'choose',
    }, {
      icon: "explore",
      text: "地铁路线",
      size: 26,
      badge: 0,
      url: "",
      type:'click',
      val:'subway',
    },
    {
      icon: "message",
      text: "用户打卡",
      size: 26,
      badge: 0,
      url: "/pages/spot/card_list/card_list",
      type:'url',
      val:'feed_back',
    },
    {
      icon:"message",
      text:"我要打卡",
      size:26,
      badge:0,
      url:"/pages/spot/card/card",
      type:"url",
      val:'card'
    }
  ],
    menuShow: false,
    popupShow: false,
    value: 1,
    collected: false,
    left: 0,
    right: 10,
    bottom: 100,
    bgColor: "#5677fc",
    btnList: [],
    list: [
      {
      bgColor: "#16C2C2",
      //图标/图片地址
      imgUrl: "/static/images/fab/fab_about.png",
      //图片高度 rpx
      imgHeight: 64,
      //图片宽度 rpx
      imgWidth: 64,
      //名称
      text: "我要打卡",
      //字体大小
      fontSize: 34,
      //字体颜色
      color: "#fff"
    }, 
    {
      bgColor: "#64B532",
      //图标/图片地址
      imgUrl: "/static/images/fab/top.png",
      //图片高度 rpx
      imgHeight: 64,
      //图片宽度 rpx
      imgWidth: 64,
      //名称
      text: "回到顶部",
      //字体大小
      fontSize: 34,
      //字体颜色
      color: "#fff"
    }, 
    {
      bgColor: "#FFA000",
      //图标/图片地址
      imgUrl: "/static/images/fab/fab_reward.png",
      //图片高度 rpx
      imgHeight: 64,
      //图片宽度 rpx
      imgWidth: 64,
      //名称
      text: "赞赏",
      //字体大小
      fontSize: 34,
      //字体颜色
      color: "#fff"
    }],
    list2: [
      {
      bgColor: "#16C2C2",
      //名称
      text: "打卡",
      //字体大小
      fontSize: 28,
      //字体颜色
      color: "#fff"
    }, 
    {
      bgColor: "#64B532",
      //名称
      text: "回到顶部",
      //字体大小
      fontSize: 28,
      //字体颜色
      color: "#fff"
    }, 
    {
      bgColor: "#FFA000",
      //名称
      text: "赞赏",
      //字体大小
      fontSize: 28,
      //字体颜色
      color: "#fff"
    }],
    longitude:'',
    latitude:'',
    spotName:'',
  },
  onLoad: function (options) {
    var that = this;
    this.setData({
      btnList: [...this.data.list]
    });
    let obj = wx.getMenuButtonBoundingClientRect();
    that.setData({
      width: obj.left,
      height: obj.top + obj.height + 8,
      top: obj.top + (obj.height - 32) / 2
    }, () => {
      wx.getSystemInfo({
        success: (res) => {
          this.setData({
            scrollH: res.windowWidth
          })
        }
      })
    });
    // spot-detail
    if(options.id){
      that.spotDetail(options.id);
    }else{
      wx.navigateTo({
        url:'/pages/index/index'
      });
    }
  },
  bannerChange: function (e) {
    this.setData({
      bannerIndex: e.detail.current
    })
  },
  previewImage: function (e) {
    let index = e.currentTarget.dataset.index;
    wx.previewImage({
      current: this.data.banner[index],
      urls: this.data.banner
    })
  },
  //页面滚动执行方式
  onPageScroll(e) {
    let scroll = e.scrollTop <= 0 ? 0 : e.scrollTop;
    let opcity = scroll / this.data.scrollH;
    if (this.data.opcity >= 1 && opcity >= 1) {
      return;
    }
    this.setData({
      opcity: opcity,
      iconOpcity: 0.5 * (1 - opcity < 0 ? 0 : 1 - opcity)
    })
  },
  back: function () {
    wx.navigateBack()
  },
  openMenu: function () {
    this.setData({
      menuShow: true
    })
  },
  closeMenu: function () {
    this.setData({
      menuShow: false
    })
  },
  showPopup: function () {
    this.setData({
      popupShow: true
    })
  },
  hidePopup: function () {
    this.setData({
      popupShow: false
    })
  },
  change: function (e) {
    this.setData({
      value: e.detail.value
    })
  },
  collecting: function () {
    this.setData({
      collected: !this.data.collected
    })
  },
  common: function (e) {
    let url = e.currentTarget.dataset.url;
    let type = e.currentTarget.dataset.type;
    let val = e.currentTarget.dataset.val;
    if (type == 'click' && val == 'route'){
      this.mapRoute();
    }else if(type == 'click' && val == 'choose'){
      this.mapChoose();
    }else if(type == 'click' && val == 'subway'){
        this.subWay();
    }else if(type == 'url'){
      wx.navigateTo({
        url: url,
      });
    }
    
  },
  // 悬浮框
  onClick(e) {
    let index = e.detail.index
    switch (index) {
      case -1:
        util.toast("您点击了悬浮按钮")
        break;
      // case 0:
      //   wx.navigateTo({
      //     url: "/pages/spot/card/card"
      //   })
      //   break;
      case 0:
        this.goTop();
        break;
      case 1:
        wx.previewImage({
          urls: ["https://youpaiyun.qqdeveloper.com/wx_reward.jpeg"]
        });
        break;
      default:
        break;
    }
  },
  // 景点详情
  spotDetail:function(id=0){
    var that = this;
    wxRequest.getRequest('v1/common/spot/detail',{id:id},function(res){
      res.content = res.content.replace(/\<img/gi,'<img class="rich-img" ');
      that.setData({
        spotDetail:res,
        banner:res.images,
        longitude:res.longitude,
        latitude:res.latitude,
        spotName:res.name,
      }); 
    });
  },
  // 路线规划
  mapRoute:function(){
    let plugin = requirePlugin('routePlan');
    let key = 'CBTBZ-B5RWO-7K3WP-SMCLK-6WDA6-XUFY2';
    let referer = '路线规划';
    let endPoint = JSON.stringify({
        'name': this.data.spotName,
        'latitude': this.data.latitude,
        'longitude': this.data.longitude,
    });
    wx.navigateTo({
        url: 'plugin://routePlan/index?key=' + key + '&referer=' + referer + '&endPoint=' + endPoint
    });
  },
  mapChoose:function(){
    const key = 'CBTBZ-B5RWO-7K3WP-SMCLK-6WDA6-XUFY2';
    const referer = '附近搜索';
    const location = JSON.stringify({
      'latitude': this.data.latitude,
        'longitude': this.data.longitude,
    });
    const category = '生活服务,星级酒店,旅游景点';
    wx.navigateTo({
      url: 'plugin://chooseLocation/index?key=' + key + '&referer=' + referer + '&location=' + location + '&category=' + category
    });
  },
  subWay:function(){
    let plugin = requirePlugin("subway");
    let key = 'CBTBZ-B5RWO-7K3WP-SMCLK-6WDA6-XUFY2';
    let referer = '地铁路线';
    wx.navigateTo({
      url: 'plugin://subway/index?key=' + key + '&referer=' + referer
    });
  },
  onShareAppMessage: function () {
    // 页面被用户分享时执行
  },
   // 一键回到顶部
  goTop: function (e) { 
    if (wx.pageScrollTo) {
      wx.pageScrollTo({
        scrollTop: 0
      })
    } else {
      wx.showModal({
        title: '提示',
        content: '当前微信版本过低，无法使用该功能，请升级到最新微信版本后重试。'
      })
    }},
})