//公共js，主要做表单验证，以及基本方法封装
const utils = {
  isNullOrEmpty: function(value) {
    //是否为空
    return (value === null || value === '' || value === undefined) ? true : false;
  },
  trim: function(value) {
    //去空格
    return value.replace(/(^\s*)|(\s*$)/g, "");
  },
  isMobile: function(value) {
    //是否为手机号
    return /^(?:13\d|14\d|15\d|16\d|17\d|18\d|19\d)\d{5}(\d{3}|\*{3})$/.test(value);
  },
  isFloat: function(value) {
    //金额，只允许保留两位小数
    return /^([0-9]*[.]?[0-9])[0-9]{0,1}$/.test(value);
  },
  isNum: function(value) {
    //是否全为数字
    return /^[0-9]+$/.test(value);
  },
  formatNum: function(num) {
    //格式化手机号码
    if (utils.isMobile(num)) {
      num = num.replace(/^(\d{3})\d{4}(\d{4})$/, '$1****$2')
    }
    return num;
  },
  interfaceUrl: function() {
    //接口地址
    return "https://www.thorui.cn";
  },
  toast: function(text, duration, success) {
    wx.showToast({
      title: text,
      icon: success ? 'success' : 'none',
      duration: duration || 2000
    })
  },
  preventMultiple: function(fn, gapTime) {
    if (gapTime == null || gapTime == undefined) {
      gapTime = 200;
    }
    let lastTime = null;
    return function() {
      let now = +new Date();
      if (!lastTime || now - lastTime > gapTime) {
        fn.apply(this, arguments);
        lastTime = now;
      }
    }
  },
  request: function(url, postData, method, type, hideLoading) {
    //接口请求
    if (!hideLoading) {
      wx.showLoading({
        title: '请稍候...',
        mask: true
      })
    }
    return new Promise((resolve, reject) => {
      wx.request({
        url: this.interfaceUrl() + url,
        data: postData,
        header: {
          'content-type': type ? 'application/x-www-form-urlencoded' : 'application/json'
        },
        method: method, //'GET','POST'
        dataType: 'json',
        success: (res) => {
          !hideLoading && wx.hideLoading()
          resolve(res.data)
        },
        fail: (res) => {
          !hideLoading && this.toast("网络不给力，请稍后再试~")
          //wx.hideLoading()
          reject(res)
        }
      })
    })
  },
  uploadFile: function(src) {
    const that = this
    wx.showLoading({
      title: '请稍候...',
      mask: true
    })
    return new Promise((resolve, reject) => {
      const uploadTask = wx.uploadFile({
        url: 'http://39.108.124.252:8081/fileServce/file/ ', //测试地址,暂不使用
        filePath: src,
        name: 'file',
        header: {
          'content-type': 'multipart/form-data'
        },
        formData: {},
        success: function(res) {
          wx.hideLoading()
          let d = JSON.parse(res.data)
          if (d.code === 1) {
            let fileObj = JSON.parse(d.data)[0];
            //文件上传成功后把图片路径数据提交到服务器，数据提交成功后，再进行下张图片的上传
            resolve(fileObj)
          } else {
            that.toast(res.message);
          }
        },
        fail: function(res) {
          reject(res)
          wx.hideLoading();
          that.toast(res.message);
        }
      })
    })
  }
}
var t = function(t) {
  return (t = t.toString())[1] ? t : "0" + t;
};

var map = {
  formatTime: function(e) {
      var i = e.getFullYear(), n = e.getMonth() + 1, o = e.getDate(), c = e.getHours(), a = e.getMinutes(), r = e.getSeconds();
      return [ i, n, o ].map(t).join("/") + " " + [ c, a, r ].map(t).join(":");
  },
  isObjectValueEqual: function(t, e) {
      var i = Object.getOwnPropertyNames(t), n = Object.getOwnPropertyNames(e);
      if (i.length != n.length) return !1;
      for (var o = 0; o < i.length; o++) {
          var c = i[o];
          if (t[c] !== e[c]) return !1;
      }
      return !0;
  },
  clickBOSS: function(t) {
      wx.request({
          url: "https://btrace.qq.com/kvcollect?ip=&qq=&pac_uid=&ua=&platform=xcx&_dc=" + Math.random(),
          data: Object.assign({
              BossId: 5199,
              Pwd: 451708158
          }, t),
          success: function() {
              console.log("clickBOSS success");
          },
          fail: function() {
              console.log("clickBOSS fail");
          }
      });
  },
  videos: function(t) {
      wx.request({
          url: "https://pacaio.match.qq.com/vlike/detail?vid=" + t,
          success: function(e) {
              var i = e.data.data, n = i.title, o = i.img, c = i.likecount, a = void 0 === c ? 0 : c, r = i.view_count || i.viewcount;
              console.log(o, n, r), wx.navigateToMiniProgram({
                  appId: "wx0d7f9a7816347b3d",
                  path: "/pages/video/index?pgv_ref=tencenttianqi&id=" + t + "&title=" + n + "&img=" + o + "&view_count=" + r + "&likecount=" + a
              });
          }
      });
  }
};

module.exports = {
  isNullOrEmpty: utils.isNullOrEmpty,
  trim: utils.trim,
  isMobile: utils.isMobile,
  isFloat: utils.isFloat,
  isNum: utils.isNum,
  interfaceUrl: utils.interfaceUrl,
  toast: utils.toast,
  request: utils.request,
  uploadFile: utils.uploadFile,
  formatNum: utils.formatNum,
  clickBOSS:map.clickBOSS,
}