package main

import (
	"fmt"
	"io/ioutil"
	"net/http"
)

func main() {
	content := httpGet("https://api.api68.com/pks/getLotteryPksInfo.do?issue=&lotCode=10001")
	if content != "" {
		fmt.Println(content)
	}
}

func httpGet(url string) (content string) {
	resp, err1 := http.Get(url)
	if err1 != nil {
		return
	}
	defer resp.Body.Close()
	data, err2 := ioutil.ReadAll(resp.Body)
	if err2 != nil {
		return
	}
	content = string(data)
	return
}
